/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.matcher;

import java.util.List;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.matcher.StatelessInvocationMatcher;

public class ArgumentsMatcher
extends StatelessInvocationMatcher {
    private Constraint[] constraints;

    public ArgumentsMatcher(Constraint[] constraints) {
        this.constraints = (Constraint[])constraints.clone();
    }

    public boolean matches(Invocation invocation) {
        return this.constraints.length == invocation.parameterValues.size() && this.matchesValues(invocation.parameterValues);
    }

    private boolean matchesValues(List list) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i].eval(list.get(i))) continue;
            return false;
        }
        return true;
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append("( ");
        for (int i = 0; i < this.constraints.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.constraints[i].describeTo(buffer);
        }
        buffer.append(" )");
        return buffer;
    }
}

