/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar.util;

import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.util.PossibleNamesCollector;
import com.sun.msv.util.StringPair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NameClassSimplifier {
    public static NameClass simplify(NameClass nc) {
        Set<StringPair> possibleNames = PossibleNamesCollector.calc(nc);
        String MAGIC = "\u0000";
        HashSet<String> uris = new HashSet<String>();
        Iterator<StringPair> itr = possibleNames.iterator();
        while (itr.hasNext()) {
            StringPair name = itr.next();
            if (name.localName != "\u0000") {
                if (nc.accepts(name) == nc.accepts(name.namespaceURI, "\u0000")) {
                    itr.remove();
                    continue;
                }
            } else if (name.namespaceURI != "\u0000" && nc.accepts(name) == nc.accepts("\u0000", "\u0000")) {
                itr.remove();
                continue;
            }
            if (name.namespaceURI == "\u0000") continue;
            uris.add(name.namespaceURI);
        }
        if (!nc.accepts("\u0000", "\u0000")) {
            possibleNames.remove(new StringPair("\u0000", "\u0000"));
        }
        NameClass result = null;
        for (String uri : uris) {
            NameClass local = null;
            for (StringPair name : possibleNames) {
                if (!name.namespaceURI.equals(uri) || name.localName == "\u0000") continue;
                if (local == null) {
                    local = new SimpleNameClass(name);
                    continue;
                }
                local = new ChoiceNameClass(local, new SimpleNameClass(name));
            }
            if (possibleNames.contains(new StringPair(uri, "\u0000"))) {
                local = local == null ? new NamespaceNameClass(uri) : new DifferenceNameClass(new NamespaceNameClass(uri), local);
            }
            if (local == null) continue;
            if (result == null) {
                result = local;
                continue;
            }
            result = new ChoiceNameClass(result, local);
        }
        if (nc.accepts("\u0000", "\u0000")) {
            result = result == null ? NameClass.ALL : new NotNameClass(result);
        }
        if (result == null) {
            result = AnyNameClass.NONE;
        }
        return result;
    }
}

