/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.CachedRow;
import org.hsqldb.MemoryNode;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;

class PointerNode
extends MemoryNode {
    private int iId;
    private int iData = -1;
    private Table tTable;
    private int iRight = -1;

    PointerNode(CachedRow cachedRow) {
        this.tTable = cachedRow.getTable();
        if (cachedRow.iPos == -1) {
            this.rData = cachedRow;
        } else {
            this.iData = cachedRow.iPos;
        }
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iRight = 0;
        this.tTable = null;
    }

    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return this.iData;
    }

    void setKey(int n) {
        this.iData = n;
        this.rData = null;
    }

    Row getRow() throws SQLException {
        if (this.rData != null) {
            return this.rData;
        }
        if (this.iData == -1) {
            return null;
        }
        return this.tTable.getRow(this.iData);
    }

    private Node findNode(int n, int n2) throws SQLException {
        Node node = null;
        Row row = this.tTable.getRow(n);
        if (row != null) {
            node = row.getNode(n2);
        }
        return node;
    }

    Node getRight() throws SQLException {
        if (this.nRight != null) {
            return this.nRight;
        }
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight, this.iId);
    }

    Node getRightPointer() throws SQLException {
        return this.nRight;
    }

    void setRight(Node node) throws SQLException {
        this.iRight = -1;
        this.nRight = node;
    }

    void setNextKey(int n) throws SQLException {
        this.iRight = n;
        this.nRight = null;
    }

    Object[] getData() throws SQLException {
        return this.getRow().getData();
    }

    boolean equals(Node node) throws SQLException {
        return node == this;
    }
}

