/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.shared.http.NullOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HtmlFileListParser {
    public static List parseFileList(String baseurl, InputStream is) throws TransferFailedException {
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setErrout(new PrintWriter(new NullOutputStream()));
        Document doc = tidy.parseDOM(is, (OutputStream)new NullOutputStream());
        List links = new ArrayList();
        links = HtmlFileListParser.findAnchorLinks(links, baseurl, doc);
        return links;
    }

    private static List findAnchorLinks(List links, String baseurl, Node node) {
        String basepath = baseurl;
        int colslash = basepath.indexOf("://");
        if (colslash > 0) {
            int pathstart = basepath.indexOf(47, colslash + 3);
            basepath = pathstart > 0 ? baseurl.substring(pathstart) : "";
        }
        if (StringUtils.equalsIgnoreCase("a", node.getNodeName()) && node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String tst;
                String value;
                String key = attributes.item(i).getNodeName().toLowerCase();
                if (!"href".equals(key) || !StringUtils.isNotEmpty(value = attributes.item(i).getNodeValue())) continue;
                if (HtmlFileListParser.validFilename(value = StringUtils.trim(value))) {
                    links.add(value);
                    continue;
                }
                if (value.startsWith(baseurl) && HtmlFileListParser.validFilename(tst = value.substring(baseurl.length()))) {
                    links.add(tst);
                    continue;
                }
                if (!value.startsWith(basepath) || !HtmlFileListParser.validFilename(tst = value.substring(basepath.length()))) continue;
                links.add(tst);
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodes = node.getChildNodes();
            for (int nodenum = 0; nodenum < nodes.getLength(); ++nodenum) {
                HtmlFileListParser.findAnchorLinks(links, baseurl, nodes.item(nodenum));
            }
        }
        return links;
    }

    private static boolean validFilename(String tst) {
        Pattern badFilenames = Pattern.compile("[:?&@*]");
        if (badFilenames.matcher(tst).find()) {
            return false;
        }
        String tstpath = StringUtils.replace(tst, '\\', '/');
        int pathparts = StringUtils.countMatches(tstpath, "/");
        if (pathparts > 1) {
            return false;
        }
        return pathparts != 1 || tstpath.endsWith("/");
    }
}

