/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.processors;

import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.BasicContext;
import org.apache.stylebook.BasicParameters;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Processor;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class ImportProcessor
extends AbstractComponent
implements Processor {
    public Document process(Document document, CreationContext creationContext, Parameters parameters) throws CreationException, IOException {
        this.processNode(document.getDocumentElement(), document, creationContext);
        return document;
    }

    private void processNode(Node node, Document document, CreationContext creationContext) throws IOException, CreationException {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 7) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                this.processNode(nodeList.item(n), document, creationContext);
                ++n;
            }
            return;
        }
        ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
        if (processingInstruction.getTarget().equals("import")) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string = null;
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(processingInstruction.getData());
            while (stringTokenizer.hasMoreTokens()) {
                object4 = stringTokenizer.nextToken();
                object3 = new StringTokenizer((String)object4, "\"=", false);
                if (((StringTokenizer)object3).countTokens() != 2) {
                    throw new CreationException("Invalid parameter \"" + (String)object4 + "\"");
                }
                object2 = ((StringTokenizer)object3).nextToken();
                object = ((StringTokenizer)object3).nextToken();
                if (((String)object2).equals("producer")) {
                    string = object;
                    continue;
                }
                if (((String)object2).equals("source")) {
                    string2 = object;
                    continue;
                }
                throw new CreationException("Invalid parameter \"" + (String)object4 + "\"");
            }
            if (string == null) {
                throw new CreationException("Producer not specified");
            }
            this.log("Importing \"" + string2 + "\" using Producer \"" + string + "\"");
            object4 = new URL(creationContext.getSourceURL(), string2);
            object3 = new BasicContext((URL)object4, creationContext.getTargetName());
            ((BasicParameters)object3).merge(creationContext);
            object2 = this.engine.getProducer(string).produce((CreationContext)object3);
            object = this.copyNode(document, object2.getDocumentElement());
            if (object == null) {
                return;
            }
            processingInstruction.getParentNode().replaceChild((Node)object, processingInstruction);
        }
    }

    private Node copyNode(Document document, Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = null;
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                node2 = document.createElement(((Element)node).getTagName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    object = (Attr)namedNodeMap.item(n);
                    ((Element)node2).setAttribute(object.getName(), object.getValue());
                    ++n;
                }
                break;
            }
            case 4: {
                node2 = document.createCDATASection(((CharacterData)node).getData());
                break;
            }
            case 8: {
                node2 = document.createComment(((CharacterData)node).getData());
                break;
            }
            case 3: {
                node2 = document.createTextNode(((CharacterData)node).getData());
                break;
            }
            case 5: {
                node2 = document.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                Object object = ((ProcessingInstruction)node).getTarget();
                String string = ((ProcessingInstruction)node).getData();
                node2 = document.createProcessingInstruction((String)object, string);
            }
        }
        if (node2 == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node3 = this.copyNode(document, nodeList.item(n));
            if (node3 != null) {
                node2.appendChild(node3);
            }
            ++n;
        }
        return node2;
    }
}

