/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLGrammarPool {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final String PREFIX = "NS";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected int fNamespaceCounter = 1;
    protected final NamespaceSupport fNamespaceBinder = new NamespaceSupport();
    protected final NamespaceSupport fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected final Grammar[] fGrammarPool = new Grammar[1];

    protected void reset(XMLComponentManager xMLComponentManager) {
        if (xMLComponentManager == null) {
            this.fSymbolTable = null;
            this.fValidationHandler = null;
            return;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        if (this.fSymbolTable == null) {
            this.fSymbolTable = new SymbolTable();
        }
        this.fNamespaceBinder.reset(this.fSymbolTable);
        this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
        this.fNamespaceCounter = 1;
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        if (this.fValidationHandler != null) {
            ((XMLComponent)((Object)this.fValidationHandler)).reset(xMLComponentManager);
        }
    }

    protected void setValidationHandler(RevalidationHandler revalidationHandler) {
        this.fValidationHandler = revalidationHandler;
    }

    protected void normalizeDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.fSymbolTable == null) {
            return;
        }
        this.fDocument = coreDocumentImpl;
        this.fErrorHandler = this.fDocument.getErrorHandler();
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setBaseURI(this.fDocument.fDocumentURI);
            this.fValidationHandler.startDocument(null, this.fDocument.encoding, null);
        }
        Node node = this.fDocument.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if ((node = this.normalizeNode(node)) != null) {
                node2 = node;
            }
            node = node2;
        }
        if (this.fValidationHandler != null) {
            this.fValidationHandler.endDocument(null);
        }
        this.fSymbolTable = null;
    }

    protected Node normalizeNode(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                if ((this.fDocument.features & 4) != 0) break;
                ((DocumentTypeImpl)node).entities.removeAll();
                break;
            }
            case 1: {
                Node node2;
                AttributeMap attributeMap;
                this.fNamespaceBinder.pushContext();
                ElementImpl elementImpl = (ElementImpl)node;
                if (elementImpl.needsSyncChildren()) {
                    elementImpl.synchronizeChildren();
                }
                AttributeMap attributeMap2 = attributeMap = elementImpl.hasAttributes() ? (AttributeMap)elementImpl.getAttributes() : null;
                if ((this.fDocument.features & 1) != 0) {
                    this.namespaceFixUp(elementImpl, attributeMap);
                } else if (attributeMap != null) {
                    int n = 0;
                    while (n < attributeMap.getLength()) {
                        node2 = (Attr)attributeMap.item(n);
                        this.removeDefault((Attr)node2, attributeMap);
                        node2.normalize();
                        ++n;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributeMap, this.fDocument, elementImpl);
                    this.updateQName(elementImpl, this.fQName);
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node node3 = elementImpl.getFirstChild();
                while (node3 != null) {
                    node2 = node3.getNextSibling();
                    if ((node3 = this.normalizeNode(node3)) != null) {
                        node2 = node3;
                    }
                    node3 = node2;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elementImpl, this.fQName);
                    this.fValidationHandler.endElement(this.fQName, null);
                    int n = this.fNamespaceBinder.getDeclaredPrefixCount();
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        String string = this.fNamespaceBinder.getDeclaredPrefixAt(n2);
                        this.fValidationHandler.endPrefixMapping(string, null);
                        --n2;
                    }
                }
                this.fNamespaceBinder.popContext();
                break;
            }
            case 8: {
                Node node4;
                if ((this.fDocument.features & 0x40) != 0) break;
                Node node5 = node.getPreviousSibling();
                Node node6 = node.getParentNode();
                node6.removeChild(node);
                if (node5 == null || node5.getNodeType() != 3 || (node4 = node5.getNextSibling()) == null || node4.getNodeType() != 3) break;
                ((TextImpl)node4).insertData(0, node5.getNodeValue());
                node6.removeChild(node5);
                return node4;
            }
            case 5: {
                Node node7;
                if ((this.fDocument.features & 4) != 0) break;
                Node node8 = node.getPreviousSibling();
                Node node9 = node.getParentNode();
                ((EntityReferenceImpl)node).setReadOnly(false, true);
                this.expandEntityRef(node, node9, node);
                node9.removeChild(node);
                Node node10 = node7 = node8 != null ? node8.getNextSibling() : node9.getFirstChild();
                if (node8 != null && node8.getNodeType() == 3 && node7.getNodeType() == 3) {
                    return node8;
                }
                return node7;
            }
            case 4: {
                if ((this.fDocument.features & 8) == 0) {
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node node11 = node.getParentNode();
                    Node node12 = node.getPreviousSibling();
                    node = node11.replaceChild(text, node);
                    if (node12 != null && node12.getNodeType() == 3) {
                        text.insertData(0, node12.getNodeValue());
                        node11.removeChild(node12);
                    }
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if ((this.fDocument.features & 0x20) == 0) break;
                String string = node.getNodeValue();
                int n = string.indexOf("]]>");
                if (n >= 0) {
                    // empty if block
                }
                Node node13 = node.getParentNode();
                while (n >= 0) {
                    node.setNodeValue(string.substring(0, n + 2));
                    string = string.substring(n + 2);
                    node = this.fDocument.createCDATASection(string);
                    node13.insertBefore(node, node.getNextSibling());
                    n = string.indexOf("]]>");
                }
                break;
            }
            case 3: {
                int n;
                Node node14 = node.getNextSibling();
                if (node14 != null && node14.getNodeType() == 3) {
                    ((Text)node).appendData(node14.getNodeValue());
                    node.getParentNode().removeChild(node14);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                if (this.fValidationHandler == null) break;
                int n3 = n = node14 != null ? (int)node14.getNodeType() : -1;
                if ((this.fDocument.features & 4) == 0 && n == 6 || (this.fDocument.features & 0x40) == 0 && n == 8 || (this.fDocument.features & 8) == 0 && n == 4) break;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
            }
        }
        return null;
    }

    protected void expandEntityRef(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        while (node4 != null) {
            Node node5 = node4.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(node4, node2, node3);
            } else {
                node2.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void namespaceFixUp(ElementImpl var1_1, AttributeMap var2_2) {
        block38: {
            var3_3 = var1_1.getNamespaceURI();
            var4_4 = var1_1.getPrefix();
            if (var3_3 != null) {
                var3_3 = this.fSymbolTable.addSymbol(var3_3);
                v0 = var4_4 = var4_4 == null || var4_4.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var4_4);
                if (this.fNamespaceBinder.getURI(var4_4) != var3_3) {
                    this.addNamespaceDecl(var4_4, var3_3, var1_1);
                    this.fLocalNSBinder.declarePrefix(var4_4, var3_3);
                    this.fNamespaceBinder.declarePrefix(var4_4, var3_3);
                    if (this.fValidationHandler != null) {
                        this.fValidationHandler.startPrefixMapping(var4_4, var3_3, null);
                    }
                }
            } else {
                var5_5 = var1_1.getNodeName();
                var6_6 = var5_5.indexOf(58);
                if (var6_6 > -1) {
                    var7_8 = var5_5.lastIndexOf(58);
                    if (var6_6 != var7_8) {
                        if (this.fErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + var5_5, (short)1, var1_1);
                            var8_10 = (int)this.fErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fErrorHandler != null) {
                        this.modifyDOMError("Element <" + var5_5 + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0, var1_1);
                        var8_10 = (int)this.fErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    var3_3 = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                    if (var3_3 != null && var3_3.length() > 0) {
                        this.addNamespaceDecl(this.fEmptySymbol, this.fEmptySymbol, var1_1);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        if (this.fValidationHandler != null) {
                            this.fValidationHandler.startPrefixMapping(this.fEmptySymbol, this.fEmptySymbol, null);
                        }
                    }
                }
            }
            if (var2_2 == null) break block38;
            var2_2.cloneMap(this.fAttributeList);
            var8_10 = 0;
            while (var8_10 < this.fAttributeList.size()) {
                block40: {
                    block39: {
                        var9_11 = (Attr)this.fAttributeList.elementAt(var8_10);
                        var9_11.normalize();
                        var6_7 = var9_11.getValue();
                        var7_9 = var9_11.getNodeName();
                        var3_3 = var9_11.getNamespaceURI();
                        if (var6_7 == null) {
                            var6_7 = this.fEmptySymbol;
                        }
                        if (var3_3 == null) break block39;
                        var4_4 = var9_11.getPrefix();
                        var4_4 = var4_4 == null || var4_4.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var4_4);
                        var10_12 = this.fSymbolTable.addSymbol(var9_11.getLocalName());
                        if (var4_4 == this.fXmlnsSymbol) {
                            var3_3 = this.fNamespaceBinder.getURI(var10_12);
                            var5_5 = this.fLocalNSBinder.getURI(var10_12);
                            var6_7 = this.fSymbolTable.addSymbol(var6_7);
                            if ((var3_3 == null || var5_5 == null) && var6_7.length() != 0) {
                                this.fNamespaceBinder.declarePrefix(var10_12, var6_7);
                                this.fLocalNSBinder.declarePrefix(var10_12, var6_7);
                                if (this.fValidationHandler != null) {
                                    this.fValidationHandler.startPrefixMapping(var10_12, var6_7, null);
                                }
                            }
                            this.removeDefault(var9_11, var2_2);
                        } else if (var10_12 == this.fXmlnsSymbol && var4_4 == this.fEmptySymbol) {
                            var3_3 = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                            var5_5 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            var6_7 = this.fSymbolTable.addSymbol(var6_7);
                            if (var5_5 == null) {
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var6_7);
                                this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, var6_7);
                                if (this.fValidationHandler != null) {
                                    this.fValidationHandler.startPrefixMapping(this.fEmptySymbol, var6_7, null);
                                }
                            }
                            this.removeDefault(var9_11, var2_2);
                        } else {
                            this.removeDefault(var9_11, var2_2);
                            var3_3 = this.fSymbolTable.addSymbol(var3_3);
                            var11_14 = this.fNamespaceBinder.getURI(var4_4);
                            if (var4_4 == this.fEmptySymbol || var11_14 != var3_3) {
                                var7_9 = var9_11.getNodeName();
                                var12_16 = this.fNamespaceBinder.getPrefix(var3_3);
                                if (var12_16 == null || var12_16 == this.fEmptySymbol) {
                                    if (var4_4 == this.fEmptySymbol) {
                                        var4_4 = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.addNamespaceDecl(var4_4, var3_3, var1_1);
                                    var6_7 = this.fSymbolTable.addSymbol(var6_7);
                                    this.fLocalNSBinder.declarePrefix(var4_4, var6_7);
                                    this.fNamespaceBinder.declarePrefix(var4_4, var3_3);
                                    if (this.fValidationHandler != null) {
                                        this.fValidationHandler.startPrefixMapping(var4_4, var3_3, null);
                                    }
                                } else {
                                    var4_4 = var12_16;
                                }
                                var9_11.setPrefix(var4_4);
                            }
                        }
                        break block40;
                    }
                    var10_13 = var7_9.indexOf(58);
                    var11_15 = var7_9.lastIndexOf(58);
                    if (!var7_9.startsWith(this.fXmlnsSymbol)) ** GOTO lbl130
                    if (var10_13 < 0) {
                        var3_3 = this.fNamespaceBinder.getURI(this.fEmptySymbol);
                        var5_5 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (var5_5 == null) {
                            var6_7 = this.fSymbolTable.addSymbol(var6_7);
                            this.fNamespaceBinder.declarePrefix(this.fEmptySymbol, var6_7);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var6_7);
                            this.removeDefault(var9_11, var2_2);
                        }
                    } else {
                        if (var10_13 == var11_15) {
                            var4_4 = var7_9.substring(6);
                            v1 = var4_4 = var4_4.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var4_4);
                            if (var4_4.length() == 0 || var6_7.length() == 0) {
                                // empty if block
                            }
                            var3_3 = this.fNamespaceBinder.getURI(var4_4);
                            var5_5 = this.fLocalNSBinder.getURI(var4_4);
                            if ((var3_3 == null || var5_5 == null) && var6_7.length() != 0) {
                                var6_7 = this.fSymbolTable.addSymbol(var6_7);
                                this.fNamespaceBinder.declarePrefix(var4_4, var6_7);
                                this.fLocalNSBinder.declarePrefix(var4_4, var6_7);
                            }
                        }
lbl130:
                        // 6 sources

                        this.removeDefault(var9_11, var2_2);
                        if (var10_13 > -1) {
                            if (var10_13 != var11_15) {
                                if (this.fErrorHandler != null) {
                                    this.modifyDOMError("Attribute's name is not a QName: " + var7_9, (short)1, var9_11);
                                    var12_17 = this.fErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fErrorHandler != null) {
                                this.modifyDOMError("Attribute '" + var7_9 + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0, var9_11);
                                var12_18 = this.fErrorHandler.handleError(this.fDOMError);
                            }
                        }
                    }
                }
                ++var8_10;
            }
        }
    }

    protected void addNamespaceDecl(String string, String string2, ElementImpl elementImpl) {
        if (string == this.fEmptySymbol) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns", string2);
        } else {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string, string2);
        }
    }

    protected void removeDefault(Attr attr, AttributeMap attributeMap) {
        if ((this.fDocument.features & 0x10) != 0 && !attr.getSpecified()) {
            attributeMap.removeItem(attr, false);
        }
    }

    protected DOMError modifyDOMError(String string, short s, Node node) {
        this.fDOMError.reset();
        this.fDOMError.setMessage(string);
        this.fDOMError.setSeverity(s);
        this.fDOMError.setLocator(new DOMLocatorImpl(-1, -1, -1, node, null));
        return this.fDOMError;
    }

    protected void updateQName(Node node, QName qName) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        String string3 = node.getLocalName();
        qName.prefix = string != null && string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null;
        qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : null;
        qName.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qName.uri = string2 != null ? this.fSymbolTable.addSymbol(string2) : null;
    }

    public Grammar[] retrieveInitialGrammarSet(String string) {
        this.fGrammarPool[0] = this.fDocument.fGrammar;
        return null;
    }

    public void cacheGrammars(String string, Grammar[] grammarArray) {
    }

    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        return null;
    }

    public void lockPool() {
    }

    public void unlockPool() {
    }

    public void clear() {
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                int n2 = 0;
                while (n2 < n) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), n2);
                    ++n2;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qName, String string, String string2) {
            Attr attr = this.fDocument.createAttributeNS(qName.uri, qName.rawname, qName.localpart);
            attr.setValue(string2);
            if (this.fAttributes == null) {
                this.fAttributes = (AttributeMap)this.fElement.getAttributes();
            }
            int n = this.fElement.setXercesAttributeNode(attr);
            this.fAugmentations.insertElementAt(new AugmentationsImpl(), n);
            return n;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int n) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String string) {
            return -1;
        }

        public int getIndex(String string, String string2) {
            return -1;
        }

        public void setName(int n, QName qName) {
        }

        public void getName(int n, QName qName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(n), qName);
            }
        }

        public String getPrefix(int n) {
            return null;
        }

        public String getURI(int n) {
            return null;
        }

        public String getLocalName(int n) {
            return null;
        }

        public String getQName(int n) {
            return null;
        }

        public void setType(int n, String string) {
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public void setValue(int n, String string) {
        }

        public String getValue(int n) {
            return this.fAttributes.item(n).getNodeValue();
        }

        public String getValue(String string) {
            return null;
        }

        public String getValue(String string, String string2) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int n, String string) {
        }

        public String getNonNormalizedValue(int n) {
            return null;
        }

        public void setSpecified(int n, boolean bl) {
            AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
            attrImpl.setSpecified(bl);
        }

        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        public Augmentations getAugmentations(String string, String string2) {
            return null;
        }

        public Augmentations getAugmentations(String string) {
            return null;
        }
    }
}

