/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.Collection;
import org.jmock.Mock;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicMock;
import org.jmock.core.Formatting;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.MockObjectSupportTestCase;
import org.jmock.core.Stub;
import org.jmock.core.matcher.InvokeAtLeastOnceMatcher;
import org.jmock.core.matcher.InvokeCountMatcher;
import org.jmock.core.matcher.InvokeOnceMatcher;
import org.jmock.core.matcher.TestFailureMatcher;
import org.jmock.core.stub.DoAllStub;
import org.jmock.core.stub.ReturnIteratorStub;
import org.jmock.core.stub.ReturnStub;
import org.jmock.core.stub.StubSequence;
import org.jmock.core.stub.ThrowStub;

public abstract class MockObjectTestCase
extends MockObjectSupportTestCase {
    public MockObjectTestCase() {
    }

    public MockObjectTestCase(String name) {
        super(name);
    }

    public Mock mock(Class mockedType) {
        return this.mock(mockedType, this.defaultMockNameForType(mockedType));
    }

    public Mock mock(Class mockedType, String roleName) {
        Mock newMock = new Mock(this.newCoreMock(mockedType, roleName));
        this.registerToVerify(newMock);
        return newMock;
    }

    protected DynamicMock newCoreMock(Class mockedType, String roleName) {
        return new CoreMock(mockedType, roleName);
    }

    public String defaultMockNameForType(Class mockedType) {
        return "mock" + Formatting.classShortName(mockedType);
    }

    public Stub returnValue(Object o) {
        return new ReturnStub(o);
    }

    public Stub returnValue(boolean result) {
        return this.returnValue(new Boolean(result));
    }

    public Stub returnValue(byte result) {
        return this.returnValue(new Byte(result));
    }

    public Stub returnValue(char result) {
        return this.returnValue(new Character(result));
    }

    public Stub returnValue(short result) {
        return this.returnValue(new Short(result));
    }

    public Stub returnValue(int result) {
        return this.returnValue(new Integer(result));
    }

    public Stub returnValue(long result) {
        return this.returnValue(new Long(result));
    }

    public Stub returnValue(float result) {
        return this.returnValue(new Float(result));
    }

    public Stub returnValue(double result) {
        return this.returnValue(new Double(result));
    }

    public Stub returnIterator(Collection collection) {
        return new ReturnIteratorStub(collection);
    }

    public Stub returnIterator(Object[] array) {
        return new ReturnIteratorStub(array);
    }

    public Stub throwException(Throwable throwable) {
        return new ThrowStub(throwable);
    }

    public InvocationMatcher once() {
        return new InvokeOnceMatcher();
    }

    public InvocationMatcher atLeastOnce() {
        return new InvokeAtLeastOnceMatcher();
    }

    public InvocationMatcher exactly(int expectedCount) {
        return new InvokeCountMatcher(expectedCount);
    }

    public InvocationMatcher never() {
        return new TestFailureMatcher("not expected");
    }

    public InvocationMatcher never(String errorMessage) {
        return new TestFailureMatcher("not expected (" + errorMessage + ")");
    }

    public Stub onConsecutiveCalls(Stub stub1, Stub stub2) {
        return this.onConsecutiveCalls(new Stub[]{stub1, stub2});
    }

    public Stub onConsecutiveCalls(Stub stub1, Stub stub2, Stub stub3) {
        return this.onConsecutiveCalls(new Stub[]{stub1, stub2, stub3});
    }

    public Stub onConsecutiveCalls(Stub stub1, Stub stub2, Stub stub3, Stub stub4) {
        return this.onConsecutiveCalls(new Stub[]{stub1, stub2, stub3, stub4});
    }

    public Stub onConsecutiveCalls(Stub[] stubs) {
        return new StubSequence(stubs);
    }

    public Stub doAll(Stub stub1, Stub stub2) {
        return this.doAll(new Stub[]{stub1, stub2});
    }

    public Stub doAll(Stub stub1, Stub stub2, Stub stub3) {
        return this.doAll(new Stub[]{stub1, stub2, stub3});
    }

    public Stub doAll(Stub stub1, Stub stub2, Stub stub3, Stub stub4) {
        return this.doAll(new Stub[]{stub1, stub2, stub3, stub4});
    }

    public Stub doAll(Stub[] stubs) {
        return new DoAllStub(stubs);
    }
}

