/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.DTDCommenter;
import DTDDoc.ExtendedDTD;
import DTDDoc.Logger;
import DTDDoc.Tools;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDSequence;
import java.io.PrintWriter;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ElementTreeBuilder {
    private Logger log;
    private static final int UNMODIFIED = 0;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int ALWAYS_OPEN = 4;
    private static final int INITIALLY_OPEN = 8;
    private final PrintWriter out;
    private final DTDCommenter commenter;
    private final Set dtds;
    private ExtendedDTD currentDTD;
    private int nextNodeId = 0;
    private Map elementNodeIds = new HashMap();

    public ElementTreeBuilder(PrintWriter out, DTDCommenter commenter, Set dtds, Logger log) {
        this.log = log;
        this.out = out;
        this.commenter = commenter;
        this.dtds = dtds;
    }

    public void generateTree() {
        this.out.println("<div class='dtree'>");
        this.out.println("<script type='text/javascript'>");
        this.out.println("//<!--");
        this.out.println("eltTree = new CCTree('detail');");
        this.nextNodeId = 0;
        TreeMap<Object, ExtendedDTD> dtdsByTitle = new TreeMap<Object, ExtendedDTD>(Collator.getInstance());
        Iterator<Object> iter = this.dtds.iterator();
        while (iter.hasNext()) {
            ExtendedDTD dtd = (ExtendedDTD)iter.next();
            dtdsByTitle.put(dtd.getTitle(), dtd);
        }
        iter = dtdsByTitle.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ExtendedDTD dtd = (ExtendedDTD)entry.getValue();
            this.visitCurrentDTD(dtd);
        }
        this.out.println("document.write(eltTree);");
        this.out.println("//-->");
        this.out.println("</script>");
        this.out.println("</div>");
    }

    private void visitCurrentDTD(ExtendedDTD dtd) {
        this.currentDTD = dtd;
        this.elementNodeIds = new HashMap();
        int nodeId = this.generateTreeNode(-1, dtd.getTitle(), this.commenter.getDTDBaseURI(dtd), 0);
        Collection c = Tools.sort(dtd.getElementsCollection(), new Comparator(){

            public int compare(Object oa, Object ob) {
                DTDElement a = (DTDElement)oa;
                DTDElement b = (DTDElement)ob;
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.visitElement(nodeId, (DTDElement)i.next(), null, true);
        }
    }

    private void visitElement(int parentNodeId, DTDElement dtdElement, DTDCardinal cardinality, boolean firstLevel) {
        if (this.elementNodeIds.containsKey(dtdElement)) {
            this.generateTreeLink(parentNodeId, (Integer)this.elementNodeIds.get(dtdElement), dtdElement.getName() + this.getCardinalitySymbol(cardinality), this.getCardinalityModifier(cardinality));
            return;
        }
        String name = dtdElement.getName();
        if (dtdElement.getContent() instanceof DTDEmpty) {
            name = "&lt;" + name + "/&gt;";
        } else if (dtdElement.getContent() instanceof DTDAny) {
            name = name + " (any)";
        }
        int typefaceModifier = this.getCardinalityModifier(cardinality);
        if (this.currentDTD.isRoot(dtdElement) && firstLevel) {
            name = name + " (root)";
            typefaceModifier |= 1;
        }
        int nodeId = this.generateTreeNode(parentNodeId, name + this.getCardinalitySymbol(cardinality), this.commenter.newURITo(this.currentDTD, dtdElement).toString(), typefaceModifier);
        this.elementNodeIds.put(dtdElement, new Integer(nodeId));
        this.generateAttributesNodes(nodeId, dtdElement);
        if (dtdElement.getContent() instanceof DTDContainer) {
            this.visitContainer(nodeId, (DTDContainer)dtdElement.getContent());
        } else if (dtdElement.getContent() instanceof DTDAny) {
            Iterator i = this.currentDTD.getElementsCollection().iterator();
            while (i.hasNext()) {
                this.visitElement(nodeId, (DTDElement)i.next(), null, true);
            }
        }
    }

    public void visitContainer(int parentId, DTDContainer container) {
        if (container instanceof DTDMixed && container.getItems() != null && container.getItems().length == 1 && container.getItems()[0] instanceof DTDPCData) {
            return;
        }
        int newNodeId = parentId;
        if (!(container instanceof DTDSequence) || container.getCardinal() != DTDCardinal.NONE) {
            newNodeId = this.generateContainerNode(container, parentId);
        }
        Iterator i = container.getItemsVec().iterator();
        while (i.hasNext()) {
            DTDItem childItem = (DTDItem)i.next();
            if (childItem instanceof DTDName) {
                DTDElement childElement = this.currentDTD.getElementByName((DTDName)childItem);
                if (childElement == null) continue;
                this.visitElement(newNodeId, childElement, childItem.getCardinal(), true);
                continue;
            }
            if (!(childItem instanceof DTDContainer)) continue;
            this.visitContainer(newNodeId, (DTDContainer)childItem);
        }
    }

    private int generateContainerNode(DTDContainer container, int parentId) {
        String s = null;
        if (container instanceof DTDMixed) {
            s = "mixed";
        } else if (container instanceof DTDChoice) {
            s = "choice";
        } else if (container instanceof DTDSequence) {
            s = "sequence";
        } else {
            this.log.error("Unsupported type of container: " + container.getClass());
        }
        return this.generateTreeNode(parentId, "&lt;" + s + "&gt;" + this.getCardinalitySymbol(container.getCardinal()), null, 2 | this.getCardinalityModifier(container.getCardinal()) | 4);
    }

    private String getCardinalitySymbol(DTDCardinal card) {
        if (card == DTDCardinal.OPTIONAL) {
            return "?";
        }
        if (card == DTDCardinal.ZEROMANY) {
            return "*";
        }
        if (card == DTDCardinal.ONEMANY) {
            return "+";
        }
        return "";
    }

    private int getCardinalityModifier(DTDCardinal card) {
        if (card == DTDCardinal.NONE || card == DTDCardinal.ONEMANY) {
            return 1;
        }
        return 0;
    }

    private void generateAttributesNodes(int parentNodeId, DTDElement dtdElement) {
        if (dtdElement.attributes == null || dtdElement.attributes.size() <= 0) {
            return;
        }
        TreeMap sortedAttributes = new TreeMap(dtdElement.attributes);
        Iterator iter = sortedAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DTDAttribute attr = (DTDAttribute)entry.getValue();
            int modifier = 0;
            if (attr.decl == DTDDecl.REQUIRED) {
                modifier = 1;
            }
            this.generateTreeNode(parentNodeId, "@" + attr.getName(), this.commenter.newURITo(this.currentDTD, dtdElement, attr).toString(), modifier);
        }
    }

    private int generateTreeNode(int parentNodeId, String label, String url, int modifiers) {
        int nodeId = this.nextNodeId++;
        label = Tools.escapeHTMLUnicode(label, true);
        if ((modifiers & 2) == 2) {
            label = "<i>" + label + "</i>";
        }
        if ((modifiers & 1) == 1) {
            label = "<b>" + label + "</b>";
        }
        url = url != null ? "'" + url + "'" : "null";
        boolean alwaysOpen = (modifiers & 4) == 4;
        boolean initiallyOpen = (modifiers & 8) == 8;
        String addNodeFunc = parentNodeId >= 0 ? "addNode" : "addRootNode";
        this.out.println("eltTree." + addNodeFunc + "('" + nodeId + "','" + label + "'," + url + "," + alwaysOpen + "," + initiallyOpen + ")");
        if (parentNodeId >= 0) {
            this.out.println("eltTree.linkNodes('" + parentNodeId + "','" + nodeId + "')");
        }
        return nodeId;
    }

    private void generateTreeLink(int parentNodeId, int nodeId, String label, int modifiers) {
        if ((modifiers & 2) == 2) {
            label = "<i>" + label + "</i>";
        }
        if ((modifiers & 1) == 1) {
            label = "<b>" + label + "</b>";
        }
        this.out.println("eltTree.linkNodes('" + parentNodeId + "','" + nodeId + "','" + label + "')");
    }

    public static void generateJavascriptSetup(PrintWriter out) {
        out.println("<script type='text/javascript' src='cctree.js'></script>");
    }

    private static class TreeRunState {
        private final Map elementNodeIds = new HashMap();
        private int nextNodeId = 0;

        private TreeRunState() {
        }

        int allocateIdGeneric() {
            int nid = this.nextNodeId++;
            return nid;
        }

        int addIdElement(DTDElement element) throws Exception {
            String key = element.getName();
            if (!this.isNodeVisited(element)) {
                int nid = this.allocateIdGeneric();
                this.elementNodeIds.put(key, new Integer(nid));
                return nid;
            }
            return this.getElementId(element);
        }

        boolean isNodeVisited(DTDElement element) {
            return this.elementNodeIds.containsKey(element.getName());
        }

        int getElementId(DTDElement element) throws Exception {
            String key = element.getName();
            if (this.isNodeVisited(element)) {
                return (Integer)this.elementNodeIds.get(key);
            }
            throw new Exception("Requested the id of " + key + ", which" + " doesn't exist !");
        }
    }
}

