/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.FileCopyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class Tools {
    public static final List HTML_TAGS;

    private static void streamCopy(InputStream source, OutputStream destination) throws IOException {
        int bytes_read;
        if (source == null) {
            throw new IOException("Trying to input from a null stream");
        }
        if (destination == null) {
            throw new IOException("Trying to output to a null stream");
        }
        byte[] buffer = new byte[16384];
        while ((bytes_read = source.read(buffer)) > 0) {
            destination.write(buffer, 0, bytes_read);
        }
    }

    private static void streamCopyAndClose(InputStream source, OutputStream destination) throws IOException {
        IOException exception;
        block10: {
            block9: {
                exception = null;
                try {
                    Tools.streamCopy(source, destination);
                }
                catch (IOException ex) {
                    exception = ex;
                }
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException e) {
                        if (exception == null) break block9;
                        exception = new IOException(exception.getMessage() + " (and I was not able to close this stream)");
                    }
                }
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException e) {
                    if (exception == null) break block10;
                    exception = new IOException(exception.getMessage() + " (and I was not able to close this stream)");
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OutputStream openToWrite(File destinationFile) throws FileCopyException {
        if (destinationFile.exists()) {
            if (!destinationFile.isFile()) throw new FileCopyException(destinationFile + " is not a file.");
            if (!destinationFile.canWrite()) {
                throw new FileCopyException("Can't write into " + destinationFile);
            }
        } else {
            File parentdir = Tools.parent(destinationFile);
            if (!parentdir.exists()) {
                throw new FileCopyException("Destination directory doesn't exist for " + destinationFile);
            }
            if (!parentdir.canWrite()) {
                throw new FileCopyException("Destination directory for " + destinationFile + " is unwritable.");
            }
        }
        try {
            return new FileOutputStream(destinationFile);
        }
        catch (FileNotFoundException ex) {
            throw new FileCopyException("Can't write to " + destinationFile + " because " + ex.getLocalizedMessage());
        }
    }

    public static void copyFromResource(String name, File destinationFile) throws FileCopyException {
        InputStream source = Tools.class.getResourceAsStream(name);
        if (source == null) {
            String error = "Unable to find " + name + ".";
            if (!name.startsWith("/")) {
                error = error + " Please note that name doesn't start with a slash '/'.";
            }
            throw new FileCopyException(error);
        }
        OutputStream destination = Tools.openToWrite(destinationFile);
        try {
            Tools.streamCopyAndClose(source, destination);
        }
        catch (IOException ex) {
            throw new FileCopyException("Unable to copy " + name + " into " + destinationFile);
        }
    }

    public static void copy(File sourceFile, File destinationFile) throws IOException {
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new FileCopyException("Can't find " + sourceFile);
        }
        if (!sourceFile.canRead()) {
            throw new FileCopyException("File " + sourceFile + " is unreadable");
        }
        FileInputStream source = new FileInputStream(sourceFile);
        OutputStream destination = Tools.openToWrite(destinationFile);
        try {
            Tools.streamCopyAndClose(source, destination);
        }
        catch (IOException ex) {
            throw new FileCopyException("Unable to copy " + sourceFile + " into " + destinationFile);
        }
    }

    public static File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public static Collection sort(Collection collection, Comparator comparator) {
        ArrayList l = new ArrayList(collection);
        Collections.sort(l, comparator);
        return l;
    }

    public static String[] listToArray(String s, String separator) {
        if (s == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, separator, false);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        if (l.size() <= 0) {
            return null;
        }
        return l.toArray(new String[l.size()]);
    }

    public static String join(String[] array, String separator) {
        int len = array.length;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buff.append(separator);
            }
            buff.append(array[i]);
        }
        return buff.toString();
    }

    public static String escapeHTMLUnicode(String s, boolean javascript) {
        if (s != null) {
            StringBuffer out = new StringBuffer(s.length() * 2);
            for (int j = 0; j < s.length(); ++j) {
                char c = s.charAt(j);
                if (javascript && c == '\'') {
                    out.append("\\'");
                    continue;
                }
                if (c < '\u0080') {
                    out.append(c);
                    continue;
                }
                out.append("&#").append((int)c).append(';');
            }
            return out.toString();
        }
        return null;
    }

    public static List enumerationToList(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        LinkedList c = new LinkedList();
        while (enumeration.hasMoreElements()) {
            c.add(enumeration.nextElement());
        }
        return c;
    }

    public static String getFilename(String path) {
        int li = path.lastIndexOf(File.separator) + 1;
        return path.substring(li);
    }

    public static void makeFileDir(File f) throws IOException {
        String c = f.getCanonicalPath();
        File dir = new File(c.substring(0, c.lastIndexOf(File.separator)));
        dir.mkdirs();
    }

    public static boolean startsWithHtmlTag(String txt) {
        String tag;
        if (txt.startsWith("</")) {
            txt = txt.substring(2);
        } else if (txt.startsWith("<")) {
            txt = txt.substring(1);
        } else {
            return false;
        }
        int idx = txt.indexOf(32);
        if (idx > 0) {
            txt = txt.substring(0, idx);
        }
        if ((idx = txt.indexOf(62)) > 0) {
            txt = txt.substring(0, idx);
        }
        return Collections.binarySearch(HTML_TAGS, tag = txt.toLowerCase()) >= 0;
    }

    public static String replace(String src, String token, String with) {
        int index = src.indexOf(token);
        if (index < 0) {
            return src;
        }
        StringBuffer buffer = new StringBuffer();
        int prev = 0;
        while (index >= 0) {
            buffer.append(src.substring(prev, index));
            buffer.append(with);
            prev = index + token.length();
            index = src.indexOf(token, prev);
        }
        buffer.append(src.substring(prev));
        return buffer.toString();
    }

    static {
        List<String> html = Arrays.asList("script", "noscript", "iframe", "div", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "menu", "dir", "li", "dl", "dt", "dd", "address", "hr", "pre", "blockquote", "center", "ins", "del", "a", "span", "bdo", "br", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "q", "sub", "sup", "tt", "i", "b", "big", "small", "u", "s", "strike", "basefont", "font", "object", "param", "applet", "img", "map", "area", "form", "label", "input", "select", "optgroup", "option", "textarea", "fieldset", "legend", "button", "isindex", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td");
        Collections.sort(html);
        HTML_TAGS = Collections.unmodifiableList(html);
    }
}

