/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.template;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeContext;
import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.data.UniqueStack;
import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRenderingContext
implements RenderingContext,
FunctionExecutor {
    public static final Logger logger = Logger.getLogger(DefaultRenderingContext.class.getName());
    private final DataContext dataContext;
    private final ResourceLoader resourceLoader;
    private final Appendable out;
    private final FunctionExecutor globalFunctionExecutor;
    private final AutoEscapeOptions autoEscapeOptions;
    private final UniqueStack<String> includeStack;
    private List<String> escaperStack = new ArrayList<String>(8);
    private String currentEscaper;
    private List<Template> executionStack = new ArrayList<Template>(8);
    private Map<String, Macro> macros = new HashMap<String, Macro>();
    private List<EscapeMode> autoEscapeStack = new ArrayList<EscapeMode>();
    private EscapeMode autoEscapeMode;
    private AutoEscapeContext autoEscapeContext;
    private int line;
    private int column;
    private AutoEscapeContext.AutoEscapeState startingAutoEscapeState;

    public DefaultRenderingContext(DataContext dataContext, ResourceLoader resourceLoader, Appendable out, FunctionExecutor globalFunctionExecutor, AutoEscapeOptions autoEscapeOptions) {
        this.dataContext = dataContext;
        this.resourceLoader = resourceLoader;
        this.out = out;
        this.globalFunctionExecutor = globalFunctionExecutor;
        this.autoEscapeOptions = autoEscapeOptions;
        this.autoEscapeMode = EscapeMode.ESCAPE_NONE;
        this.autoEscapeContext = null;
        this.includeStack = new UniqueStack();
    }

    @Override
    public Value executeFunction(String name, Value ... args) {
        return this.globalFunctionExecutor.executeFunction(name, args);
    }

    @Override
    public void escape(String name, String input, Appendable output) throws IOException {
        this.globalFunctionExecutor.escape(name, input, output);
    }

    @Override
    public boolean isEscapingFunction(String name) {
        return this.globalFunctionExecutor.isEscapingFunction(name);
    }

    @Override
    public void pushEscapingFunction(String name) {
        this.escaperStack.add(this.currentEscaper);
        this.currentEscaper = name == null || name.equals("") ? null : name;
    }

    @Override
    public void popEscapingFunction() {
        int len = this.escaperStack.size();
        if (len == 0) {
            throw new IllegalStateException("No more escaping functions to pop.");
        }
        this.currentEscaper = this.escaperStack.remove(len - 1);
    }

    @Override
    public void writeEscaped(String text) {
        boolean applyAutoEscape;
        boolean bl = applyAutoEscape = this.isRuntimeAutoEscaping() && this.currentEscaper == null;
        if (applyAutoEscape) {
            this.autoEscapeContext.setCurrentPosition(this.line, this.column);
            this.pushEscapingFunction(this.autoEscapeContext.getEscapingFunctionForCurrentState());
        }
        try {
            if (this.shouldLogEscapedVariables()) {
                StringBuilder tmp = new StringBuilder();
                this.globalFunctionExecutor.escape(this.currentEscaper, text, tmp);
                if (!tmp.toString().equals(text)) {
                    logger.warning(this.getLoggingPrefix() + " Auto-escape changed [" + text + "] to [" + tmp.toString() + "]");
                }
                this.out.append(tmp);
            } else {
                this.globalFunctionExecutor.escape(this.currentEscaper, text, this.out);
            }
        }
        catch (IOException e) {
            throw new JSilverIOException(e);
        }
        finally {
            if (applyAutoEscape) {
                this.autoEscapeContext.insertText();
                this.popEscapingFunction();
            }
        }
    }

    private String getLoggingPrefix() {
        return "[" + this.getCurrentResourceName() + ":" + this.line + ":" + this.column + "]";
    }

    private boolean shouldLogEscapedVariables() {
        return this.autoEscapeOptions != null && this.autoEscapeOptions.getLogEscapedVariables();
    }

    @Override
    public void writeUnescaped(CharSequence text) {
        if (this.isRuntimeAutoEscaping() && this.currentEscaper == null) {
            this.autoEscapeContext.setCurrentPosition(this.line, this.column);
            this.autoEscapeContext.parseData(((Object)text).toString());
        }
        try {
            this.out.append(text);
        }
        catch (IOException e) {
            throw new JSilverIOException(e);
        }
    }

    @Override
    public void pushExecutionContext(Template template) {
        this.executionStack.add(template);
    }

    @Override
    public void popExecutionContext() {
        this.executionStack.remove(this.executionStack.size() - 1);
    }

    @Override
    public void setCurrentPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public void registerMacro(String name, Macro macro) {
        this.macros.put(name, macro);
    }

    @Override
    public Macro findMacro(String name) {
        Macro macro = this.macros.get(name);
        if (macro == null) {
            throw new JSilverInterpreterException("No such macro: " + name);
        }
        return macro;
    }

    @Override
    public DataContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public AutoEscapeOptions getAutoEscapeOptions() {
        return this.autoEscapeOptions;
    }

    @Override
    public EscapeMode getAutoEscapeMode() {
        if (this.isRuntimeAutoEscaping() || this.currentEscaper != null) {
            return EscapeMode.ESCAPE_NONE;
        }
        return this.autoEscapeMode;
    }

    @Override
    public void pushAutoEscapeMode(EscapeMode mode) {
        if (this.isRuntimeAutoEscaping()) {
            throw new JSilverInterpreterException("cannot call pushAutoEscapeMode while runtime auto escaping is in progress");
        }
        this.autoEscapeStack.add(this.autoEscapeMode);
        this.autoEscapeMode = mode;
    }

    @Override
    public void popAutoEscapeMode() {
        int len = this.autoEscapeStack.size();
        if (len == 0) {
            throw new IllegalStateException("No more auto escaping modes to pop.");
        }
        this.autoEscapeMode = this.autoEscapeStack.remove(this.autoEscapeStack.size() - 1);
    }

    @Override
    public boolean isRuntimeAutoEscaping() {
        return this.autoEscapeContext != null;
    }

    @Override
    public void startRuntimeAutoEscaping() {
        if (this.isRuntimeAutoEscaping()) {
            throw new JSilverInterpreterException("startRuntimeAutoEscaping() is not re-entrant at " + this.getCurrentResourceName());
        }
        if (!this.autoEscapeMode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            this.autoEscapeContext = new AutoEscapeContext(this.autoEscapeMode, this.getCurrentResourceName());
            this.startingAutoEscapeState = this.autoEscapeContext.getCurrentState();
        } else {
            this.autoEscapeContext = null;
        }
    }

    private String getCurrentResourceName() {
        if (this.executionStack.size() == 0) {
            return "";
        }
        return this.executionStack.get(this.executionStack.size() - 1).getDisplayName();
    }

    @Override
    public void stopRuntimeAutoEscaping() {
        if (this.autoEscapeContext != null && !this.startingAutoEscapeState.equals((Object)this.autoEscapeContext.getCurrentState())) {
            throw new JSilverAutoEscapingException("Macro starts in context " + (Object)((Object)this.startingAutoEscapeState) + " but ends in different context " + (Object)((Object)this.autoEscapeContext.getCurrentState()), this.autoEscapeContext.getResourceName());
        }
        this.autoEscapeContext = null;
    }

    @Override
    public boolean pushIncludeStackEntry(String templateName) {
        return this.includeStack.push(templateName);
    }

    @Override
    public boolean popIncludeStackEntry(String templateName) {
        return templateName.equals(this.includeStack.pop());
    }

    @Override
    public Iterable<String> getIncludedTemplateNames() {
        return this.includeStack;
    }
}

