/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.syntax.AutoEscaper;
import com.google.clearsilver.jsilver.syntax.InlineRewriter;
import com.google.clearsilver.jsilver.syntax.SequenceOptimizer;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import com.google.clearsilver.jsilver.syntax.TypeResolver;
import com.google.clearsilver.jsilver.syntax.VarOptimizer;
import com.google.clearsilver.jsilver.syntax.lexer.Lexer;
import com.google.clearsilver.jsilver.syntax.lexer.LexerException;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.Switch;
import com.google.clearsilver.jsilver.syntax.parser.Parser;
import com.google.clearsilver.jsilver.syntax.parser.ParserException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Arrays;

public class SyntaxTreeBuilder {
    private static final int PUSHBACK_SIZE = "<?cs ".length();
    protected final Switch typeResolver = new TypeResolver();
    protected final Switch sequenceOptimizer = new SequenceOptimizer();
    protected final Switch inlineRewriter = new InlineRewriter();
    protected final Switch varOptimizer = new VarOptimizer(Arrays.asList("html", "js", "url"));

    protected void process(Start root, EscapeMode escapeMode, String templateName) {
        root.apply(this.typeResolver);
        root.apply(this.sequenceOptimizer);
        root.apply(this.inlineRewriter);
        if (!escapeMode.equals((Object)EscapeMode.ESCAPE_NONE)) {
            root.apply(new AutoEscaper(escapeMode, templateName));
        }
    }

    public TemplateSyntaxTree parse(Reader input, String templateName, EscapeMode escapeMode) throws JSilverIOException, JSilverBadSyntaxException {
        try {
            PushbackReader pushbackReader = new PushbackReader(input, PUSHBACK_SIZE);
            Lexer lexer = new Lexer(pushbackReader);
            Parser parser = new Parser(lexer);
            Start root = parser.parse();
            this.process(root, escapeMode, templateName);
            return new TemplateSyntaxTree(root);
        }
        catch (IOException exception) {
            throw new JSilverIOException(exception);
        }
        catch (ParserException exception) {
            throw new JSilverBadSyntaxException(exception.getMessage(), exception.getToken().getText(), templateName, exception.getToken().getLine(), exception.getToken().getPos(), exception);
        }
        catch (LexerException exception) {
            throw new JSilverBadSyntaxException(exception.getMessage(), null, templateName, -1, -1, exception);
        }
    }
}

