/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.InterpretedTemplate;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;

public class InterpretedTemplateLoader
implements DelegatingTemplateLoader {
    private final TemplateFactory templateFactory;
    private final FunctionExecutor globalFunctionExecutor;
    private final AutoEscapeOptions autoEscapeOptions;
    private TemplateLoader templateLoaderDelegate = this;

    public InterpretedTemplateLoader(TemplateFactory templateFactory, FunctionExecutor globalFunctionExecutor, AutoEscapeOptions autoEscapeOptions) {
        this.templateFactory = templateFactory;
        this.globalFunctionExecutor = globalFunctionExecutor;
        this.autoEscapeOptions = autoEscapeOptions;
    }

    public void setTemplateLoaderDelegate(TemplateLoader templateLoaderDelegate) {
        this.templateLoaderDelegate = templateLoaderDelegate;
    }

    public Template load(String templateName, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        return new InterpretedTemplate(this.templateLoaderDelegate, this.templateFactory.find(templateName, resourceLoader, escapeMode), templateName, this.globalFunctionExecutor, this.autoEscapeOptions, escapeMode);
    }

    public Template createTemp(String name, String content, EscapeMode escapingMode) {
        return new InterpretedTemplate(this.templateLoaderDelegate, this.templateFactory.createTemp(content, escapingMode), name, this.globalFunctionExecutor, this.autoEscapeOptions, escapingMode);
    }
}

