/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.JSilverOptions;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.adaptor.ResourceLoaderAdaptor;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.clearsilver.CSFileLoader;
import org.clearsilver.HDF;

public class JHdf
implements HDF {
    private Data data;
    private final DataFactory dataFactory;
    private final JSilverOptions options;
    private final LoadPathToFileCache loadPathCache;
    private ResourceLoaderAdaptor resourceLoader;

    JHdf(Data data, DataFactory dataFactory, LoadPathToFileCache loadPathCache, JSilverOptions options) {
        this.data = data;
        this.loadPathCache = loadPathCache;
        this.dataFactory = dataFactory;
        this.options = options;
        this.resourceLoader = new ResourceLoaderAdaptor(this, loadPathCache, null);
    }

    static JHdf cast(HDF hdf) {
        if (!(hdf instanceof JHdf)) {
            throw new IllegalArgumentException("HDF object not of type JHdf.  Make sure you use the same ClearsilverFactory to construct all related HDF and CS objects.");
        }
        return (JHdf)hdf;
    }

    Data getData() {
        return this.data;
    }

    ResourceLoaderAdaptor getResourceLoaderAdaptor() {
        return this.resourceLoader;
    }

    public void close() {
        this.data = null;
    }

    public boolean readFile(String filename) throws IOException {
        this.dataFactory.loadData(filename, this.resourceLoader, this.data);
        return false;
    }

    public CSFileLoader getFileLoader() {
        return this.resourceLoader.getCSFileLoader();
    }

    public void setFileLoader(CSFileLoader fileLoader) {
        this.resourceLoader = new ResourceLoaderAdaptor(this, this.loadPathCache, fileLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(String filename) throws IOException {
        FileWriter writer = new FileWriter(filename);
        try {
            this.data.write(writer, 2);
        }
        finally {
            writer.close();
        }
        return true;
    }

    public boolean readString(String content) {
        Parser hdfParser = this.dataFactory.getParser();
        try {
            hdfParser.parse(new StringReader(content), this.data, new Parser.ErrorHandler(){

                public void error(int line, String lineContent, String fileName, String errorMessage) {
                    throw new JSilverBadSyntaxException("HDF parsing error : '" + errorMessage + "'", lineContent, fileName, line, -1, null);
                }
            }, this.resourceLoader, null, this.options.getIgnoreAttributes());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int getIntValue(String hdfName, int defaultValue) {
        return this.data.getIntValue(hdfName, defaultValue);
    }

    public String getValue(String hdfName, String defaultValue) {
        return this.data.getValue(hdfName, defaultValue);
    }

    public void setValue(String hdfName, String value) {
        this.data.setValue(hdfName, value);
    }

    public void removeTree(String hdfName) {
        this.data.removeTree(hdfName);
    }

    public void setSymLink(String hdfNameSrc, String hdfNameDest) {
        this.data.setSymlink(hdfNameSrc, hdfNameDest);
    }

    public void exportDate(String hdfName, TimeZone timeZone, Date date) {
        throw new UnsupportedOperationException("TBD");
    }

    public void exportDate(String hdfName, String tz, int tt) {
        throw new UnsupportedOperationException("TBD");
    }

    public HDF getObj(String hdfpath) {
        Data d = this.data.getChild(hdfpath);
        return d == null ? null : new JHdf(d, this.dataFactory, this.loadPathCache, this.options);
    }

    public HDF getChild(String hdfpath) {
        Data d = this.data.getChild(hdfpath);
        if (d == null) {
            return null;
        }
        Iterator<? extends Data> i$ = d.getChildren().iterator();
        if (i$.hasNext()) {
            Data child = i$.next();
            if (child.isFirstSibling()) {
                return new JHdf(child, this.dataFactory, this.loadPathCache, this.options);
            }
            throw new IllegalStateException("First child was not first sibling.");
        }
        return null;
    }

    public HDF getRootObj() {
        Data root = this.data.getRoot();
        if (root == this.data) {
            return this;
        }
        return new JHdf(root, this.dataFactory, this.loadPathCache, this.options);
    }

    public boolean belongsToSameRoot(HDF hdf) {
        JHdf jHdf = JHdf.cast(hdf);
        return this.data.getRoot() == jHdf.data.getRoot();
    }

    public HDF getOrCreateObj(String hdfpath) {
        return new JHdf(this.data.createChild(hdfpath), this.dataFactory, this.loadPathCache, this.options);
    }

    public String objName() {
        return this.data.getName();
    }

    public String objValue() {
        return this.data.getValue();
    }

    public HDF objChild() {
        for (Data data : this.data.getChildren()) {
            if (!data.isFirstSibling()) continue;
            return new JHdf(data, this.dataFactory, this.loadPathCache, this.options);
        }
        return null;
    }

    public HDF objNext() {
        Data next = this.data.getNextSibling();
        return next == null ? null : new JHdf(next, this.dataFactory, this.loadPathCache, this.options);
    }

    public void copy(String hdfpath, HDF src) {
        JHdf srcJHdf = JHdf.cast(src);
        if (hdfpath.equals("")) {
            this.data.copy(srcJHdf.data);
        } else {
            this.data.copy(hdfpath, srcJHdf.data);
        }
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        try {
            this.data.write(sb, 0);
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String writeString() {
        return this.dump();
    }

    public String toString() {
        return this.dump();
    }

    public void optimize() {
        this.data.optimize();
    }
}

