/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.resourceloader.CompositeResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.FileSystemResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.doclava.ClassInfo;
import com.google.doclava.ClearPage;
import com.google.doclava.FederatedSite;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoclavaDiff {
    private final String outputDir;
    private final JSilver jSilver;
    private final List<FederatedSite> sites = new ArrayList<FederatedSite>();

    public static void main(String[] args) {
        new DoclavaDiff(args).generateSite();
    }

    public DoclavaDiff(String[] args) {
        try {
            this.sites.add(new FederatedSite("Android", new URL("http://manatee/doclava/android")));
            this.sites.add(new FederatedSite("GWT", new URL("http://manatee/doclava/gwt")));
            this.outputDir = "build";
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
        resourceLoaders.add(new FileSystemResourceLoader("assets/templates"));
        CompositeResourceLoader compositeResourceLoader = new CompositeResourceLoader(resourceLoaders);
        this.jSilver = new JSilver(compositeResourceLoader);
    }

    public void generateSite() {
        Data data = this.generateHdf();
        this.generateHtml("diff.cs", data, new File(this.outputDir + "/diff.html"));
    }

    private Data generateHdf() {
        Data data = this.jSilver.createData();
        data.setValue("triangle.opened", "../assets/templates/assets/images/triangle-opened.png");
        data.setValue("triangle.closed", "../assets/templates/assets/images/triangle-closed.png");
        int i = 0;
        for (FederatedSite site : this.sites) {
            String base = "sites." + i++;
            data.setValue(base + ".name", site.name());
            data.setValue(base + ".url", site.baseUrl().toString());
        }
        List<String> allPackages = this.knownPackages(this.sites);
        int p = 0;
        for (String pkg : allPackages) {
            PackageInfo packageInfo = new PackageInfo(pkg);
            String packageBase = "packages." + p++;
            data.setValue(packageBase + ".name", pkg);
            int s = 0;
            for (FederatedSite site : this.sites) {
                String siteBase = packageBase + ".sites." + s++;
                if (site.apiInfo().getPackages().containsKey(pkg)) {
                    data.setValue(siteBase + ".hasPackage", "1");
                    data.setValue(siteBase + ".link", site.linkFor(packageInfo.relativePath()));
                    continue;
                }
                data.setValue(siteBase + ".hasPackage", "0");
            }
            if (this.packageUniqueToSite(pkg, this.sites)) continue;
            List<String> packageClasses = this.knownClassesForPackage(pkg, this.sites);
            int c = 0;
            for (String qualifiedClassName : packageClasses) {
                String classBase = packageBase + ".classes." + c++;
                data.setValue(classBase + ".qualifiedName", qualifiedClassName);
                s = 0;
                for (FederatedSite site : this.sites) {
                    String siteBase = classBase + ".sites." + s++;
                    ClassInfo classInfo = site.apiInfo().findClass(qualifiedClassName);
                    if (classInfo != null) {
                        data.setValue(siteBase + ".hasClass", "1");
                        data.setValue(siteBase + ".link", site.linkFor(classInfo.relativePath()));
                        continue;
                    }
                    data.setValue(siteBase + ".hasClass", "0");
                }
                if (this.agreeOnClass(qualifiedClassName, this.sites) || this.classUniqueToSite(qualifiedClassName, this.sites)) continue;
                int m = 0;
                List<MethodInfo> methods = this.knownMethodsForClass(qualifiedClassName, this.sites);
                for (MethodInfo method : methods) {
                    if (this.agreeOnMethod(qualifiedClassName, method, this.sites)) continue;
                    String methodBase = classBase + ".methods." + m++;
                    data.setValue(methodBase + ".signature", method.prettySignature());
                    int k = 0;
                    for (FederatedSite site : this.sites) {
                        String siteBase = methodBase + ".sites." + k++;
                        if (site.apiInfo().findClass(qualifiedClassName) == null) {
                            data.setValue(siteBase + ".hasMethod", "0");
                            continue;
                        }
                        Map<String, MethodInfo> siteMethods = site.apiInfo().findClass(qualifiedClassName).allMethods();
                        if (siteMethods.containsKey(method.getHashableName())) {
                            data.setValue(siteBase + ".hasMethod", "1");
                            data.setValue(siteBase + ".link", site.linkFor(method.relativePath()));
                            continue;
                        }
                        data.setValue(siteBase + ".hasMethod", "0");
                    }
                }
            }
        }
        return data;
    }

    private List<String> knownPackages(List<FederatedSite> sites) {
        LinkedHashSet<String> allPackages = new LinkedHashSet<String>();
        for (FederatedSite site : sites) {
            HashMap<String, PackageInfo> packages = site.apiInfo().getPackages();
            for (String pkg : packages.keySet()) {
                allPackages.add(pkg);
            }
        }
        ArrayList<String> packages = new ArrayList<String>(allPackages);
        Collections.sort(packages);
        return packages;
    }

    private List<String> knownClassesForPackage(String pkg, List<FederatedSite> sites) {
        LinkedHashSet<String> allClasses = new LinkedHashSet<String>();
        for (FederatedSite site : sites) {
            PackageInfo packageInfo = site.apiInfo().getPackages().get(pkg);
            if (packageInfo == null) continue;
            HashMap<String, ClassInfo> classes = packageInfo.allClasses();
            for (Map.Entry<String, ClassInfo> entry : classes.entrySet()) {
                allClasses.add(entry.getValue().qualifiedName());
            }
        }
        ArrayList<String> classes = new ArrayList<String>(allClasses);
        Collections.sort(classes);
        return classes;
    }

    private List<MethodInfo> knownMethodsForClass(String qualifiedClassName, List<FederatedSite> sites) {
        HashMap<String, MethodInfo> allMethods = new HashMap<String, MethodInfo>();
        for (FederatedSite site : sites) {
            ClassInfo classInfo = site.apiInfo().findClass(qualifiedClassName);
            if (classInfo == null) continue;
            for (Map.Entry<String, MethodInfo> entry : classInfo.allMethods().entrySet()) {
                allMethods.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        methods.addAll(allMethods.values());
        return methods;
    }

    private boolean agreeOnPackage(String pkg, List<FederatedSite> sites) {
        for (FederatedSite site : sites) {
            if (site.apiInfo().getPackages().get(pkg) != null) continue;
            return false;
        }
        List<String> classes = this.knownClassesForPackage(pkg, sites);
        for (String clazz : classes) {
            if (this.agreeOnClass(clazz, sites)) continue;
            return false;
        }
        return true;
    }

    private boolean agreeOnClass(String qualifiedClassName, List<FederatedSite> sites) {
        List<MethodInfo> methods = this.knownMethodsForClass(qualifiedClassName, sites);
        for (MethodInfo method : methods) {
            if (this.agreeOnMethod(qualifiedClassName, method, sites)) continue;
            return false;
        }
        return true;
    }

    private boolean agreeOnMethod(String qualifiedClassName, MethodInfo method, List<FederatedSite> sites) {
        for (FederatedSite site : sites) {
            ClassInfo siteClass = site.apiInfo().findClass(qualifiedClassName);
            if (siteClass == null) {
                return false;
            }
            if (siteClass.containsMethod(method)) continue;
            return false;
        }
        return true;
    }

    private boolean packageUniqueToSite(String pkg, List<FederatedSite> sites) {
        int numSites = 0;
        for (FederatedSite site : sites) {
            if (!site.apiInfo().getPackages().containsKey(pkg)) continue;
            ++numSites;
        }
        return numSites == 1;
    }

    private boolean classUniqueToSite(String qualifiedClassName, List<FederatedSite> sites) {
        int numSites = 0;
        for (FederatedSite site : sites) {
            if (site.apiInfo().findClass(qualifiedClassName) == null) continue;
            ++numSites;
        }
        return numSites == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHtml(String template, Data data, File file) {
        ClearPage.ensureDirectory(file);
        OutputStreamWriter stream = null;
        try {
            stream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            String rendered = this.jSilver.render(template, data);
            stream.write(rendered, 0, rendered.length());
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage() + "; when writing file: " + file.getAbsolutePath());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

