/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.interpreter.OptimizerProvider;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import java.util.ArrayList;
import java.util.List;

public class OptimizingTemplateFactory
implements TemplateFactory {
    private final TemplateFactory wrapped;
    private final List<OptimizerProvider> optimizers;

    public OptimizingTemplateFactory(TemplateFactory wrapped, OptimizerProvider ... optimizers) {
        this.wrapped = wrapped;
        this.optimizers = new ArrayList<OptimizerProvider>();
        for (OptimizerProvider optimizer : optimizers) {
            if (optimizer == null) continue;
            this.optimizers.add(optimizer);
        }
    }

    private void optimize(TemplateSyntaxTree ast) {
        for (OptimizerProvider optimizer : this.optimizers) {
            ast.apply(optimizer.getOptimizer());
        }
    }

    public TemplateSyntaxTree createTemp(String content, EscapeMode escapeMode) {
        TemplateSyntaxTree result = this.wrapped.createTemp(content, escapeMode);
        this.optimize(result);
        return result;
    }

    public TemplateSyntaxTree find(String templateName, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        TemplateSyntaxTree result = this.wrapped.find(templateName, resourceLoader, escapeMode);
        this.optimize(result);
        return result;
    }
}

