/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compatibility;

import com.google.clearsilver.jsilver.TemplateRenderer;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.exceptions.JSilverException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.Template;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.clearsilver.CS;
import org.clearsilver.CSFileLoader;
import org.clearsilver.ClearsilverFactory;
import org.clearsilver.HDF;
import org.clearsilver.jni.JniClearsilverFactory;

public class ClearsilverRenderer
implements TemplateRenderer {
    private final ClearsilverFactory factory;
    private final ResourceLoader defaultResourceLoader;

    public ClearsilverRenderer(ClearsilverFactory factory, ResourceLoader resourceLoader) {
        this.factory = factory;
        this.defaultResourceLoader = resourceLoader;
    }

    public ClearsilverRenderer(ResourceLoader resourceLoader) {
        this(new JniClearsilverFactory(), resourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(String templateName, Data data, Appendable output, final ResourceLoader resourceLoader) throws IOException, JSilverException {
        CSFileLoader fileLoader = new CSFileLoader(){

            public String load(HDF hdf, String filename) throws IOException {
                return ClearsilverRenderer.this.loadResource(filename, resourceLoader);
            }
        };
        HDF hdf = this.factory.newHdf();
        try {
            hdf.readString(((Object)data).toString());
            CS cs = this.factory.newCs(hdf);
            try {
                cs.setFileLoader(fileLoader);
                cs.parseFile(templateName);
                output.append(cs.render());
            }
            finally {
                cs.close();
            }
        }
        finally {
            hdf.close();
        }
    }

    public void render(String templateName, Data data, Appendable output) throws IOException, JSilverException {
        this.render(templateName, data, output, this.defaultResourceLoader);
    }

    public String render(String templateName, Data data) throws IOException, JSilverException {
        StringBuilder output = new StringBuilder(8192);
        this.render(templateName, data, (Appendable)output);
        return ((Object)output).toString();
    }

    public void render(Template template, Data data, Appendable output, ResourceLoader resourceLoader) throws IOException, JSilverException {
        throw new UnsupportedOperationException("ClearsilverRenderer only expects template names, not Templates");
    }

    public void render(Template template, Data data, Appendable output) throws IOException, JSilverException {
        this.render(template, data, output, this.defaultResourceLoader);
    }

    public String render(Template template, Data data) throws IOException, JSilverException {
        StringBuilder output = new StringBuilder(8192);
        this.render(template, data, (Appendable)output);
        return ((Object)output).toString();
    }

    public void renderFromContent(String content, Data data, Appendable output) throws IOException, JSilverException {
        throw new UnsupportedOperationException();
    }

    public String renderFromContent(String content, Data data) throws IOException, JSilverException {
        StringBuilder output = new StringBuilder(8192);
        this.renderFromContent(content, data, output);
        return ((Object)output).toString();
    }

    private String loadResource(String filename, ResourceLoader resourceLoader) throws IOException {
        int count;
        Reader reader = resourceLoader.open(filename);
        if (reader == null) {
            throw new FileNotFoundException(filename);
        }
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((count = reader.read(buf)) != -1) {
            sb.append(buf, 0, count);
        }
        return sb.toString();
    }
}

