/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.interpreter.ExpressionEvaluator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADecNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.AExpandVariable;
import com.google.clearsilver.jsilver.syntax.node.AHexNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import com.google.clearsilver.jsilver.values.Value;

public class VariableLocator
extends DepthFirstAdapter {
    private StringBuilder currentName;
    private final ExpressionEvaluator expressionEvaluator;

    public VariableLocator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    private String quickEval(PVariable variable) {
        if (variable instanceof ANameVariable) {
            return ((ANameVariable)variable).getWord().getText();
        }
        if (variable instanceof ADecNumberVariable) {
            return ((ADecNumberVariable)variable).getDecNumber().getText();
        }
        if (variable instanceof AHexNumberVariable) {
            return ((AHexNumberVariable)variable).getHexNumber().getText();
        }
        return null;
    }

    public String getVariableName(PVariable variable) {
        String result = this.quickEval(variable);
        if (result != null) {
            return result;
        }
        StringBuilder lastName = this.currentName;
        this.currentName = new StringBuilder(10);
        variable.apply(this);
        result = this.currentName.toString();
        this.currentName = lastName;
        return result;
    }

    public void caseANameVariable(ANameVariable node) {
        this.descendVariable(node.getWord().getText());
    }

    public void caseADecNumberVariable(ADecNumberVariable node) {
        this.descendVariable(node.getDecNumber().getText());
    }

    public void caseAHexNumberVariable(AHexNumberVariable node) {
        this.descendVariable(node.getHexNumber().getText());
    }

    public void caseADescendVariable(ADescendVariable node) {
        node.getParent().apply(this);
        node.getChild().apply(this);
    }

    public void caseAExpandVariable(AExpandVariable node) {
        node.getParent().apply(this);
        Value value = this.expressionEvaluator.evaluate(node.getChild());
        this.descendVariable(value.asString());
    }

    private void descendVariable(String name) {
        if (this.currentName.length() != 0) {
            this.currentName.append('.');
        }
        this.currentName.append(name);
    }
}

