/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public class ModuleRules {
    private Map rules = new LinkedHashMap();

    public ModuleRules() {
    }

    private ModuleRules(Map rules) {
        this.rules = new LinkedHashMap(rules);
    }

    public void defineRule(MapMatcher condition, Object rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
    }

    public Object getRule(ModuleId mid) {
        return this.getRule(mid, NoFilter.INSTANCE);
    }

    public Object[] getRules(ModuleId mid) {
        return this.getRules(mid.getAttributes(), NoFilter.INSTANCE);
    }

    public Object getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.INSTANCE);
    }

    public Object getRule(ModuleId mid, Filter filter) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(mid.getAttributes(), filter);
    }

    public Object getRule(ModuleRevisionId mrid, Filter filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRule(moduleAttributes, filter);
    }

    private Object getRule(Map moduleAttributes, Filter filter) {
        Iterator iter = this.rules.entrySet().iterator();
        while (iter.hasNext()) {
            Object rule;
            Map.Entry ruleEntry = iter.next();
            MapMatcher midm = (MapMatcher)ruleEntry.getKey();
            if (!midm.matches(moduleAttributes) || !filter.accept(rule = ruleEntry.getValue())) continue;
            return rule;
        }
        return null;
    }

    public Object[] getRules(ModuleRevisionId mrid, Filter filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRules(moduleAttributes, filter);
    }

    private Object[] getRules(Map moduleAttributes, Filter filter) {
        ArrayList matchingRules = new ArrayList();
        Iterator iter = this.rules.entrySet().iterator();
        while (iter.hasNext()) {
            Object rule;
            Map.Entry ruleEntry = iter.next();
            MapMatcher midm = (MapMatcher)ruleEntry.getKey();
            if (!midm.matches(moduleAttributes) || !filter.accept(rule = ruleEntry.getValue())) continue;
            matchingRules.add(rule);
        }
        return matchingRules.toArray();
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
        } else {
            Iterator iter = this.rules.keySet().iterator();
            while (iter.hasNext()) {
                MapMatcher midm = (MapMatcher)iter.next();
                Object rule = this.rules.get(midm);
                Message.debug(prefix + midm + " -> " + rule);
            }
        }
    }

    public Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public Object clone() {
        return new ModuleRules(this.rules);
    }
}

