/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClassInfo;
import com.google.doclava.ClearPage;
import com.google.doclava.Doclava;
import com.google.doclava.FieldInfo;
import com.google.doclava.InheritedTags;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.Project;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TodoFile {
    public static final String MISSING = "No description text";

    public static boolean areTagsUseful(InheritedTags tags) {
        while (tags != null) {
            if (TodoFile.areTagsUseful(tags.tags())) {
                return true;
            }
            tags = tags.inherited();
        }
        return false;
    }

    public static boolean areTagsUseful(List<TagInfo> tags) {
        for (TagInfo t : tags) {
            if ("Text".equals(t.name()) && t.text().trim().length() != 0) {
                return true;
            }
            if (!"@inheritDoc".equals(t.name())) continue;
            return true;
        }
        return false;
    }

    public static void setHDF(Data data, String base, SourcePositionInfo pos, String name, String descr) {
        data.setValue(base + ".pos", pos.toString());
        data.setValue(base + ".name", name);
        data.setValue(base + ".descr", descr);
    }

    public static String percent(int a, int b) {
        return "" + Math.round((float)(b - a) / (float)b * 100.0f) + "%";
    }

    public static void writeTodoFile(String filename, Project project) {
        Data data = Doclava.makeHDF();
        Doclava.setPageTitle(data, "Missing Documentation");
        TreeMap<String, PackageStats> packageStats = new TreeMap<String, PackageStats>();
        List<ClassInfo> classes = project.rootClasses();
        Collections.sort(classes);
        int classIndex = 0;
        for (ClassInfo cl : classes) {
            PackageInfo pkg;
            String pkgName;
            PackageStats ps;
            boolean good;
            if (cl.isHidden()) continue;
            String classBase = "classes." + classIndex;
            String base = classBase + ".errors.";
            int errors = 0;
            int total = 1;
            if (!TodoFile.areTagsUseful(cl.inlineTags())) {
                TodoFile.setHDF(data, base + errors, cl.position(), "&lt;class comment&gt;", MISSING);
                ++errors;
            }
            for (MethodInfo m : cl.getConstructors()) {
                good = true;
                ++total;
                if (m.checkLevel() && !TodoFile.areTagsUseful(m.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, m.position(), m.prettySignature(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (MethodInfo m : cl.getMethods()) {
                good = true;
                ++total;
                if (m.checkLevel() && !TodoFile.areTagsUseful(m.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, m.position(), m.name() + m.prettySignature(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (FieldInfo f : cl.enumConstants()) {
                good = true;
                ++total;
                if (f.checkLevel() && !TodoFile.areTagsUseful(f.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, f.position(), f.name(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            for (FieldInfo f : cl.getFields()) {
                good = true;
                ++total;
                if (f.checkLevel() && !TodoFile.areTagsUseful(f.inlineTags())) {
                    TodoFile.setHDF(data, base + errors, f.position(), f.name(), MISSING);
                    good = false;
                }
                if (good) continue;
                ++errors;
            }
            if (errors > 0) {
                data.setValue(classBase + ".qualified", cl.qualifiedName());
                data.setValue(classBase + ".errorCount", "" + errors);
                data.setValue(classBase + ".totalCount", "" + total);
                data.setValue(classBase + ".percentGood", TodoFile.percent(errors, total));
            }
            if ((ps = (PackageStats)packageStats.get(pkgName = (pkg = cl.containingPackage()) != null ? pkg.name() : "")) == null) {
                ps = new PackageStats();
                ps.name = pkgName;
                packageStats.put(pkgName, ps);
            }
            ps.total += total;
            ps.errors += errors;
            ++classIndex;
        }
        int allTotal = 0;
        int allErrors = 0;
        int i = 0;
        for (PackageStats ps : packageStats.values()) {
            data.setValue("packages." + i + ".name", "" + ps.name);
            data.setValue("packages." + i + ".errorCount", "" + ps.errors);
            data.setValue("packages." + i + ".totalCount", "" + ps.total);
            data.setValue("packages." + i + ".percentGood", TodoFile.percent(ps.errors, ps.total));
            allTotal += ps.total;
            allErrors += ps.errors;
            ++i;
        }
        data.setValue("all.errorCount", "" + allErrors);
        data.setValue("all.totalCount", "" + allTotal);
        data.setValue("all.percentGood", TodoFile.percent(allErrors, allTotal));
        ClearPage.write(data, "todo.cs", filename, true);
    }

    static class PackageStats {
        String name;
        public int total;
        public int errors;

        PackageStats() {
        }
    }
}

