/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.coreit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CoreItMojo
extends AbstractMojo {
    private MavenProject project;
    private String outputDirectory;
    private Map pluginArtifacts;
    private File basedirAlignmentDirectory;
    private String pluginItem = "foo";
    private String goalItem = "bar";
    private String artifactToFile;
    private boolean fail = false;

    public void execute() throws MojoExecutionException {
        if (this.fail) {
            throw new MojoExecutionException("Failing per 'fail' parameter (specified in pom or system properties)");
        }
        CoreItMojo.touch(new File(this.outputDirectory), "touch.txt");
        if (this.basedirAlignmentDirectory.getPath().equals("target/test-basedir-alignment")) {
            throw new MojoExecutionException("basedirAlignmentDirectory not aligned");
        }
        CoreItMojo.touch(this.basedirAlignmentDirectory, "touch.txt");
        File outDir = new File(this.outputDirectory);
        if (this.pluginItem != null) {
            CoreItMojo.touch(outDir, this.pluginItem);
        }
        if (this.goalItem != null) {
            CoreItMojo.touch(outDir, this.goalItem);
        }
        if (this.artifactToFile != null) {
            Artifact artifact = (Artifact)this.pluginArtifacts.get(this.artifactToFile);
            File artifactFile = artifact.getFile();
            String filename = artifactFile.getAbsolutePath().replace('/', '_').replace(':', '_') + ".txt";
            CoreItMojo.touch(outDir, filename);
        }
        this.project.getBuild().setFinalName("coreitified");
    }

    private static void touch(File dir, String file) throws MojoExecutionException {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File touch = new File(dir, file);
            FileWriter w = new FileWriter(touch);
            w.write(file);
            w.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error touching file", (Exception)e);
        }
    }
}

