/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.testng.IClass;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitClassFinder
extends BaseClassFinder {
    public JUnitClassFinder(Class[] classes, XmlTest xmlTest, IAnnotationFinder finder) {
        Collection<Class> allClasses = JUnitClassFinder.invokeSuite(classes);
        for (Class cls : allClasses) {
            IClass ic = this.findOrCreateIClass(cls, null, xmlTest, finder);
            Utils.log("JUnitClassFinder", 3, "Looking up ClassFinder for " + cls + " " + cls.hashCode() + " " + finder.hashCode());
            if (null == ic) continue;
            this.putIClass(cls, ic);
        }
    }

    public static Collection<Class> invokeSuite(Class[] classes) {
        HashMap<Class, Class> vResult = new HashMap<Class, Class>();
        for (Class cls : classes) {
            Class[] allClasses;
            for (Class o : allClasses = JUnitClassFinder.invokeSuite(cls)) {
                vResult.put(o, o);
            }
        }
        return vResult.values();
    }

    public static Class[] invokeSuite(Class cls) {
        ArrayList<Class> vResult = new ArrayList<Class>();
        Method suiteMethod = null;
        try {
            suiteMethod = cls.getMethod("suite", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (null != suiteMethod) {
            try {
                Object instance = null;
                if (!Modifier.isStatic(suiteMethod.getModifiers())) {
                    instance = cls.newInstance();
                }
                TestSuite ts = (TestSuite)suiteMethod.invoke(instance, new Object[0]);
                for (int i = 0; i < ts.testCount(); ++i) {
                    Test test = ts.testAt(i);
                    if (test instanceof TestSuite) {
                        TestSuite testSuite = (TestSuite)test;
                        for (int j = 0; j < testSuite.testCount(); ++j) {
                            Test subTest = testSuite.testAt(j);
                            try {
                                Class subTestClass = JUnitClassFinder.getTestClass(subTest);
                                if (subTestClass == null) continue;
                                Class[] subObjects = JUnitClassFinder.invokeSuite(subTestClass);
                                if (subObjects.length > 0) {
                                    vResult.addAll(Arrays.asList(subObjects));
                                    continue;
                                }
                                vResult.add(subTestClass);
                                continue;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    vResult.add(test.getClass());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            vResult.add(cls);
        }
        Class[] result = vResult.toArray(new Class[vResult.size()]);
        return result;
    }

    private static Class getTestClass(Object test) {
        Class<?> result;
        block4: {
            result = null;
            String testName = test.toString();
            try {
                result = Class.forName(testName);
            }
            catch (ClassNotFoundException e) {
                int l = testName.indexOf("(");
                int r = testName.indexOf(")");
                if (l == -1 || r == -1) break block4;
                String className = testName.substring(l + 1, r);
                try {
                    result = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    result = null;
                }
            }
        }
        return result;
    }

    public JUnitClassFinder findClassFinder(Class currentClass, Class[] others, XmlTest xmlTest, IAnnotationFinder finder) {
        ArrayList<Class> vOtherClasses = new ArrayList<Class>();
        for (Class cls : others) {
            if (this.classExists(cls)) continue;
            vOtherClasses.add(cls);
        }
        Class[] otherClasses = vOtherClasses.toArray(new Class[vOtherClasses.size()]);
        JUnitClassFinder result = new JUnitClassFinder(otherClasses, xmlTest, finder);
        return result;
    }

    private static void ppp(String s) {
        System.out.println("[JUnitClassFinder] " + s);
    }
}

