/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.jersey.media.htmljson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.glassfish.jersey.test.TestProperties;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

import net.java.html.json.Model;

/**
 * Reading and writing class generated by {@link Model} as
 * {@link List}.
 *
 * @author Jaroslav Tulach
 */
public class ModelEntityOnListTest extends AbstractTypeTester {

    @Path("empty")
    public static class TestResource {

        @POST
        @Path("mybean")
        public String myBean(List<MyBean> bean) {
            if (bean.size() != 2) {
                return "ERROR, length: " + bean.size();
            }
            if (!bean.get(0).getValue().equals("Hello")) {
                return "ERROR, [0].value = " + bean.get(0).getValue();
            }
            if (!bean.get(1).getValue().equals("Ahoy")) {
                return "ERROR, [1].value = " + bean.get(1).getValue();
            }
            return "PASSED";
        }

        @GET
        @Path("getbean")
        public Response getBean(@Context HttpHeaders headers) {
            MyBean teb = new MyBean();
            teb.setValue("hello");
            List<MyBean> l = new ArrayList<MyBean>();
            l.add(teb);
            GenericEntity<List<MyBean>> ge = new GenericEntity<List<MyBean>>(l) {};
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity(ge).build();
        }
    }

    public ModelEntityOnListTest() {
        enable(TestProperties.LOG_TRAFFIC);
    }

    @Test
    public void myBeanAndPut() {
        WebTarget target = target("empty/mybean");

        MyBean mb = new MyBean();
        mb.setValue("Hello");
        MyBean ah = new MyBean();
        ah.setValue("Ahoy");
        GenericEntity<List<MyBean>> ge = new GenericEntity<List<MyBean>>(Arrays.asList(mb, ah)) {};
        final Response response = target.request().post(Entity.entity(ge, MediaType.APPLICATION_JSON_TYPE));

        assertEquals(200, response.getStatus());
        assertEquals("PASSED", response.readEntity(String.class));
    }

    @Test
    public void myBeanAndGet() {
        WebTarget target = target("empty/getbean");
        final Response response = target.request(MediaType.APPLICATION_JSON).get();
        assertEquals(200, response.getStatus());
        GenericType<List<MyBean>> ge = new GenericType<List<MyBean>>() {};
        List<MyBean> teb = response.readEntity(ge);

        assertEquals("one element in list: " + teb, 1, teb.size());
        assertEquals("value", "hello", teb.get(0).getValue());
    }
}
