/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.hk2.testing.test;

import javax.inject.Inject;
import javax.inject.Named;

import org.glassfish.hk2.api.ServiceLocator;

import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

import org.junit.Rule;
import org.junit.Test;

import org.junit.rules.TestRule;

import org.junit.runner.Description;

import org.jvnet.hk2.testing.junit.ServiceLocatorTestRule;
import org.jvnet.hk2.testing.junit.ServiceLocatorTestRule.ServiceLocatorIsolation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class ServiceLocatorTestRuleTest {

  @Rule
  public final ServiceLocatorTestRule<ServiceLocatorTestRuleTest> serviceLocatorTestRule;

  @Inject
  private ServiceLocator serviceLocator;

  @Inject
  private Description description;
  
  public ServiceLocatorTestRuleTest() {
    super();
    this.serviceLocatorTestRule = new ServiceLocatorTestRule<ServiceLocatorTestRuleTest>(this, ServiceLocatorIsolation.PER_TEST);
  }

  @Test
  public void testServiceLocatorIsPresent() {
    assertNotNull(this.serviceLocator);
  }

  @Test
  public void testServiceLocatorNameIsCorrect() {
    assertNotNull(this.serviceLocator);
    assertEquals(this.getClass().getName() + "." + "testServiceLocatorNameIsCorrect", this.serviceLocator.getName());
  }

  @Test
  public void testDescriptionIsNonNull() {
    assertNotNull(this.description);
  }

  @Test
  public void testDescriptionIsForThisMethod() {
    assertNotNull(this.description);
    assertEquals(this.getClass().getName(), this.description.getClassName());
    assertEquals("testDescriptionIsForThisMethod", this.description.getMethodName());
  }

}
