/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.thread.ExecutorAdapter;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThread;

public class ThreadUtil {
    private static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void execute(List<? extends Runnable> list, int n, long l, boolean bl) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        CountDownLatch countDownLatch2 = new CountDownLatch(list.size());
        Utils.log("ThreadUtil", 2, "Starting executor timeOut:" + l + "ms" + " workers:" + list.size() + " threadPoolSize:" + n);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, l, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(ThreadUtil.THREAD_NAME);
                return thread;
            }
        });
        List list2 = Lists.newArrayList();
        for (final Runnable runnable : list) {
            list2.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        }
        try {
            if (l != 0L) {
                threadPoolExecutor.invokeAll(list2, l, TimeUnit.MILLISECONDS);
            } else {
                threadPoolExecutor.invokeAll(list2);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            threadPoolExecutor.shutdown();
        }
    }

    public static final String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return String.valueOf(thread.getName() + "@" + thread.hashCode());
    }

    public static final IExecutor createExecutor(int n, String string) {
        return new ExecutorAdapter(n, ThreadUtil.createFactory(string));
    }

    private static final IThreadFactory createFactory(String string) {
        return new ThreadFactoryImpl(string);
    }

    private static void log(int n, String string) {
        Utils.log("ThreadUtil:" + ThreadUtil.currentThreadInfo(), n, string);
    }

    public static class ThreadFactoryImpl
    implements IThreadFactory,
    ThreadFactory {
        private String m_methodName;
        private List<Thread> m_threads = Lists.newArrayList();

        public ThreadFactoryImpl(String string) {
            this.m_methodName = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            TestNGThread testNGThread = new TestNGThread(runnable, this.m_methodName);
            this.m_threads.add(testNGThread);
            return testNGThread;
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public List<Thread> getThreads() {
            return this.m_threads;
        }
    }
}

