/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class TimesPanel
extends BaseMultiSuitePanel {
    private Map<String, Long> m_totalTime = Maps.newHashMap();

    public TimesPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "times-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return "Times for " + iSuite.getName();
    }

    private String js(ISuite iSuite) {
        String string = "tableData_" + TimesPanel.suiteToTag(iSuite);
        StringBuilder stringBuilder = new StringBuilder("suiteTableInitFunctions.push('" + string + "');\n" + "function " + string + "() {\n" + "var data = new google.visualization.DataTable();\n" + "data.addColumn('number', 'Number');\n" + "data.addColumn('string', 'Method');\n" + "data.addColumn('string', 'Class');\n" + "data.addColumn('number', 'Time (ms)');\n");
        List<ITestResult> list = this.getModel().getAllTestResults(iSuite);
        stringBuilder.append("data.addRows(" + list.size() + ");\n");
        Collections.sort(list, new Comparator<ITestResult>(){

            @Override
            public int compare(ITestResult iTestResult, ITestResult iTestResult2) {
                long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
                long l2 = iTestResult2.getEndMillis() - iTestResult2.getStartMillis();
                return (int)(l2 - l);
            }
        });
        int n = 0;
        for (ITestResult iTestResult : list) {
            ITestNGMethod iTestNGMethod = iTestResult.getMethod();
            long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
            stringBuilder.append("data.setCell(" + n + ", " + "0, " + n + ")\n").append("data.setCell(" + n + ", " + "1, '" + iTestNGMethod.getMethodName() + "')\n").append("data.setCell(" + n + ", " + "2, '" + iTestNGMethod.getTestClass().getName() + "')\n").append("data.setCell(" + n + ", " + "3, " + l + ");\n");
            Long l2 = this.m_totalTime.get(iSuite.getName());
            if (l2 == null) {
                l2 = 0L;
            }
            this.m_totalTime.put(iSuite.getName(), l2 + l);
            ++n;
        }
        stringBuilder.append("window.suiteTableData['" + TimesPanel.suiteToTag(iSuite) + "']" + "= { tableData: data, tableDiv: 'times-div-" + TimesPanel.suiteToTag(iSuite) + "'}\n" + "return data;\n" + "}\n");
        return stringBuilder.toString();
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        xMLStringBuffer2.push("div", "class", "times-div");
        xMLStringBuffer2.push("script", "type", "text/javascript");
        xMLStringBuffer2.addString(this.js(iSuite));
        xMLStringBuffer2.pop("script");
        Long l = this.m_totalTime.get(iSuite.getName());
        if (l != null) {
            xMLStringBuffer2.addRequired("span", String.format("Total running time: %s", this.prettyDuration(l)), "class", "suite-total-time");
        }
        xMLStringBuffer2.push("div", "id", "times-div-" + TimesPanel.suiteToTag(iSuite));
        xMLStringBuffer2.pop("div");
        xMLStringBuffer2.pop("div");
        return xMLStringBuffer2.toXML();
    }

    private String prettyDuration(long l) {
        String string = l < 1000L ? l + " ms" : (l < 60000L ? l / 1000L + " seconds" : (l < 3600000L ? l / 1000L / 60L + " minutes" : l / 1000L / 60L / 60L + " hours"));
        return string;
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return "Times";
    }
}

