/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.IResultListener2;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;

public class JUnitXMLReporter
implements IResultListener2 {
    private static final Pattern ENTITY = Pattern.compile("&[a-zA-Z]+;.*");
    private static final Pattern LESS = Pattern.compile("<");
    private static final Pattern GREATER = Pattern.compile(">");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Map<String, Pattern> ATTR_ESCAPES = Maps.newHashMap();
    private int m_numPassed = 0;
    private int m_numFailed = 0;
    private int m_numSkipped = 0;
    private int m_numFailedButIgnored = 0;
    private List<ITestResult> m_allTests = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestResult> m_configIssues = Collections.synchronizedList(Lists.newArrayList());
    private Map<String, String> m_fileNameMap = Maps.newHashMap();
    private int m_fileNameIncrementer = 0;

    @Override
    public void onTestStart(ITestResult iTestResult) {
    }

    @Override
    public void beforeConfiguration(ITestResult iTestResult) {
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
        ++this.m_numPassed;
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
        ++this.m_numFailedButIgnored;
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
        ++this.m_numFailed;
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
        this.m_allTests.add(iTestResult);
        ++this.m_numSkipped;
    }

    @Override
    public void onStart(ITestContext iTestContext) {
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
        this.generateReport(iTestContext);
        this.resetAll();
    }

    @Override
    public void onConfigurationFailure(ITestResult iTestResult) {
        this.m_configIssues.add(iTestResult);
    }

    @Override
    public void onConfigurationSkip(ITestResult iTestResult) {
        this.m_configIssues.add(iTestResult);
    }

    @Override
    public void onConfigurationSuccess(ITestResult iTestResult) {
    }

    protected void generateReport(ITestContext iTestContext) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        xMLStringBuffer.addComment("Generated by " + this.getClass().getName());
        Properties properties = new Properties();
        properties.setProperty("errors", "0");
        properties.setProperty("failures", "" + this.m_numFailed);
        try {
            properties.setProperty("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Set<String> set = this.getPackages(iTestContext);
        if (set.size() > 0) {
            properties.setProperty("name", iTestContext.getCurrentXmlTest().getName());
        }
        properties.setProperty("tests", "" + this.m_allTests.size());
        properties.setProperty("time", "" + (double)(iTestContext.getEndDate().getTime() - iTestContext.getStartDate().getTime()) / 1000.0);
        Date date = Calendar.getInstance().getTime();
        properties.setProperty("timestamp", date.toGMTString());
        xMLStringBuffer.push("testsuite", properties);
        this.createElementFromTestResults(xMLStringBuffer, this.m_configIssues);
        this.createElementFromTestResults(xMLStringBuffer, this.m_allTests);
        xMLStringBuffer.pop();
        Utils.writeUtf8File(iTestContext.getOutputDirectory(), this.generateFileName(iTestContext) + ".xml", xMLStringBuffer.toXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createElementFromTestResults(XMLStringBuffer xMLStringBuffer, List<ITestResult> list) {
        List<ITestResult> list2 = list;
        synchronized (list2) {
            for (ITestResult iTestResult : list) {
                this.createElement(xMLStringBuffer, iTestResult);
            }
        }
    }

    private Set<String> getPackages(ITestContext iTestContext) {
        Set<String> set = Sets.newHashSet();
        for (ITestNGMethod iTestNGMethod : iTestContext.getAllTestMethods()) {
            Package package_ = iTestNGMethod.getMethod().getDeclaringClass().getPackage();
            if (package_ == null) continue;
            set.add(package_.getName());
        }
        return set;
    }

    private void createElement(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Properties properties = new Properties();
        long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
        String string = iTestResult.getMethod().isTest() ? iTestResult.getName() : Utils.detailedMethodName(iTestResult.getMethod(), false);
        properties.setProperty("name", string);
        properties.setProperty("classname", iTestResult.getTestClass().getRealClass().getName());
        properties.setProperty("time", "" + (double)l / 1000.0);
        if (2 == iTestResult.getStatus() || 3 == iTestResult.getStatus()) {
            xMLStringBuffer.push("testcase", properties);
            if (2 == iTestResult.getStatus()) {
                this.createFailureElement(xMLStringBuffer, iTestResult);
            } else if (3 == iTestResult.getStatus()) {
                this.createSkipElement(xMLStringBuffer, iTestResult);
            }
            xMLStringBuffer.pop();
        } else {
            xMLStringBuffer.addEmptyElement("testcase", properties);
        }
    }

    private void createFailureElement(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        Properties properties = new Properties();
        Throwable throwable = iTestResult.getThrowable();
        if (throwable != null) {
            properties.setProperty("type", throwable.getClass().getName());
            String string = throwable.getMessage();
            if (string != null && string.length() > 0) {
                properties.setProperty("message", this.encodeAttr(string));
            }
            xMLStringBuffer.push("failure", properties);
            xMLStringBuffer.addCDATA(Utils.stackTrace(throwable, false)[0]);
            xMLStringBuffer.pop();
        } else {
            xMLStringBuffer.addEmptyElement("failure");
        }
    }

    private void createSkipElement(XMLStringBuffer xMLStringBuffer, ITestResult iTestResult) {
        xMLStringBuffer.addEmptyElement("skipped");
    }

    private String encodeAttr(String string) {
        String string2 = this.replaceAmpersand(string, ENTITY);
        for (Map.Entry<String, Pattern> entry : ATTR_ESCAPES.entrySet()) {
            string2 = entry.getValue().matcher(string2).replaceAll(entry.getKey());
        }
        return string2;
    }

    private String replaceAmpersand(String string, Pattern pattern) {
        int n = 0;
        int n2 = string.indexOf(38, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            if (pattern.matcher(string.substring(n2)).matches()) {
                stringBuffer.append("&");
            } else {
                stringBuffer.append("&amp;");
            }
            n = n2 + 1;
            n2 = string.indexOf(38, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private void resetAll() {
        this.m_allTests = Collections.synchronizedList(Lists.newArrayList());
        this.m_configIssues = Collections.synchronizedList(Lists.newArrayList());
        this.m_numFailed = 0;
        this.m_numFailedButIgnored = 0;
        this.m_numPassed = 0;
        this.m_numSkipped = 0;
    }

    private String generateFileName(ITestContext iTestContext) {
        String string = null;
        String string2 = iTestContext.getSuite().getName() + iTestContext.getName();
        string = this.m_fileNameMap.get(string2) == null ? iTestContext.getName() : iTestContext.getName() + this.m_fileNameIncrementer++;
        this.m_fileNameMap.put(string2, string);
        return string;
    }

    static {
        ATTR_ESCAPES.put("&lt;", LESS);
        ATTR_ESCAPES.put("&gt;", GREATER);
        ATTR_ESCAPES.put("&apos;", SINGLE_QUOTE);
        ATTR_ESCAPES.put("&quot;", QUOTE);
    }
}

