/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Bsh;
import org.testng.internal.BshMock;
import org.testng.internal.Dynamic;
import org.testng.internal.IBsh;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;

public class XmlMethodSelector
implements IMethodSelector {
    private static final long serialVersionUID = -9030548178025605629L;
    private Map<String, String> m_includedGroups = Maps.newHashMap();
    private Map<String, String> m_excludedGroups = Maps.newHashMap();
    private List<XmlClass> m_classes = null;
    private String m_expression = null;
    private ListMultiMap<String, XmlInclude> m_includedMethods = Maps.newListMultiMap();
    private IBsh m_bsh = Dynamic.hasBsh() ? new Bsh() : new BshMock();
    private Map<String, String> m_logged = Maps.newHashMap();
    private boolean m_isInitialized = false;
    private List<ITestNGMethod> m_testMethods = null;

    @Override
    public boolean includeMethod(IMethodSelectorContext iMethodSelectorContext, ITestNGMethod iTestNGMethod, boolean bl) {
        if (!this.m_isInitialized) {
            this.m_isInitialized = true;
            this.init(iMethodSelectorContext);
        }
        boolean bl2 = false;
        if (null != this.m_expression) {
            return this.m_bsh.includeMethodFromExpression(this.m_expression, iTestNGMethod);
        }
        bl2 = this.includeMethodFromIncludeExclude(iTestNGMethod, bl);
        return bl2;
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod iTestNGMethod, boolean bl) {
        boolean bl2 = false;
        Method method = iTestNGMethod.getMethod();
        String[] stringArray = iTestNGMethod.getGroups();
        Map<String, String> map = this.m_includedGroups;
        Map<String, String> map2 = this.m_excludedGroups;
        List list = (List)this.m_includedMethods.get(MethodHelper.calculateMethodCanonicalName(iTestNGMethod));
        if (map.size() == 0 && map2.size() == 0 && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            bl2 = true;
        } else if (map.size() == 0 && map2.size() == 0 && !bl) {
            bl2 = true;
        } else if (!list.isEmpty()) {
            bl2 = true;
        } else {
            boolean bl3 = XmlMethodSelector.isIncluded(stringArray, this.m_includedGroups.values());
            boolean bl4 = XmlMethodSelector.isExcluded(stringArray, this.m_excludedGroups.values());
            if (bl3 && !bl4) {
                bl2 = true;
            } else if (bl4) {
                bl2 = false;
            }
            if (bl) {
                Method method2 = iTestNGMethod.getMethod();
                Class<?> clazz = method2.getDeclaringClass();
                String string = clazz.getName() + "." + method2.getName();
                String[] stringArray2 = new String[]{string};
                for (XmlClass xmlClass : this.m_classes) {
                    Class clazz2 = xmlClass.getSupportClass();
                    if (!this.assignable(clazz, clazz2)) continue;
                    List<String> list2 = this.createQualifiedMethodNames(xmlClass, this.toStringList(xmlClass.getIncludedMethods()));
                    boolean bl5 = XmlMethodSelector.isIncluded(stringArray2, list2);
                    List<String> list3 = this.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean bl6 = XmlMethodSelector.isExcluded(stringArray2, list3);
                    if (!bl2) continue;
                    bl2 = bl5 && !bl6;
                }
            }
        }
        Package package_ = method.getDeclaringClass().getPackage();
        String string = package_ != null ? package_.getName() + "." + method.getName() : method.getName();
        this.logInclusion(bl2 ? "Including" : "Excluding", "method", string + "()");
        return bl2;
    }

    private boolean assignable(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    private void logInclusion(String string, String string2, String string3) {
        if (!this.m_logged.containsKey(string3)) {
            XmlMethodSelector.log(4, string + " " + string2 + " " + string3);
            this.m_logged.put(string3, string3);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<String> toStringList(List<XmlInclude> list) {
        List<String> list2 = Lists.newArrayList();
        for (XmlInclude xmlInclude : list) {
            list2.add(xmlInclude.getName());
        }
        return list2;
    }

    private List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> list) {
        List<String> list2 = Lists.newArrayList();
        for (Class clazz = xmlClass.getSupportClass(); null != clazz; clazz = clazz.getSuperclass()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                Method[] methodArray = ReflectionHelper.getLocalMethods(clazz);
                Pattern pattern = Pattern.compile(string2);
                for (Method method : methodArray) {
                    if (!pattern.matcher(method.getName()).matches()) continue;
                    list2.add(this.makeMethodName(method.getDeclaringClass().getName(), method.getName()));
                }
            }
        }
        return list2;
    }

    private String makeMethodName(String string, String string2) {
        return string + "." + string2;
    }

    private void checkMethod(Class<?> clazz, String string) {
        Pattern pattern = Pattern.compile(string);
        for (Method method : clazz.getMethods()) {
            if (!pattern.matcher(method.getName()).matches()) continue;
            return;
        }
        Utils.log("Warning", 2, "The regular expression \"" + string + "\" didn't match any" + " method in class " + clazz.getName());
    }

    public void setXmlClasses(List<XmlClass> list) {
        this.m_classes = list;
        for (XmlClass xmlClass : list) {
            for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                this.checkMethod(xmlClass.getSupportClass(), xmlInclude.getName());
                String string = this.makeMethodName(xmlClass.getName(), xmlInclude.getName());
                this.m_includedMethods.put(string, xmlInclude);
            }
        }
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> map) {
        this.m_excludedGroups = map;
    }

    public void setIncludedGroups(Map<String, String> map) {
        this.m_includedGroups = map;
    }

    private static boolean isIncluded(String[] stringArray, Collection<String> collection) {
        if (collection.size() == 0) {
            return true;
        }
        return XmlMethodSelector.isMemberOf(stringArray, collection);
    }

    private static boolean isExcluded(String[] stringArray, Collection<String> collection) {
        return XmlMethodSelector.isMemberOf(stringArray, collection);
    }

    private static boolean isMemberOf(String[] stringArray, Collection<String> collection) {
        for (String string : stringArray) {
            for (String string2 : collection) {
                String string3 = string2.toString();
                boolean bl = Pattern.matches(string3, string);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(int n, String string) {
        Utils.log("XmlMethodSelector", n, string);
    }

    private static void ppp(String string) {
        System.out.println("[XmlMethodSelector] " + string);
    }

    public void setExpression(String string) {
        this.m_expression = string;
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> list) {
        this.m_testMethods = list;
    }

    private void init(IMethodSelectorContext iMethodSelectorContext) {
        String[] stringArray = this.m_includedGroups.keySet().toArray(new String[this.m_includedGroups.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<ITestNGMethod> hashSet2 = new HashSet<ITestNGMethod>();
        List<ITestNGMethod> list = Lists.newArrayList();
        for (ITestNGMethod object : this.m_testMethods) {
            if (!this.includeMethod(iMethodSelectorContext, object, true)) continue;
            list.add(object);
        }
        MethodGroupsHelper.findGroupTransitiveClosure(this, list, this.m_testMethods, stringArray, hashSet, hashSet2);
        if (this.m_includedGroups.size() > 0) {
            for (String string : hashSet) {
                XmlMethodSelector.log(4, "Including group " + (this.m_includedGroups.containsKey(string) ? ": " : "(implicitly): ") + string);
                this.m_includedGroups.put(string, string);
            }
            for (ITestNGMethod iTestNGMethod : hashSet2) {
                String string = iTestNGMethod.getQualifiedName();
                XmlInclude xmlInclude = new XmlInclude(string);
                this.m_includedMethods.put(string, xmlInclude);
                this.logInclusion("Including", "method ", string);
            }
        }
    }
}

