/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ClassMethodMap;
import org.testng.IClassListener;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlSuite;

public class TestMethodWorker
implements IWorker<ITestNGMethod> {
    private IMethodInstance[] m_methodInstances;
    private final IInvoker m_invoker;
    private final Map<String, String> m_parameters;
    private final XmlSuite m_suite;
    private List<ITestResult> m_testResults = Lists.newArrayList();
    private final ConfigurationGroupMethods m_groupMethods;
    private final ClassMethodMap m_classMethodMap;
    private final ITestContext m_testContext;
    private final List<IClassListener> m_listeners;

    public TestMethodWorker(IInvoker iInvoker, IMethodInstance[] iMethodInstanceArray, XmlSuite xmlSuite, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, ClassMethodMap classMethodMap, ITestContext iTestContext, List<IClassListener> list) {
        this.m_invoker = iInvoker;
        this.m_methodInstances = iMethodInstanceArray;
        this.m_suite = xmlSuite;
        this.m_parameters = map;
        this.m_groupMethods = configurationGroupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = iTestContext;
        this.m_listeners = list;
    }

    @Override
    public long getTimeOut() {
        long l = 0L;
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
            if (iTestNGMethod.getTimeOut() <= l) continue;
            l = iTestNGMethod.getTimeOut();
        }
        return l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Worker thread:" + Thread.currentThread().getId() + " priority:" + this.getPriority() + " ");
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            stringBuilder.append(iMethodInstance.getMethod()).append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
            ITestClass iTestClass = iTestNGMethod.getTestClass();
            this.invokeBeforeClassMethods(iTestClass, iMethodInstance);
            try {
                this.invokeTestMethods(iTestNGMethod, iMethodInstance.getInstance(), this.m_testContext);
            }
            finally {
                this.invokeAfterClassMethods(iTestClass, iMethodInstance);
            }
        }
    }

    protected void invokeTestMethods(ITestNGMethod iTestNGMethod, Object object, ITestContext iTestContext) {
        List<ITestResult> list = this.m_invoker.invokeTestMethods(iTestNGMethod, this.m_suite, this.m_parameters, this.m_groupMethods, object, iTestContext);
        if (list != null) {
            this.m_testResults.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeBeforeClassMethods(ITestClass iTestClass, IMethodInstance iMethodInstance) {
        if (this.m_classMethodMap == null) {
            return;
        }
        Map<ITestClass, Set<Object>> map = this.m_classMethodMap.getInvokedBeforeClassMethods();
        ITestClass iTestClass2 = iTestClass;
        synchronized (iTestClass2) {
            Set<Object> set = map.get(iTestClass);
            if (null == set) {
                set = new HashSet<Object>();
                map.put(iTestClass, set);
            }
            for (Object object : iMethodInstance.getInstances()) {
                if (set.contains(object)) continue;
                set.add(object);
                for (IClassListener iClassListener : this.m_listeners) {
                    iClassListener.onBeforeClass(iTestClass);
                }
                this.m_invoker.invokeConfigurations(iTestClass, iTestClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void invokeAfterClassMethods(ITestClass iTestClass, IMethodInstance iMethodInstance) {
        if (this.m_classMethodMap == null) {
            return;
        }
        List<Object> list = Lists.newArrayList();
        ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
        if (this.m_classMethodMap.removeAndCheckIfLast(iTestNGMethod, iMethodInstance.getInstance())) {
            Map<ITestClass, Set<Object>> map = this.m_classMethodMap.getInvokedAfterClassMethods();
            Iterator<Object> iterator = map;
            synchronized (iterator) {
                Set<Object> object = map.get(iTestClass);
                if (null == object) {
                    HashSet hashSet = new HashSet();
                    map.put(iTestClass, hashSet);
                }
                for (Object object2 : iMethodInstance.getInstances()) {
                    void var7_9;
                    if (var7_9.contains(object2)) continue;
                    list.add(object2);
                }
            }
            for (IClassListener iClassListener : this.m_listeners) {
                iClassListener.onAfterClass(iTestClass);
            }
            for (Object object : list) {
                this.m_invoker.invokeConfigurations(iTestClass, iTestClass.getAfterClassMethods(), this.m_suite, this.m_parameters, null, object);
            }
        }
    }

    protected int indexOf(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        for (int i = 0; i < iTestNGMethodArray.length; ++i) {
            if (iTestNGMethodArray[i] != iTestNGMethod) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    private void ppp(String string) {
        Utils.log("TestMethodWorker", 2, ThreadUtil.currentThreadInfo() + ":" + string);
    }

    @Override
    public List<ITestNGMethod> getTasks() {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            list.add(iMethodInstance.getMethod());
        }
        return list;
    }

    @Override
    public int compareTo(IWorker<ITestNGMethod> iWorker) {
        return this.getPriority() - iWorker.getPriority();
    }

    @Override
    public int getPriority() {
        return this.m_methodInstances.length > 0 ? this.m_methodInstances[0].getMethod().getPriority() : 0;
    }
}

