/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;

public class ClassInfoMap {
    private Map<Class<?>, XmlClass> m_map = Maps.newLinkedHashMap();
    private boolean includeNestedClasses;

    public ClassInfoMap() {
    }

    public ClassInfoMap(List<XmlClass> list) {
        this(list, true);
    }

    public ClassInfoMap(List<XmlClass> list, boolean bl) {
        this.includeNestedClasses = bl;
        for (XmlClass xmlClass : list) {
            try {
                Class clazz = xmlClass.getSupportClass();
                this.registerClass(clazz, xmlClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Utils.log("[ClassInfoMap]", 1, "Unable to open class " + xmlClass.getName() + " - unable to resolve class reference " + noClassDefFoundError.getMessage());
                if (!xmlClass.loadClasses()) continue;
                throw noClassDefFoundError;
            }
        }
    }

    private void registerClass(Class clazz, XmlClass xmlClass) {
        this.m_map.put(clazz, xmlClass);
        if (this.includeNestedClasses) {
            for (Class<?> clazz2 : clazz.getClasses()) {
                if (this.m_map.containsKey(clazz2)) continue;
                this.registerClass(clazz2, xmlClass);
            }
        }
    }

    public void addClass(Class<?> clazz) {
        this.m_map.put(clazz, null);
    }

    public XmlClass getXmlClass(Class<?> clazz) {
        return this.m_map.get(clazz);
    }

    public void put(Class<?> clazz, XmlClass xmlClass) {
        this.m_map.put(clazz, xmlClass);
    }

    public Set<Class<?>> getClasses() {
        return this.m_map.keySet();
    }

    public int getSize() {
        return this.m_map.size();
    }
}

