/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.osgi.framework.Version;
import org.testng.TestNGException;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.support.RemoteTestNGFactory;

public final class ServiceLoaderHelper {
    private ServiceLoaderHelper() {
    }

    public static RemoteTestNGFactory getFirst(Version version) {
        ArrayList<RemoteTestNGFactory> factories = new ArrayList<RemoteTestNGFactory>();
        for (RemoteTestNGFactory factory : ServiceLoader.load(RemoteTestNGFactory.class)) {
            if (!factory.accept(version)) continue;
            factories.add(factory);
        }
        if (factories.isEmpty()) {
            throw new TestNGException(version + " is not a supported TestNG version");
        }
        if (factories.size() > 1) {
            System.err.println("[ServiceLoaderHelper] More than one working implementation for '" + version + "', we will use the first one");
        }
        Collections.sort(factories, new Comparator<RemoteTestNGFactory>(){

            @Override
            public int compare(RemoteTestNGFactory o1, RemoteTestNGFactory o2) {
                return o2.getOrder() - o1.getOrder();
            }
        });
        return (RemoteTestNGFactory)factories.get(0);
    }

    public static RemoteTestNGFactory getFirstQuietly(String version) {
        return ServiceLoaderHelper.getFirstQuietly(Version.parseVersion(version));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RemoteTestNGFactory getFirstQuietly(Version version) {
        ClassLoader cl = RemoteTestNGFactory.class.getClassLoader();
        if (!(cl instanceof URLClassLoader)) throw new TestNGException(version + " is not a supported TestNG version");
        URL[] uRLArray = ((URLClassLoader)cl).getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            block37: {
                URL url = uRLArray[n2];
                File f = new File(url.getFile());
                if (f.isFile() && f.getName().startsWith("testng-remote")) {
                    try (JarFile jarFile = new JarFile(f);){
                        JarEntry entry = jarFile.getJarEntry("META-INF/services/" + RemoteTestNGFactory.class.getName());
                        if (entry == null) break block37;
                        ArrayList<String> names = new ArrayList<String>();
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry), "utf-8"));){
                            int lc = 1;
                            while ((lc = ServiceLoaderHelper.parseLine(RemoteTestNGFactory.class, url, r, lc, names)) >= 0) {
                            }
                            for (String name : names) {
                                Class<?> c = Class.forName(name, false, cl);
                                RemoteTestNGFactory factory = (RemoteTestNGFactory)c.newInstance();
                                if (!factory.accept(version)) continue;
                                RemoteTestNGFactory remoteTestNGFactory = factory;
                                return remoteTestNGFactory;
                            }
                        }
                    }
                    catch (TestNGException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (!RemoteTestNG.isDebug()) break block37;
                        ex.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        throw new TestNGException(version + " is not a supported TestNG version");
    }

    private static int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoaderHelper.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceLoaderHelper.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceLoaderHelper.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoaderHelper.fail(service, u + ":" + line + ": " + msg);
    }
}

