/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.testng.internal.Nullable;
import org.testng.reporters.Buffer;
import org.testng.reporters.IBuffer;

public final class XMLUtils {
    private static final String EOL = System.getProperty("line.separator");

    private XMLUtils() {
    }

    public static String xml(String string, String string2, @Nullable String string3, @Nullable Properties properties) {
        IBuffer iBuffer = Buffer.create();
        XMLUtils.xmlOpen(iBuffer, string, string2, properties, true);
        if (string3 != null) {
            iBuffer.append(string3);
        }
        XMLUtils.xmlClose(iBuffer, "", string2, XMLUtils.extractComment(string2, properties));
        return iBuffer.toString();
    }

    public static String extractComment(String string, Properties properties) {
        String[] stringArray;
        if (properties == null || "span".equals(string)) {
            return null;
        }
        for (String string2 : stringArray = new String[]{"id", "name", "class"}) {
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            return " <!-- " + string3.replaceAll("[-]{2,}", "-") + " -->";
        }
        return null;
    }

    public static void xmlOptional(IBuffer iBuffer, String string, String string2, Boolean bl, Properties properties) {
        if (null != bl) {
            XMLUtils.xmlRequired(iBuffer, string, string2, bl.toString(), properties);
        }
    }

    public static void xmlOptional(IBuffer iBuffer, String string, String string2, @Nullable String string3, Properties properties) {
        if (null != string3) {
            XMLUtils.xmlRequired(iBuffer, string, string2, string3, properties);
        }
    }

    public static void xmlRequired(IBuffer iBuffer, String string, String string2, @Nullable String string3, @Nullable Properties properties) {
        iBuffer.append(XMLUtils.xml(string, string2, string3, properties));
    }

    public static void xmlOpen(IBuffer iBuffer, String string, String string2, Properties properties) {
        XMLUtils.xmlOpen(iBuffer, string, string2, properties, false);
    }

    public static void appendAttributes(IBuffer iBuffer, Properties properties) {
        if (null != properties) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry;
                Map.Entry<Object, Object> entry2 = entry = iterator.next();
                String string = entry2.getKey().toString();
                String string2 = XMLUtils.escape(entry2.getValue().toString());
                iBuffer.append(" ").append(string).append("=\"").append(string2).append("\"");
            }
        }
    }

    public static void xmlOpen(IBuffer iBuffer, String string, String string2, Properties properties, boolean bl) {
        iBuffer.append(string).append("<").append(string2);
        XMLUtils.appendAttributes(iBuffer, properties);
        iBuffer.append(">");
        if (!bl) {
            iBuffer.append(EOL);
        }
    }

    public static void xmlClose(IBuffer iBuffer, String string, String string2, String string3) {
        iBuffer.append(string).append("</").append(string2).append(">").append(string3 != null ? string3 : "").append(EOL);
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '\"') {
                stringBuilder.append("&quot;");
            } else if (c == '\'') {
                stringBuilder.append("&#039;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }
}

