/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorModel;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.swingui.BufferTreeModel;
import net.grinder.console.swingui.Colours;
import net.grinder.console.swingui.CompositeTreeModel;
import net.grinder.console.swingui.CustomAction;
import net.grinder.console.swingui.FileTreeModel;
import net.grinder.console.swingui.TeeAction;

final class FileTree {
    private final Resources m_resources;
    private final ErrorHandler m_errorHandler;
    private final EditorModel m_editorModel;
    private final BufferTreeModel m_bufferTreeModel;
    private final FileTreeModel m_fileTreeModel;
    private final ConsoleProperties m_properties;
    private final JTree m_tree;
    private final OpenAction m_openAction;
    private final OpenExternalAction m_openExternalAction;
    private final SelectPropertiesAction m_selectPropertiesAction;
    private final DeselectPropertiesAction m_deselectPropertiesAction;
    private final JScrollPane m_scrollPane;

    public FileTree(Resources resources, ErrorHandler errorHandler, EditorModel editorModel, BufferTreeModel bufferTreeModel, FileTreeModel fileTreeModel, Font font, JPopupMenu popupMenu, ConsoleProperties properties) {
        this.m_resources = resources;
        this.m_errorHandler = errorHandler;
        this.m_editorModel = editorModel;
        this.m_bufferTreeModel = bufferTreeModel;
        this.m_fileTreeModel = fileTreeModel;
        this.m_properties = properties;
        CompositeTreeModel compositeTreeModel = new CompositeTreeModel();
        compositeTreeModel.addTreeModel(this.m_bufferTreeModel, false);
        compositeTreeModel.addTreeModel(this.m_fileTreeModel, true);
        this.m_tree = new JTree(compositeTreeModel){

            public void updateUI() {
                super.updateUI();
                if (!this.isRootVisible()) {
                    this.setBackground(new JLabel().getBackground());
                    this.setCellRenderer(new CustomTreeCellRenderer(this.getFont(), this.getBackground()));
                }
            }
        };
        this.m_tree.setBackground(new JLabel().getBackground());
        this.m_tree.setFont(font);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new CustomTreeCellRenderer(this.m_tree.getFont(), this.m_tree.getBackground()));
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addMouseListener(new MouseListener(popupMenu));
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FileTree.this.updateActionState();
            }
        });
        this.m_openAction = new OpenAction();
        this.m_openExternalAction = new OpenExternalAction();
        this.m_selectPropertiesAction = new SelectPropertiesAction();
        this.m_deselectPropertiesAction = new DeselectPropertiesAction();
        InputMap inputMap = this.m_tree.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "activateNode");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "activateNode");
        ActionMap actionMap = this.m_tree.getActionMap();
        actionMap.put("activateNode", new TeeAction(actionMap.get("toggle"), this.m_openAction));
        this.m_scrollPane = new JScrollPane(this.m_tree);
        this.m_scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.m_editorModel.addListener(new EditorModelListener());
        this.updateActionState();
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public CustomAction[] getActions() {
        return new CustomAction[]{this.m_openAction, this.m_openExternalAction, this.m_selectPropertiesAction, this.m_deselectPropertiesAction};
    }

    private void updateActionState() {
        Object selectedNode;
        this.m_deselectPropertiesAction.setEnabled(this.m_editorModel.getSelectedPropertiesFile() != null);
        if (this.m_tree.isEnabled() && (selectedNode = this.m_tree.getLastSelectedPathComponent()) instanceof Node) {
            Node node = (Node)selectedNode;
            Buffer buffer = node.getBuffer();
            File file = node.getFile();
            this.m_openAction.setEnabled(node.canOpen() && (buffer == null || !buffer.equals(this.m_editorModel.getSelectedBuffer())));
            this.m_openAction.setRelevantToSelection(node.canOpen());
            this.m_openExternalAction.setEnabled(file != null && file.isFile());
            this.m_openExternalAction.setRelevantToSelection(node.canOpen());
            this.m_selectPropertiesAction.setEnabled(this.m_editorModel.isPropertiesFile(file) && !file.equals(this.m_editorModel.getSelectedPropertiesFile()));
            this.m_selectPropertiesAction.setRelevantToSelection(this.m_selectPropertiesAction.isEnabled());
            this.m_deselectPropertiesAction.setRelevantToSelection(this.m_editorModel.isPropertiesFile(file) && !this.m_selectPropertiesAction.isEnabled());
            return;
        }
        this.m_openAction.setEnabled(false);
        this.m_openAction.setRelevantToSelection(false);
        this.m_openExternalAction.setEnabled(false);
        this.m_openExternalAction.setRelevantToSelection(false);
        this.m_selectPropertiesAction.setEnabled(false);
        this.m_selectPropertiesAction.setRelevantToSelection(false);
        this.m_deselectPropertiesAction.setRelevantToSelection(false);
    }

    private TreePath treePathForFileNode(FileTreeModel.FileNode fileNode) {
        Object[] original = fileNode.getPath().getPath();
        Object[] result = new Object[original.length + 1];
        System.arraycopy(original, 0, result, 1, original.length);
        result[0] = this.m_tree.getModel().getRoot();
        return new TreePath(result);
    }

    static interface Node {
        public Buffer getBuffer();

        public File getFile();

        public TreePath getPath();

        public boolean canOpen();
    }

    private final class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final DefaultTreeCellRenderer m_defaultRenderer = new DefaultTreeCellRenderer();
        private final Font m_boldFont;
        private final Font m_boldItalicFont;
        private final ImageIcon m_propertiesIcon = FileTree.access$1000(FileTree.this).getImageIcon("file.properties.image");
        private final ImageIcon m_markedPropertiesIcon = FileTree.access$1000(FileTree.this).getImageIcon("file.selectedproperties.image");
        private final ImageIcon m_pythonIcon = FileTree.access$1000(FileTree.this).getImageIcon("file.python.image");
        private final ImageIcon m_selectedPythonIcon = FileTree.access$1000(FileTree.this).getImageIcon("file.selectedpython.image");
        private boolean m_active;

        CustomTreeCellRenderer(Font baseFont, Color background) {
            this.m_boldFont = baseFont.deriveFont(1);
            this.m_boldItalicFont = this.m_boldFont.deriveFont(3);
            this.m_defaultRenderer.setBackgroundNonSelectionColor(background);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Node) {
                Node node = (Node)value;
                File file = node.getFile();
                if (file != null && !file.isFile()) {
                    return this.m_defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
                Icon icon = file != null && file.equals(FileTree.this.m_editorModel.getSelectedPropertiesFile()) ? this.m_markedPropertiesIcon : (FileTree.this.m_editorModel.isSelectedScript(file) ? this.m_selectedPythonIcon : (FileTree.this.m_editorModel.isPropertiesFile(file) ? this.m_propertiesIcon : (FileTree.this.m_editorModel.isPythonFile(file) ? this.m_pythonIcon : this.m_defaultRenderer.getLeafIcon())));
                this.setLeafIcon(icon);
                Buffer buffer = node.getBuffer();
                this.setTextNonSelectionColor(buffer == null && FileTree.this.m_editorModel.isBoringFile(file) ? Colours.INACTIVE_TEXT : this.m_defaultRenderer.getTextNonSelectionColor());
                if (buffer != null) {
                    this.setFont(buffer.isDirty() ? this.m_boldItalicFont : this.m_boldFont);
                    this.m_active = buffer.equals(FileTree.this.m_editorModel.getSelectedBuffer());
                } else {
                    this.setFont(this.m_defaultRenderer.getFont());
                    this.m_active = false;
                }
                return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return this.m_defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return result != null ? new Dimension(result.width + 3, result.height) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            Color backgroundColour;
            if (this.m_active) {
                backgroundColour = Colours.FAINT_YELLOW;
                this.setTextSelectionColor(Colours.BLACK);
                this.setTextNonSelectionColor(Colours.BLACK);
            } else if (this.selected) {
                backgroundColour = this.m_defaultRenderer.getBackgroundSelectionColor();
                this.setTextSelectionColor(this.m_defaultRenderer.getTextSelectionColor());
            } else {
                backgroundColour = this.m_defaultRenderer.getBackgroundNonSelectionColor();
                this.setTextNonSelectionColor(this.m_defaultRenderer.getTextNonSelectionColor());
            }
            if (backgroundColour != null) {
                g.setColor(backgroundColour);
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
            }
            boolean oldHasFocus = this.hasFocus;
            boolean oldSelected = this.selected;
            Color oldBackgroundNonSelectionColour = this.getBackgroundNonSelectionColor();
            try {
                this.hasFocus = false;
                this.selected = false;
                this.setBackgroundNonSelectionColor(backgroundColour);
                super.paint(g);
                Object var7_6 = null;
                this.hasFocus = oldHasFocus;
                this.selected = oldSelected;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.hasFocus = oldHasFocus;
                this.selected = oldSelected;
                this.setBackgroundNonSelectionColor(oldBackgroundNonSelectionColour);
                throw throwable;
            }
            this.setBackgroundNonSelectionColor(oldBackgroundNonSelectionColour);
            Color borderColour = this.m_active ? this.getTextNonSelectionColor() : (this.hasFocus ? this.getBorderSelectionColor() : null);
            if (borderColour != null) {
                g.setColor(borderColour);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private final class DeselectPropertiesAction
    extends CustomAction {
        public DeselectPropertiesAction() {
            super(FileTree.this.m_resources, "deselect-properties");
        }

        public void actionPerformed(ActionEvent event) {
            this.invoke();
        }

        public void invoke() {
            try {
                FileTreeModel.Node fileNode;
                File previousProperties = FileTree.this.m_properties.getPropertiesFile();
                FileTree.this.m_properties.setAndSavePropertiesFile(null);
                FileTree.this.updateActionState();
                if (previousProperties != null && (fileNode = FileTree.this.m_fileTreeModel.findNode(previousProperties)) != null) {
                    FileTree.this.m_fileTreeModel.valueForPathChanged(fileNode.getPath(), fileNode);
                    FileTree.this.m_bufferTreeModel.bufferChanged(fileNode.getBuffer());
                }
            }
            catch (ConsoleException e) {
                FileTree.this.m_errorHandler.handleException(e);
            }
        }
    }

    private final class SelectPropertiesAction
    extends CustomAction {
        public SelectPropertiesAction() {
            super(FileTree.this.m_resources, "select-properties");
        }

        public void actionPerformed(ActionEvent event) {
            this.invoke();
        }

        public void invoke() {
            Node node;
            File file;
            Object selectedNode = FileTree.this.m_tree.getLastSelectedPathComponent();
            if (selectedNode instanceof Node && (file = (node = (Node)selectedNode).getFile()).isFile()) {
                try {
                    FileTree.this.m_properties.setAndSavePropertiesFile(file);
                }
                catch (ConsoleException e) {
                    FileTree.this.m_errorHandler.handleException(e);
                    return;
                }
                FileTree.this.m_bufferTreeModel.valueForPathChanged(node.getPath(), node);
                FileTree.this.updateActionState();
            }
        }
    }

    private final class OpenExternalAction
    extends CustomAction {
        public OpenExternalAction() {
            super(FileTree.this.m_resources, "open-file-external");
        }

        public void actionPerformed(ActionEvent event) {
            Node node;
            File file;
            Object selectedNode = FileTree.this.m_tree.getLastSelectedPathComponent();
            if (selectedNode instanceof Node && (file = (node = (Node)selectedNode).getFile()) != null) {
                Buffer buffer = node.getBuffer();
                if (buffer != null && buffer.isDirty() && JOptionPane.showConfirmDialog(FileTree.this.getComponent(), FileTree.this.m_resources.getString("externalEditModifiedBufferConfirmation.text"), file.toString(), 0) == 1) {
                    return;
                }
                try {
                    FileTree.this.m_editorModel.openWithExternalEditor(file);
                }
                catch (ConsoleException e) {
                    FileTree.this.m_errorHandler.handleException(e, FileTree.this.m_resources.getString("fileError.title"));
                }
            }
        }
    }

    private final class OpenAction
    extends CustomAction {
        public OpenAction() {
            super(FileTree.this.m_resources, "open-file");
        }

        public void actionPerformed(ActionEvent event) {
            this.invoke(FileTree.this.m_tree.getLastSelectedPathComponent());
        }

        public void invoke(Object selectedNode) {
            if (selectedNode instanceof BufferTreeModel.BufferNode) {
                FileTree.this.m_editorModel.selectBuffer(((BufferTreeModel.BufferNode)selectedNode).getBuffer());
            } else if (selectedNode instanceof FileTreeModel.FileNode) {
                FileTreeModel.FileNode fileNode = (FileTreeModel.FileNode)selectedNode;
                try {
                    fileNode.setBuffer(FileTree.this.m_editorModel.selectBufferForFile(fileNode.getFile()));
                    FileTree.this.m_tree.setSelectionPath(FileTree.this.treePathForFileNode(fileNode));
                }
                catch (ConsoleException e) {
                    FileTree.this.m_errorHandler.handleException(e, FileTree.this.m_resources.getString("fileError.title"));
                }
            }
        }
    }

    private class EditorModelListener
    extends EditorModel.AbstractListener {
        private EditorModelListener() {
        }

        public void bufferAdded(Buffer buffer) {
            int rowHeight = ((FileTree)FileTree.this).m_tree.getRowBounds((int)0).height;
            JScrollBar verticalScrollBar = FileTree.this.m_scrollPane.getVerticalScrollBar();
            verticalScrollBar.setValue(verticalScrollBar.getValue() + rowHeight);
        }

        public void bufferStateChanged(Buffer buffer) {
            FileTreeModel.FileNode fileNode;
            File file = buffer.getFile();
            if (file != null) {
                FileTreeModel.FileNode oldFileNode = FileTree.this.m_fileTreeModel.findFileNode(buffer);
                FileTreeModel.Node node = FileTree.this.m_fileTreeModel.findNode(file);
                if (oldFileNode == null || !oldFileNode.equals(node)) {
                    if (oldFileNode != null) {
                        oldFileNode.setBuffer(null);
                    }
                    if (node instanceof FileTreeModel.FileNode) {
                        FileTreeModel.FileNode fileNode2 = (FileTreeModel.FileNode)node;
                        fileNode2.setBuffer(buffer);
                        FileTree.this.m_tree.scrollPathToVisible(FileTree.this.treePathForFileNode(fileNode2));
                    }
                }
            }
            if ((fileNode = FileTree.this.m_fileTreeModel.findFileNode(buffer)) != null) {
                FileTree.this.m_fileTreeModel.valueForPathChanged(fileNode.getPath(), fileNode);
            }
            FileTree.this.m_bufferTreeModel.bufferChanged(buffer);
            FileTree.this.updateActionState();
        }

        public void bufferRemoved(Buffer buffer) {
            FileTreeModel.FileNode fileNode = FileTree.this.m_fileTreeModel.findFileNode(buffer);
            if (fileNode != null) {
                fileNode.setBuffer(null);
                FileTree.this.m_fileTreeModel.valueForPathChanged(fileNode.getPath(), fileNode);
            }
        }
    }

    private final class MouseListener
    extends MouseAdapter {
        private final JPopupMenu m_popupMenu;
        private boolean m_handledOnPress;

        private MouseListener(JPopupMenu popupMenu) {
            this.m_popupMenu = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.m_handledOnPress = false;
            if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e)) {
                TreePath path = FileTree.this.m_tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                Object selectedNode = path.getLastPathComponent();
                if (selectedNode instanceof Node) {
                    boolean hasBuffer;
                    Node node = (Node)selectedNode;
                    int clickCount = e.getClickCount();
                    boolean bl = hasBuffer = node.getBuffer() != null;
                    if (clickCount == 2 || clickCount == 1 && hasBuffer) {
                        FileTree.this.m_openAction.invoke(node);
                        this.m_handledOnPress = true;
                        e.consume();
                    }
                    if (clickCount == 2 && hasBuffer && FileTree.this.m_selectPropertiesAction.isEnabled()) {
                        FileTree.this.m_selectPropertiesAction.invoke();
                        this.m_handledOnPress = true;
                        e.consume();
                    }
                }
            }
            if (e.isPopupTrigger()) {
                this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.m_handledOnPress) {
                e.consume();
            }
            if (e.isPopupTrigger()) {
                this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

