/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.PortView;

public class DefaultEdge
extends DefaultGraphCell
implements Edge {
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object object) {
        this(object, null);
    }

    public DefaultEdge(Object object, AttributeMap attributeMap) {
        super(object, attributeMap);
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    public Object clone() {
        DefaultEdge defaultEdge = (DefaultEdge)super.clone();
        defaultEdge.source = null;
        defaultEdge.target = null;
        return defaultEdge;
    }

    public static class DefaultRouting
    extends LoopRouting {
        protected List routeEdge(EdgeView edgeView) {
            Point2D[] point2DArray;
            Cloneable cloneable;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = edgeView.getPointCount();
            Point2D point2D = edgeView.getPoint(0);
            arrayList.add(point2D);
            if (edgeView.getSource() instanceof PortView) {
                arrayList.set(0, edgeView.getSource());
                point2D = ((PortView)edgeView.getSource()).getLocation();
            } else if (edgeView.getSource() != null) {
                cloneable = edgeView.getSource().getBounds();
                point2D = edgeView.getAttributes().createPoint(((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getCenterY());
            }
            cloneable = edgeView.getPoint(n - 1);
            CellView cellView = edgeView.getTarget();
            if (cellView instanceof PortView) {
                cloneable = ((PortView)cellView).getLocation();
            } else if (cellView != null) {
                point2DArray = cellView.getBounds();
                cloneable = edgeView.getAttributes().createPoint(point2DArray.getCenterX(), point2DArray.getCenterY());
            }
            if (point2D != null && cloneable != null) {
                double d = Math.abs(point2D.getX() - ((Point2D)cloneable).getX());
                double d2 = Math.abs(point2D.getY() - ((Point2D)cloneable).getY());
                double d3 = point2D.getX() + (((Point2D)cloneable).getX() - point2D.getX()) / 2.0;
                double d4 = point2D.getY() + (((Point2D)cloneable).getY() - point2D.getY()) / 2.0;
                point2DArray = new Point2D[2];
                if (d > d2) {
                    point2DArray[0] = edgeView.getAttributes().createPoint(d3, point2D.getY());
                    point2DArray[1] = edgeView.getAttributes().createPoint(d3, ((Point2D)cloneable).getY());
                } else {
                    point2DArray[0] = edgeView.getAttributes().createPoint(point2D.getX(), d4);
                    point2DArray[1] = edgeView.getAttributes().createPoint(((Point2D)cloneable).getX(), d4);
                }
                for (int i = 0; i < point2DArray.length; ++i) {
                    arrayList.add(point2DArray[i]);
                }
                if (cellView != null) {
                    arrayList.add(cellView);
                } else {
                    arrayList.add(cloneable);
                }
                return arrayList;
            }
            return null;
        }
    }

    public static class LoopRouting
    implements Edge.Routing {
        public List route(EdgeView edgeView) {
            if (edgeView.isLoop()) {
                return this.routeLoop(edgeView);
            }
            return this.routeEdge(edgeView);
        }

        protected List routeLoop(EdgeView edgeView) {
            CellView cellView;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(edgeView.getSource());
            CellView cellView2 = cellView = edgeView.getSource() != null ? edgeView.getSource().getParentView() : edgeView.getSourceParentView();
            if (cellView != null) {
                Point2D point2D = AbstractCellView.getCenterPoint(cellView);
                Rectangle2D rectangle2D = cellView.getBounds();
                double d = rectangle2D.getWidth();
                double d2 = rectangle2D.getHeight() / 2.0;
                double d3 = Math.min(20.0, Math.max(10.0, d / 8.0));
                double d4 = Math.min(30.0, Math.max(12.0, Math.max(d3 + 4.0, d2 / 2.0)));
                arrayList.add(edgeView.getAttributes().createPoint(point2D.getX() - d3, point2D.getY() - d2 - d4 * 1.2));
                arrayList.add(edgeView.getAttributes().createPoint(point2D.getX(), point2D.getY() - d2 - 1.5 * d4));
                arrayList.add(edgeView.getAttributes().createPoint(point2D.getX() + d3, point2D.getY() - d2 - d4 * 1.2));
                arrayList.add(edgeView.getTarget());
                return arrayList;
            }
            return null;
        }

        protected List routeEdge(EdgeView edgeView) {
            return null;
        }

        public int getPreferredLineStyle(EdgeView edgeView) {
            if (edgeView.isLoop()) {
                return this.getLoopStyle();
            }
            return this.getEdgeStyle();
        }

        protected int getLoopStyle() {
            return 12;
        }

        protected int getEdgeStyle() {
            return -1;
        }
    }
}

