/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.google.common.cache.CacheBuilder;
import org.python.google.common.cache.CacheLoader;
import org.python.google.common.cache.LoadingCache;
import org.python.google.common.cache.Weigher;
import org.python.modules.sre.SRE_REPEAT;

public class SRE_STATE {
    public static final int SRE_MAGIC = 20031017;
    public static final int SRE_OP_FAILURE = 0;
    public static final int SRE_OP_SUCCESS = 1;
    public static final int SRE_OP_ANY = 2;
    public static final int SRE_OP_ANY_ALL = 3;
    public static final int SRE_OP_ASSERT = 4;
    public static final int SRE_OP_ASSERT_NOT = 5;
    public static final int SRE_OP_AT = 6;
    public static final int SRE_OP_BRANCH = 7;
    public static final int SRE_OP_CALL = 8;
    public static final int SRE_OP_CATEGORY = 9;
    public static final int SRE_OP_CHARSET = 10;
    public static final int SRE_OP_BIGCHARSET = 11;
    public static final int SRE_OP_GROUPREF = 12;
    public static final int SRE_OP_GROUPREF_EXISTS = 13;
    public static final int SRE_OP_GROUPREF_IGNORE = 14;
    public static final int SRE_OP_IN = 15;
    public static final int SRE_OP_IN_IGNORE = 16;
    public static final int SRE_OP_INFO = 17;
    public static final int SRE_OP_JUMP = 18;
    public static final int SRE_OP_LITERAL = 19;
    public static final int SRE_OP_LITERAL_IGNORE = 20;
    public static final int SRE_OP_MARK = 21;
    public static final int SRE_OP_MAX_UNTIL = 22;
    public static final int SRE_OP_MIN_UNTIL = 23;
    public static final int SRE_OP_NOT_LITERAL = 24;
    public static final int SRE_OP_NOT_LITERAL_IGNORE = 25;
    public static final int SRE_OP_NEGATE = 26;
    public static final int SRE_OP_RANGE = 27;
    public static final int SRE_OP_REPEAT = 28;
    public static final int SRE_OP_REPEAT_ONE = 29;
    public static final int SRE_OP_SUBPATTERN = 30;
    public static final int SRE_OP_MIN_REPEAT_ONE = 31;
    public static final int SRE_AT_BEGINNING = 0;
    public static final int SRE_AT_BEGINNING_LINE = 1;
    public static final int SRE_AT_BEGINNING_STRING = 2;
    public static final int SRE_AT_BOUNDARY = 3;
    public static final int SRE_AT_NON_BOUNDARY = 4;
    public static final int SRE_AT_END = 5;
    public static final int SRE_AT_END_LINE = 6;
    public static final int SRE_AT_END_STRING = 7;
    public static final int SRE_AT_LOC_BOUNDARY = 8;
    public static final int SRE_AT_LOC_NON_BOUNDARY = 9;
    public static final int SRE_AT_UNI_BOUNDARY = 10;
    public static final int SRE_AT_UNI_NON_BOUNDARY = 11;
    public static final int SRE_CATEGORY_DIGIT = 0;
    public static final int SRE_CATEGORY_NOT_DIGIT = 1;
    public static final int SRE_CATEGORY_SPACE = 2;
    public static final int SRE_CATEGORY_NOT_SPACE = 3;
    public static final int SRE_CATEGORY_WORD = 4;
    public static final int SRE_CATEGORY_NOT_WORD = 5;
    public static final int SRE_CATEGORY_LINEBREAK = 6;
    public static final int SRE_CATEGORY_NOT_LINEBREAK = 7;
    public static final int SRE_CATEGORY_LOC_WORD = 8;
    public static final int SRE_CATEGORY_LOC_NOT_WORD = 9;
    public static final int SRE_CATEGORY_UNI_DIGIT = 10;
    public static final int SRE_CATEGORY_UNI_NOT_DIGIT = 11;
    public static final int SRE_CATEGORY_UNI_SPACE = 12;
    public static final int SRE_CATEGORY_UNI_NOT_SPACE = 13;
    public static final int SRE_CATEGORY_UNI_WORD = 14;
    public static final int SRE_CATEGORY_UNI_NOT_WORD = 15;
    public static final int SRE_CATEGORY_UNI_LINEBREAK = 16;
    public static final int SRE_CATEGORY_UNI_NOT_LINEBREAK = 17;
    public static final int SRE_FLAG_TEMPLATE = 1;
    public static final int SRE_FLAG_IGNORECASE = 2;
    public static final int SRE_FLAG_LOCALE = 4;
    public static final int SRE_FLAG_MULTILINE = 8;
    public static final int SRE_FLAG_DOTALL = 16;
    public static final int SRE_FLAG_UNICODE = 32;
    public static final int SRE_FLAG_VERBOSE = 64;
    public static final int SRE_INFO_PREFIX = 1;
    public static final int SRE_INFO_LITERAL = 2;
    public static final int SRE_INFO_CHARSET = 4;
    public static final int USE_RECURSION_LIMIT = 5000;
    public static final int SRE_ERROR_ILLEGAL = -1;
    public static final int SRE_ERROR_STATE = -2;
    public static final int SRE_ERROR_RECURSION_LIMIT = -3;
    private static byte[] sre_char_info = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 16, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 0, 0};
    private static byte[] sre_char_lower = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    int ptr;
    int start;
    int end;
    private int[] str;
    int pos;
    int endpos;
    private int charsize;
    int lastindex;
    int lastmark;
    int[] mark = new int[200];
    private int[] mark_stack;
    private int mark_stack_size;
    private int mark_stack_base;
    private SRE_REPEAT repeat;
    private int flags;
    private static final boolean do_trace = false;

    private static boolean SRE_IS_DIGIT(int ch) {
        if (ch < 128) {
            return (sre_char_info[ch] & 1) != 0;
        }
        return false;
    }

    private static boolean SRE_IS_SPACE(int ch) {
        if (ch < 128) {
            return (sre_char_info[ch] & 2) != 0;
        }
        return false;
    }

    private static boolean SRE_IS_LINEBREAK(int ch) {
        return ch == 10;
    }

    private static boolean SRE_IS_WORD(int ch) {
        if (ch < 128) {
            return (sre_char_info[ch] & 0x10) != 0;
        }
        return false;
    }

    private int lower(int ch) {
        if ((this.flags & 4) != 0) {
            if (ch < 256) {
                return Character.toLowerCase(ch);
            }
            return ch;
        }
        if ((this.flags & 0x20) != 0) {
            return Character.toLowerCase(ch);
        }
        if (ch < 128) {
            return (char)sre_char_lower[ch];
        }
        return ch;
    }

    private static boolean SRE_LOC_IS_WORD(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 95;
    }

    private static boolean SRE_UNI_IS_LINEBREAK(int ch) {
        switch (ch) {
            case 10: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 133: 
            case 8232: 
            case 8233: {
                return true;
            }
        }
        return false;
    }

    private boolean sre_category(int category, int ch) {
        switch (category) {
            case 0: {
                return SRE_STATE.SRE_IS_DIGIT(ch);
            }
            case 1: {
                return !SRE_STATE.SRE_IS_DIGIT(ch);
            }
            case 2: {
                return SRE_STATE.SRE_IS_SPACE(ch);
            }
            case 3: {
                return !SRE_STATE.SRE_IS_SPACE(ch);
            }
            case 4: {
                return SRE_STATE.SRE_IS_WORD(ch);
            }
            case 5: {
                return !SRE_STATE.SRE_IS_WORD(ch);
            }
            case 6: {
                return SRE_STATE.SRE_IS_LINEBREAK(ch);
            }
            case 7: {
                return !SRE_STATE.SRE_IS_LINEBREAK(ch);
            }
            case 8: {
                return SRE_STATE.SRE_LOC_IS_WORD(ch);
            }
            case 9: {
                return !SRE_STATE.SRE_LOC_IS_WORD(ch);
            }
            case 10: {
                return Character.isDigit(ch);
            }
            case 11: {
                return !Character.isDigit(ch);
            }
            case 12: {
                return Character.isWhitespace(ch);
            }
            case 13: {
                return !Character.isWhitespace(ch);
            }
            case 14: {
                return Character.isLetterOrDigit(ch) || ch == 95;
            }
            case 15: {
                return !Character.isLetterOrDigit(ch) && ch != 95;
            }
            case 16: {
                return SRE_STATE.SRE_UNI_IS_LINEBREAK(ch);
            }
            case 17: {
                return !SRE_STATE.SRE_UNI_IS_LINEBREAK(ch);
            }
        }
        return false;
    }

    private void mark_fini() {
        this.mark_stack = null;
        this.mark_stack_base = 0;
        this.mark_stack_size = 0;
    }

    private int mark_save(int lo, int hi) {
        if (hi <= lo) {
            return this.mark_stack_base;
        }
        int newsize = this.mark_stack_size;
        int size = hi - lo + 1;
        int minsize = this.mark_stack_base + size;
        if (newsize < minsize) {
            int[] stack;
            if (newsize == 0) {
                newsize = 512;
                if (512 < minsize) {
                    newsize = minsize;
                }
                this.TRACE(0, this.ptr, "allocate stack " + newsize);
                stack = new int[newsize];
            } else {
                while (newsize < minsize) {
                    newsize += newsize;
                }
                this.TRACE(0, this.ptr, "grow stack to " + newsize);
                stack = new int[newsize];
                System.arraycopy(this.mark_stack, 0, stack, 0, this.mark_stack.length);
            }
            this.mark_stack = stack;
            this.mark_stack_size = newsize;
        }
        this.TRACE(0, this.ptr, "copy " + lo + ":" + hi + " to " + this.mark_stack_base + " (" + size + ")");
        System.arraycopy(this.mark, lo, this.mark_stack, this.mark_stack_base, size);
        this.mark_stack_base += size;
        return this.mark_stack_base;
    }

    private void mark_restore(int lo, int hi, int mark_stack_base) {
        if (hi <= lo) {
            return;
        }
        int size = hi - lo + 1;
        this.mark_stack_base = mark_stack_base - size;
        this.TRACE(0, this.ptr, "copy " + lo + ":" + hi + " from " + mark_stack_base);
        System.arraycopy(this.mark_stack, this.mark_stack_base, this.mark, lo, size);
    }

    private boolean SRE_AT(int ptr, int at) {
        switch (at) {
            case 0: 
            case 2: {
                return ptr == 0;
            }
            case 1: {
                return ptr == 0 || SRE_STATE.SRE_IS_LINEBREAK(this.str[ptr - 1]);
            }
            case 5: {
                return ptr + 1 == this.end && SRE_STATE.SRE_IS_LINEBREAK(this.str[ptr]) || ptr == this.end;
            }
            case 6: {
                return ptr == this.end || SRE_STATE.SRE_IS_LINEBREAK(this.str[ptr]);
            }
            case 7: {
                return ptr == this.end;
            }
            case 3: {
                boolean thatp;
                if (this.end == 0) {
                    return false;
                }
                boolean thisp = ptr < this.end ? SRE_STATE.SRE_IS_WORD(this.str[ptr]) : false;
                return thisp != (thatp = ptr > 0 ? SRE_STATE.SRE_IS_WORD(this.str[ptr - 1]) : false);
            }
            case 4: {
                boolean thatp;
                if (this.end == 0) {
                    return false;
                }
                boolean thisp = ptr < this.end ? SRE_STATE.SRE_IS_WORD(this.str[ptr]) : false;
                return thisp == (thatp = ptr > 0 ? SRE_STATE.SRE_IS_WORD(this.str[ptr - 1]) : false);
            }
            case 8: 
            case 10: {
                boolean thatp;
                if (this.end == 0) {
                    return false;
                }
                boolean thisp = ptr < this.end ? SRE_STATE.SRE_LOC_IS_WORD(this.str[ptr]) : false;
                return thisp != (thatp = ptr > 0 ? SRE_STATE.SRE_LOC_IS_WORD(this.str[ptr - 1]) : false);
            }
            case 9: 
            case 11: {
                boolean thatp;
                if (this.end == 0) {
                    return false;
                }
                boolean thisp = ptr < this.end ? SRE_STATE.SRE_LOC_IS_WORD(this.str[ptr]) : false;
                return thisp == (thatp = ptr > 0 ? SRE_STATE.SRE_LOC_IS_WORD(this.str[ptr - 1]) : false);
            }
        }
        return false;
    }

    private boolean SRE_CHARSET(int[] set, int setidx, int ch) {
        boolean ok = true;
        block9: while (true) {
            switch (set[setidx++]) {
                case 0: {
                    this.TRACE(setidx, ch, "CHARSET FAILURE");
                    return !ok;
                }
                case 19: {
                    this.TRACE(setidx, ch, "CHARSET LITERAL " + set[setidx]);
                    if (ch == set[setidx]) {
                        return ok;
                    }
                    ++setidx;
                    continue block9;
                }
                case 9: {
                    this.TRACE(setidx, ch, "CHARSET CHARSET " + set[setidx]);
                    if (this.sre_category(set[setidx], ch)) {
                        return ok;
                    }
                    ++setidx;
                    continue block9;
                }
                case 10: {
                    this.TRACE(setidx, ch, "CHARSET CHARSET ");
                    if (ch < 256 && (set[setidx + (ch >> 5)] & 1 << (ch & 0x1F)) != 0) {
                        return ok;
                    }
                    setidx += 8;
                    continue block9;
                }
                case 27: {
                    this.TRACE(setidx, ch, "CHARSET RANGE " + set[setidx] + " " + set[setidx + 1]);
                    if (set[setidx] <= ch && ch <= set[setidx + 1]) {
                        return ok;
                    }
                    setidx += 2;
                    continue block9;
                }
                case 26: {
                    this.TRACE(setidx, ch, "CHARSET NEGATE");
                    ok = !ok;
                    continue block9;
                }
                case 11: {
                    this.TRACE(setidx, ch, "CHARSET BIGCHARSET ");
                    int count2 = set[setidx++];
                    int block = ch < 65536 ? set[setidx + ch >> 8] : -1;
                    if (block >= 0 && (set[(setidx += 64) + (block << 3) + ((ch & 0xFF) >> 5)] & 1 << (ch & 0x1F)) != 0) {
                        return ok;
                    }
                    setidx += count2 << 3;
                    continue block9;
                }
            }
            break;
        }
        return false;
    }

    private int SRE_COUNT(int[] pattern, int pidx, int maxcount, int level) {
        int end = this.end;
        int ptr = this.ptr;
        if (maxcount < end - ptr && maxcount != 65535) {
            end = ptr + maxcount;
        }
        switch (pattern[pidx]) {
            case 15: {
                this.TRACE(pidx, ptr, "COUNT IN");
                while (ptr < end && this.SRE_CHARSET(pattern, pidx + 2, this.str[ptr])) {
                    ++ptr;
                }
                break;
            }
            case 2: {
                this.TRACE(pidx, ptr, "COUNT ANY");
                while (ptr < end && !SRE_STATE.SRE_IS_LINEBREAK(this.str[ptr])) {
                    ++ptr;
                }
                break;
            }
            case 3: {
                this.TRACE(pidx, ptr, "COUNT ANY_ALL");
                ptr = end;
                break;
            }
            case 19: {
                int chr = pattern[pidx + 1];
                this.TRACE(pidx, ptr, "COUNT LITERAL " + chr);
                while (ptr < end && this.str[ptr] == chr) {
                    ++ptr;
                }
                break;
            }
            case 20: {
                int chr = pattern[pidx + 1];
                this.TRACE(pidx, ptr, "COUNT LITERAL_IGNORE " + chr);
                while (ptr < end && this.lower(this.str[ptr]) == chr) {
                    ++ptr;
                }
                break;
            }
            case 24: {
                int chr = pattern[pidx + 1];
                this.TRACE(pidx, ptr, "COUNT NOT_LITERAL " + chr);
                while (ptr < end && this.str[ptr] != chr) {
                    ++ptr;
                }
                break;
            }
            case 25: {
                int chr = pattern[pidx + 1];
                this.TRACE(pidx, ptr, "COUNT NOT_LITERAL_IGNORE " + chr);
                while (ptr < end && this.lower(this.str[ptr]) != chr) {
                    ++ptr;
                }
                break;
            }
            default: {
                this.TRACE(pidx, ptr, "COUNT SUBPATTERN");
                while (this.ptr < end) {
                    int i = this.SRE_MATCH(pattern, pidx, level);
                    if (i < 0) {
                        return i;
                    }
                    if (i != 0) continue;
                }
                return this.ptr - ptr;
            }
        }
        return ptr - this.ptr;
    }

    /*
     * Unable to fully structure code
     */
    final int SRE_MATCH(int[] pattern, int pidx, int level) {
        end = this.end;
        ptr = this.ptr;
        mark_stack_base = 0;
        this.TRACE(pidx, ptr, "ENTER " + level);
        if (level > 5000) {
            return -3;
        }
        if (pattern[pidx] == 17) {
            if (pattern[pidx + 3] != 0 && end - ptr < pattern[pidx + 3]) {
                return 0;
            }
            pidx += pattern[pidx + 1] + 1;
        }
        block38: while (true) {
            switch (pattern[pidx++]) {
                case 21: {
                    this.TRACE(pidx, ptr, "MARK " + pattern[pidx]);
                    i = pattern[pidx];
                    if ((i & 1) != 0) {
                        this.lastindex = i / 2 + 1;
                    }
                    if (i > this.lastmark) {
                        this.lastmark = i;
                    }
                    this.mark[i] = ptr;
                    ++pidx;
                    continue block38;
                }
                case 19: {
                    this.TRACE(pidx, ptr, "LITERAL " + pattern[pidx]);
                    if (ptr >= end || this.str[ptr] != pattern[pidx]) {
                        return 0;
                    }
                    ++pidx;
                    ++ptr;
                    continue block38;
                }
                case 24: {
                    this.TRACE(pidx, ptr, "NOT_LITERAL " + pattern[pidx]);
                    if (ptr >= end || this.str[ptr] == pattern[pidx]) {
                        return 0;
                    }
                    ++pidx;
                    ++ptr;
                    continue block38;
                }
                case 1: {
                    this.TRACE(pidx, ptr, "SUCCESS");
                    this.ptr = ptr;
                    return 1;
                }
                case 6: {
                    this.TRACE(pidx, ptr, "AT " + pattern[pidx]);
                    var19_12 = pattern[pidx];
                    var18_11 = ptr;
                    var17_10 = this;
                    switch (var19_12) {
                        case 0: 
                        case 2: {
                            if (var18_11 == 0) {
                                v0 = true;
                                break;
                            }
                            v0 = false;
                            break;
                        }
                        case 1: {
                            if (var18_11 == 0 || SRE_STATE.SRE_IS_LINEBREAK(var17_10.str[var18_11 - 1])) {
                                v0 = true;
                                break;
                            }
                            v0 = false;
                            break;
                        }
                        case 5: {
                            if (var18_11 + 1 == var17_10.end && SRE_STATE.SRE_IS_LINEBREAK(var17_10.str[var18_11]) || var18_11 == var17_10.end) {
                                v0 = true;
                                break;
                            }
                            v0 = false;
                            break;
                        }
                        case 6: {
                            if (var18_11 == var17_10.end || SRE_STATE.SRE_IS_LINEBREAK(var17_10.str[var18_11])) {
                                v0 = true;
                                break;
                            }
                            v0 = false;
                            break;
                        }
                        case 7: {
                            if (var18_11 == var17_10.end) {
                                v0 = true;
                                break;
                            }
                            v0 = false;
                            break;
                        }
                        case 3: {
                            if (var17_10.end != 0) {
                                var21_14 = var18_11 < var17_10.end ? SRE_STATE.SRE_IS_WORD(var17_10.str[var18_11]) : false;
                                if (var21_14 != (var20_13 = var18_11 > 0 ? SRE_STATE.SRE_IS_WORD(var17_10.str[var18_11 - 1]) : false)) {
                                    v0 = true;
                                    break;
                                }
                                v0 = false;
                                break;
                            }
                            ** GOTO lbl112
                        }
                        case 4: {
                            if (var17_10.end != 0) {
                                var21_14 = var18_11 < var17_10.end ? SRE_STATE.SRE_IS_WORD(var17_10.str[var18_11]) : false;
                                if (var21_14 == (var20_13 = var18_11 > 0 ? SRE_STATE.SRE_IS_WORD(var17_10.str[var18_11 - 1]) : false)) {
                                    v0 = true;
                                    break;
                                }
                                v0 = false;
                                break;
                            }
                            ** GOTO lbl112
                        }
                        case 8: 
                        case 10: {
                            if (var17_10.end != 0) {
                                var21_14 = var18_11 < var17_10.end ? SRE_STATE.SRE_LOC_IS_WORD(var17_10.str[var18_11]) : false;
                                if (var21_14 != (var20_13 = var18_11 > 0 ? SRE_STATE.SRE_LOC_IS_WORD(var17_10.str[var18_11 - 1]) : false)) {
                                    v0 = true;
                                    break;
                                }
                                v0 = false;
                                break;
                            }
                            ** GOTO lbl112
                        }
                        case 9: 
                        case 11: {
                            if (var17_10.end != 0) {
                                var21_14 = var18_11 < var17_10.end ? SRE_STATE.SRE_LOC_IS_WORD(var17_10.str[var18_11]) : false;
                                if (var21_14 == (var20_13 = var18_11 > 0 ? SRE_STATE.SRE_LOC_IS_WORD(var17_10.str[var18_11 - 1]) : false)) {
                                    v0 = true;
                                    break;
                                }
                                v0 = false;
                                break;
                            }
                        }
lbl112:
                        // 6 sources

                        default: {
                            v0 = false;
                        }
                    }
                    if (!v0) {
                        return 0;
                    }
                    ++pidx;
                    continue block38;
                }
                case 9: {
                    this.TRACE(pidx, ptr, "CATEGORY " + pattern[pidx]);
                    if (ptr >= end || !this.sre_category(pattern[pidx], this.str[ptr])) {
                        return 0;
                    }
                    ++pidx;
                    ++ptr;
                    continue block38;
                }
                case 2: {
                    this.TRACE(pidx, ptr, "ANY");
                    if (ptr >= end || SRE_STATE.SRE_IS_LINEBREAK(this.str[ptr])) {
                        return 0;
                    }
                    ++ptr;
                    continue block38;
                }
                case 3: {
                    this.TRACE(pidx, ptr, "ANY_ALL");
                    if (ptr >= end) {
                        return 0;
                    }
                    ++ptr;
                    continue block38;
                }
                case 15: {
                    this.TRACE(pidx, ptr, "IN");
                    if (ptr >= end || !this.SRE_CHARSET(pattern, pidx + 1, this.str[ptr])) {
                        return 0;
                    }
                    pidx += pattern[pidx];
                    ++ptr;
                    continue block38;
                }
                case 20: {
                    this.TRACE(pidx, ptr, "LITERAL_IGNORE " + pattern[pidx]);
                    if (ptr >= end || this.lower(this.str[ptr]) != this.lower(pattern[pidx])) {
                        return 0;
                    }
                    ++pidx;
                    ++ptr;
                    continue block38;
                }
                case 25: {
                    this.TRACE(pidx, ptr, "NOT_LITERAL_IGNORE " + pattern[pidx]);
                    if (ptr >= end || this.lower(this.str[ptr]) == this.lower(pattern[pidx])) {
                        return 0;
                    }
                    ++pidx;
                    ++ptr;
                    continue block38;
                }
                case 16: {
                    this.TRACE(pidx, ptr, "IN_IGNORE");
                    if (ptr >= end || !this.SRE_CHARSET(pattern, pidx + 1, this.lower(this.str[ptr]))) {
                        return 0;
                    }
                    pidx += pattern[pidx];
                    ++ptr;
                    continue block38;
                }
                case 17: 
                case 18: {
                    this.TRACE(pidx, ptr, "JUMP " + pattern[pidx]);
                    pidx += pattern[pidx];
                    continue block38;
                }
                case 7: {
                    lastmark = this.lastmark;
                    lastindex = this.lastindex;
                    if (this.repeat != null) {
                        mark_stack_base = this.mark_save(0, lastmark);
                    }
                    while (pattern[pidx] != 0) {
                        if ((pattern[pidx + 1] != 19 || ptr < end && this.str[ptr] == pattern[pidx + 2]) && (pattern[pidx + 1] != 15 || ptr < end && this.SRE_CHARSET(pattern, pidx + 3, this.str[ptr]))) {
                            this.ptr = ptr;
                            i = this.SRE_MATCH(pattern, pidx + 1, level + 1);
                            if (i != 0) {
                                return i;
                            }
                            if (this.repeat != null) {
                                this.mark_restore(0, lastmark, mark_stack_base);
                            }
                            this.LASTMARK_RESTORE(lastmark, lastindex);
                        }
                        pidx += pattern[pidx];
                    }
                    return 0;
                }
                case 29: {
                    mincount = pattern[pidx + 1];
                    this.TRACE(pidx, ptr, "REPEAT_ONE " + mincount + " " + pattern[pidx + 2]);
                    if (ptr + mincount > end) {
                        return 0;
                    }
                    this.ptr = ptr;
                    count = this.SRE_COUNT(pattern, pidx + 3, pattern[pidx + 2], level + 1);
                    if (count < 0) {
                        return count;
                    }
                    ptr += count;
                    if (count < mincount) {
                        return 0;
                    }
                    if (pattern[pidx + pattern[pidx]] == 1) {
                        this.ptr = ptr;
                        return 1;
                    }
                    lastmark = this.lastmark;
                    lastindex = this.lastindex;
                    if (pattern[pidx + pattern[pidx]] == 19) {
                        chr = pattern[pidx + pattern[pidx] + 1];
                        while (true) {
                            if (count >= mincount && (ptr >= end || this.str[ptr] != chr)) {
                                --ptr;
                                --count;
                                continue;
                            }
                            if (count >= mincount) {
                                this.ptr = ptr--;
                                i = this.SRE_MATCH(pattern, pidx + pattern[pidx], level + 1);
                                if (i != 0) {
                                    return 1;
                                }
                                --count;
                                this.LASTMARK_RESTORE(lastmark, lastindex);
                                continue;
                            }
                            break;
                        }
                    } else {
                        lastmark = this.lastmark;
                        while (count >= mincount) {
                            this.ptr = ptr--;
                            i = this.SRE_MATCH(pattern, pidx + pattern[pidx], level + 1);
                            if (i != 0) {
                                return i;
                            }
                            --count;
                            this.LASTMARK_RESTORE(lastmark, lastindex);
                        }
                    }
                    return 0;
                }
                case 31: {
                    this.TRACE(pidx, ptr, "MIN_REPEAT_ONE");
                    if (ptr + pattern[pidx + 1] > end) {
                        return 0;
                    }
                    this.ptr = ptr;
                    if (pattern[pidx + 1] == 0) {
                        count = 0;
                    } else {
                        count = this.SRE_COUNT(pattern, pidx + 3, pattern[pidx + 1], level + 1);
                        if (count < 0) {
                            return count;
                        }
                        if (count < pattern[pidx + 1]) {
                            return 0;
                        }
                        ptr += count;
                    }
                    if (pattern[pidx + pattern[pidx]] == 1) {
                        this.ptr = ptr;
                        return 1;
                    }
                    matchmax = pattern[pidx + 2] == 65535;
                    lastmark = this.lastmark;
                    lastindex = this.lastindex;
                    while (matchmax || count <= pattern[pidx + 2]) {
                        this.ptr = ptr;
                        i = this.SRE_MATCH(pattern, pidx + pattern[pidx], level + 1);
                        if (i != 0) {
                            return i;
                        }
                        this.ptr = ptr++;
                        c = this.SRE_COUNT(pattern, pidx + 3, 1, level + 1);
                        if (c < 0) {
                            return c;
                        }
                        if (c == 0) break;
                        if (c != 1) {
                            throw new IllegalStateException("c should be 1!");
                        }
                        ++count;
                        this.LASTMARK_RESTORE(lastmark, lastindex);
                    }
                    return 0;
                }
                case 28: {
                    this.TRACE(pidx, ptr, "REPEAT " + pattern[pidx + 1] + " " + pattern[pidx + 2]);
                    rep = new SRE_REPEAT(this.repeat);
                    new SRE_REPEAT(this.repeat).count = -1;
                    rep.pidx = pidx;
                    this.repeat = rep;
                    this.ptr = ptr;
                    i = this.SRE_MATCH(pattern, pidx + pattern[pidx], level + 1);
                    this.repeat = rep.prev;
                    return i;
                }
                case 22: {
                    rp = this.repeat;
                    if (rp == null) {
                        return -2;
                    }
                    this.ptr = ptr;
                    count = rp.count + 1;
                    this.TRACE(pidx, ptr, "MAX_UNTIL " + count);
                    if (count < pattern[rp.pidx + 1]) {
                        rp.count = count;
                        i = this.SRE_MATCH(pattern, rp.pidx + 3, level + 1);
                        if (i != 0) {
                            return i;
                        }
                        rp.count = count - 1;
                        this.ptr = ptr;
                        return 0;
                    }
                    if (count < pattern[rp.pidx + 2] || pattern[rp.pidx + 2] == 65535) {
                        rp.count = count;
                        lastmark = this.lastmark;
                        lastindex = this.lastindex;
                        mark_stack_base = this.mark_save(0, lastmark);
                        i = this.SRE_MATCH(pattern, rp.pidx + 3, level + 1);
                        if (i != 0) {
                            return i;
                        }
                        this.mark_restore(0, lastmark, mark_stack_base);
                        this.LASTMARK_RESTORE(lastmark, lastindex);
                        rp.count = count - 1;
                        this.ptr = ptr;
                    }
                    this.repeat = rp.prev;
                    i = this.SRE_MATCH(pattern, pidx, level + 1);
                    if (i != 0) {
                        return i;
                    }
                    this.repeat = rp;
                    this.ptr = ptr;
                    return 0;
                }
                case 23: {
                    rp = this.repeat;
                    if (rp == null) {
                        return -2;
                    }
                    this.ptr = ptr;
                    count = rp.count + 1;
                    this.TRACE(pidx, ptr, "MIN_UNTIL " + count + " " + rp.pidx);
                    if (count < pattern[rp.pidx + 1]) {
                        rp.count = count;
                        i = this.SRE_MATCH(pattern, rp.pidx + 3, level + 1);
                        if (i != 0) {
                            return i;
                        }
                        rp.count = count - 1;
                        this.ptr = ptr;
                        return 0;
                    }
                    lastmark = this.lastmark;
                    lastindex = this.lastindex;
                    this.repeat = rp.prev;
                    i = this.SRE_MATCH(pattern, pidx, level + 1);
                    if (i != 0) {
                        return i;
                    }
                    this.ptr = ptr;
                    this.repeat = rp;
                    if (count >= pattern[rp.pidx + 2] && pattern[rp.pidx + 2] != 65535) {
                        return 0;
                    }
                    this.LASTMARK_RESTORE(lastmark, lastindex);
                    rp.count = count;
                    i = this.SRE_MATCH(pattern, rp.pidx + 3, level + 1);
                    if (i != 0) {
                        return i;
                    }
                    rp.count = count - 1;
                    this.ptr = ptr;
                    return 0;
                }
                case 12: {
                    i = pattern[pidx];
                    this.TRACE(pidx, ptr, "GROUPREF " + i);
                    p = this.mark[i + i];
                    e = this.mark[i + i + 1];
                    if (p == -1 || e == -1 || e < p) {
                        return 0;
                    }
                    while (p < e) {
                        if (ptr >= end || this.str[ptr] != this.str[p]) {
                            return 0;
                        }
                        ++p;
                        ++ptr;
                    }
                    ++pidx;
                    continue block38;
                }
                case 14: {
                    i = pattern[pidx];
                    this.TRACE(pidx, ptr, "GROUPREF_IGNORE " + i);
                    p = this.mark[i + i];
                    e = this.mark[i + i + 1];
                    if (p == -1 || e == -1 || e < p) {
                        return 0;
                    }
                    while (p < e) {
                        if (ptr >= end || this.lower(this.str[ptr]) != this.lower(this.str[p])) {
                            return 0;
                        }
                        ++p;
                        ++ptr;
                    }
                    ++pidx;
                    continue block38;
                }
                case 13: {
                    i = pattern[pidx];
                    this.TRACE(pidx, ptr, "GROUPREF_EXISTS " + i);
                    p = this.mark[i + i];
                    e = this.mark[i + i + 1];
                    if (p == -1 || e == -1 || e < p) {
                        pidx += pattern[pidx + 1];
                        continue block38;
                    }
                    pidx += 2;
                    continue block38;
                }
                case 4: {
                    this.TRACE(pidx, ptr, "ASSERT " + pattern[pidx + 1]);
                    this.ptr = ptr - pattern[pidx + 1];
                    if (this.ptr < 0) {
                        return 0;
                    }
                    i = this.SRE_MATCH(pattern, pidx + 2, level + 1);
                    if (i <= 0) {
                        return i;
                    }
                    pidx += pattern[pidx];
                    continue block38;
                }
                case 5: {
                    this.TRACE(pidx, ptr, "ASSERT_NOT " + pattern[pidx]);
                    this.ptr = ptr - pattern[pidx + 1];
                    if (this.ptr >= 0) {
                        i = this.SRE_MATCH(pattern, pidx + 2, level + 1);
                        if (i < 0) {
                            return i;
                        }
                        if (i != 0) {
                            return 0;
                        }
                    }
                    pidx += pattern[pidx];
                    continue block38;
                }
                case 0: {
                    this.TRACE(pidx, ptr, "FAILURE");
                    return 0;
                }
            }
            break;
        }
        this.TRACE(pidx, ptr, "UNKNOWN " + pattern[pidx - 1]);
        return -1;
    }

    private void LASTMARK_RESTORE(int lastmark, int lastindex) {
        if (this.lastmark > lastmark) {
            while (this.lastmark > lastmark) {
                this.mark[this.lastmark--] = -1;
            }
            this.lastindex = lastindex;
        }
    }

    final int SRE_SEARCH(int[] pattern, int pidx) {
        int ptr = this.start;
        int end = this.end;
        int status = 0;
        int prefix_len = 0;
        int prefix_skip = 0;
        int prefix = 0;
        int charset = 0;
        int overlap = 0;
        int flags = 0;
        if (pattern[0] == 17) {
            flags = pattern[2];
            if (pattern[3] > 1 && (end -= pattern[3] - 1) <= ptr) {
                end = ptr;
            }
            if ((flags & 1) != 0) {
                prefix_len = pattern[5];
                prefix_skip = pattern[6];
                prefix = 7;
                overlap = prefix_len + 7 - 1;
            } else if ((flags & 4) != 0) {
                charset = 5;
            }
            pidx = 0 + (1 + pattern[1]);
        }
        if (prefix_len > 1) {
            int i = 0;
            end = this.end;
            while (ptr < end) {
                block25: {
                    while (this.str[ptr] != pattern[prefix + i]) {
                        if (i != 0) {
                            i = pattern[overlap + i];
                            continue;
                        }
                        break block25;
                    }
                    if (++i == prefix_len) {
                        this.TRACE(pidx, ptr, "SEARCH SCAN " + prefix_skip + " " + prefix_len);
                        this.start = ptr + 1 - prefix_len;
                        this.ptr = ptr + 1 - prefix_len + prefix_skip;
                        if ((flags & 2) != 0) {
                            return 1;
                        }
                        status = this.SRE_MATCH(pattern, pidx + 2 * prefix_skip, 1);
                        if (status != 0) {
                            return status;
                        }
                        i = pattern[overlap + i];
                    }
                }
                ++ptr;
            }
            return 0;
        }
        if (pattern[pidx] == 19) {
            int chr = pattern[pidx + 1];
            end = this.end;
            while (true) {
                if (ptr < end && this.str[ptr] != chr) {
                    ++ptr;
                    continue;
                }
                if (ptr == end) {
                    return 0;
                }
                this.TRACE(pidx, ptr, "SEARCH LITERAL");
                this.start = ptr++;
                this.ptr = ptr;
                if ((flags & 2) != 0) {
                    return 1;
                }
                status = this.SRE_MATCH(pattern, pidx + 2, 1);
                if (status != 0) break;
            }
        } else if (charset != 0) {
            end = this.end;
            while (true) {
                if (ptr < end && !this.SRE_CHARSET(pattern, charset, this.str[ptr])) {
                    ++ptr;
                    continue;
                }
                if (ptr == end) {
                    return 0;
                }
                this.TRACE(pidx, ptr, "SEARCH CHARSET");
                this.start = ptr;
                this.ptr = ptr++;
                status = this.SRE_MATCH(pattern, pidx, 1);
                if (status == 0) {
                    continue;
                }
                break;
            }
        } else {
            while (ptr <= end) {
                this.TRACE(pidx, ptr, "SEARCH");
                this.ptr = ptr++;
                this.start = this.ptr;
                status = this.SRE_MATCH(pattern, pidx, 1);
                if (status == 0) continue;
            }
        }
        return status;
    }

    public SRE_STATE(PyString str, int start, int end, int flags) {
        this.str = CACHE.INSTANCE.get(str);
        int size = str.__len__();
        if (start < 0) {
            start = 0;
        } else if (start > size) {
            start = size;
        }
        if (end < 0) {
            end = 0;
        } else if (end > size) {
            end = size;
        }
        this.start = start;
        this.end = end;
        this.pos = start;
        this.endpos = end;
        this.state_reset();
        this.flags = flags;
    }

    public static int getlower(int ch, int flags) {
        if ((flags & 4) != 0) {
            if (ch < 256) {
                return Character.toLowerCase((char)ch);
            }
            return ch;
        }
        if ((flags & 0x20) != 0) {
            return Character.toLowerCase((char)ch);
        }
        if (ch < 128) {
            return (char)sre_char_lower[ch];
        }
        return ch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final String getslice(int index, String string, boolean empty) {
        int i;
        int j;
        index = index - 1 << 1;
        if (string == null || this.mark[index] == -1 || this.mark[index + 1] == -1) {
            if (!empty) return null;
            j = 0;
            i = 0;
            return string.substring(i, j);
        } else {
            i = this.mark[index];
            j = this.mark[index + 1];
        }
        return string.substring(i, j);
    }

    final void state_reset() {
        this.lastmark = 0;
        for (int i = 0; i < this.mark.length; ++i) {
            this.mark[i] = -1;
        }
        this.lastindex = -1;
        this.repeat = null;
        this.mark_fini();
    }

    private void TRACE(int pidx, int ptr, String string) {
    }

    static enum CACHE {
        INSTANCE(Options.sreCacheSpec);

        private LoadingCache<PyString, int[]> cache;

        private CACHE(String spec) {
            CacheBuilder<Object, Object> builder;
            CacheLoader<PyString, int[]> loader = new CacheLoader<PyString, int[]>(this){
                private /* synthetic */ CACHE this$0;

                @Override
                public int[] load(PyString key) {
                    return key.toCodePoints();
                }
            };
            try {
                builder = CacheBuilder.from(spec);
            }
            catch (IllegalArgumentException iae) {
                Py.writeWarning("re", String.format("Incompatible options in python.sre.cachespec '%s' due to: %s", spec, iae.getMessage()));
                Py.writeMessage("re", String.format("Defaulting python.sre.cachespec to '%s'", "weakKeys,concurrencyLevel=4,maximumWeight=2621440,expireAfterAccess=30s"));
                builder = CacheBuilder.from("weakKeys,concurrencyLevel=4,maximumWeight=2621440,expireAfterAccess=30s");
            }
            if (spec.contains("maximumWeight")) {
                this.cache = builder.weigher(new Weigher<PyString, int[]>(this){
                    private /* synthetic */ CACHE this$0;

                    @Override
                    public int weigh(PyString k, int[] v) {
                        return v.length;
                    }
                }).build(loader);
                return;
            }
            this.cache = builder.build(loader);
        }

        private int[] get(PyString str) {
            return (int[])this.cache.getUnchecked(str);
        }
    }
}

