/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public class NBlock
extends NNode {
    public List<NNode> seq;

    public NBlock(List<NNode> seq) {
        this(seq, 0, 1);
    }

    public NBlock(List<NNode> seq, int start, int end) {
        super(0, end);
        if (seq == null) {
            seq = new ArrayList<NNode>();
        }
        this.seq = seq;
        this.addChildren(seq);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        for (NNode n : this.seq) {
            NType returnType = NBlock.resolveExpr(n, scope);
            if (returnType == Indexer.idx.builtins.None) continue;
            this.setType(returnType);
        }
        return this.getType();
    }

    public String toString() {
        return "<Block:" + this.seq + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NBlock.visitNodeList(this.seq, v);
        }
    }
}

