/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public final class NAttribute
extends NNode {
    public NNode target;
    public NName attr;

    public NAttribute(NNode target, NName attr) {
        this(target, attr, 0, 1);
    }

    public NAttribute(NNode target, NName attr, int start, int end) {
        super(start, end);
        NNode nNode = target;
        NAttribute nAttribute = this;
        if (nNode == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        nAttribute.target = nNode;
        nNode = attr;
        nAttribute = this;
        if (nNode == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        nAttribute.attr = nNode;
        this.addChildren(target, attr);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType targetType;
        this.setType(new NUnknownType());
        NType nType = targetType = NAttribute.resolveExpr(this.target, s);
        if (targetType instanceof NUnionType) {
            NType ret = new NUnknownType();
            nType = targetType;
            for (NType tp : ((NUnionType)nType).getTypes()) {
                this.resolveAttributeOnType(tp);
                ret = NUnionType.union(ret, this.getType());
            }
            nType = ret;
            this.setType(this.attr.setType(NUnknownType.follow(nType)));
        } else {
            this.resolveAttributeOnType(targetType);
        }
        return this.getType();
    }

    private void resolveAttributeOnType(NType targetType) {
        NType nType = targetType;
        NType ttype = NUnknownType.follow(nType);
        NBinding b = ttype.getTable().lookupAttr(this.attr.id);
        if (b == null) {
            NBinding nBinding;
            NType nType2 = ttype;
            NAttribute nAttribute = this;
            NType nType3 = nType2;
            if (Indexer.idx.builtins.isNative(nType3)) {
                nBinding = null;
            } else {
                Scope scope = nType2.getTable();
                if ("".equals(scope.getPath())) {
                    nBinding = null;
                } else {
                    NUnknownType nUnknownType = new NUnknownType();
                    NBinding nBinding2 = scope.putAttr(nAttribute.attr.id, null, nUnknownType, NBinding.Kind.ATTRIBUTE);
                    if (nBinding2 != null) {
                        nBinding2.setProvisional(true);
                        nUnknownType.getTable().setPath(nBinding2.getQname());
                    }
                    nBinding = b = nBinding2;
                }
            }
        }
        if (b != null) {
            Indexer.idx.putLocation(this.attr, b);
            this.setType(this.attr.setType(b.getType()));
        }
    }

    public final String toString() {
        NAttribute nAttribute = this;
        return "<Attribute:" + this.start() + ":" + this.target + "." + nAttribute.attr.id + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NAttribute.visitNode(this.target, v);
            NAttribute.visitNode(this.attr, v);
        }
    }
}

