/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import junit.framework.TestCase;
import org.python.core.PyInteger;
import org.python.core.PyString;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.InternalFormatSpec;
import org.python.core.stringlib.InternalFormatSpecParser;
import org.python.core.stringlib.MarkupIterator;

public class StringFormatTest
extends TestCase {
    public void testInternalFormatSpec() {
        InternalFormatSpec spec = new InternalFormatSpecParser("x").parse();
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = new InternalFormatSpecParser("<x").parse();
        StringFormatTest.assertEquals((char)'<', (char)spec.align);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = new InternalFormatSpecParser("~<x").parse();
        StringFormatTest.assertEquals((char)'~', (char)spec.fill_char);
        StringFormatTest.assertEquals((char)'<', (char)spec.align);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = new InternalFormatSpecParser("+x").parse();
        StringFormatTest.assertEquals((char)'+', (char)spec.sign);
        StringFormatTest.assertEquals((char)'x', (char)spec.type);
        spec = new InternalFormatSpecParser("#x").parse();
        StringFormatTest.assertEquals((boolean)true, (boolean)spec.alternate);
        spec = new InternalFormatSpecParser("0x").parse();
        StringFormatTest.assertEquals((char)'=', (char)spec.align);
        StringFormatTest.assertEquals((char)'0', (char)spec.fill_char);
        spec = new InternalFormatSpecParser("123x").parse();
        StringFormatTest.assertEquals((int)123, (int)spec.width);
        spec = new InternalFormatSpecParser("123.456x").parse();
        StringFormatTest.assertEquals((int)123, (int)spec.width);
        StringFormatTest.assertEquals((int)456, (int)spec.precision);
        this.assertParseError("123.x", "Format specifier missing precision");
        this.assertParseError("123xx", "Invalid conversion specification");
        spec = new InternalFormatSpecParser("").parse();
        StringFormatTest.assertEquals((int)0, (int)spec.type);
    }

    private void assertParseError(String spec, String expected) {
        String error = null;
        try {
            new InternalFormatSpecParser(spec).parse();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException e = illegalArgumentException;
            error = illegalArgumentException.getMessage();
        }
        StringFormatTest.assertEquals((String)expected, (String)error);
    }

    public void testFormatIntOrLong() {
        InternalFormatSpec spec = new InternalFormatSpec();
        new InternalFormatSpec().type = (char)100;
        StringFormatTest.assertEquals((String)"123", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)111;
        StringFormatTest.assertEquals((String)"173", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)120;
        StringFormatTest.assertEquals((String)"7b", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)88;
        StringFormatTest.assertEquals((String)"7B", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)98;
        StringFormatTest.assertEquals((String)"1111011", (String)PyInteger.formatIntOrLong(123, spec));
        spec.thousands_separators = true;
        spec.type = (char)100;
        StringFormatTest.assertEquals((String)"1,234", (String)PyInteger.formatIntOrLong(1234, spec));
        spec.thousands_separators = false;
        spec.alternate = true;
        spec.type = (char)111;
        StringFormatTest.assertEquals((String)"0o173", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)88;
        StringFormatTest.assertEquals((String)"0X7B", (String)PyInteger.formatIntOrLong(123, spec));
        spec.alternate = false;
        spec.type = (char)99;
        StringFormatTest.assertEquals((String)"{", (String)PyInteger.formatIntOrLong(123, spec));
        spec.type = (char)100;
        spec.sign = (char)43;
        StringFormatTest.assertEquals((String)"+123", (String)PyInteger.formatIntOrLong(123, spec));
        spec.sign = (char)32;
        StringFormatTest.assertEquals((String)" 123", (String)PyInteger.formatIntOrLong(123, spec));
        spec.sign = '\u0000';
        spec.width = 5;
        StringFormatTest.assertEquals((String)"  123", (String)PyInteger.formatIntOrLong(123, spec));
        spec.align = (char)94;
        spec.width = 6;
        StringFormatTest.assertEquals((String)" 123  ", (String)PyInteger.formatIntOrLong(123, spec));
        spec.align = (char)60;
        spec.width = 5;
        spec.fill_char = (char)126;
        StringFormatTest.assertEquals((String)"123~~", (String)PyInteger.formatIntOrLong(123, spec));
        spec.align = (char)61;
        spec.width = 6;
        spec.fill_char = (char)48;
        spec.sign = (char)43;
        StringFormatTest.assertEquals((String)"+00123", (String)PyInteger.formatIntOrLong(123, spec));
        spec.precision = 1;
        this.assertFormatError(123, spec, "Precision not allowed in integer format specifier");
        spec.precision = -1;
        spec.sign = (char)43;
        spec.type = (char)99;
        this.assertFormatError(123, spec, "Sign not allowed with integer format specifier 'c'");
        spec.sign = '\u0000';
        this.assertFormatError(69905, spec, "%c arg not in range(0x10000)");
    }

    public void testFormatString() {
        InternalFormatSpec spec = new InternalFormatSpec();
        StringFormatTest.assertEquals((String)"abc", (String)PyString.formatString("abc", spec));
        spec.precision = 3;
        StringFormatTest.assertEquals((String)"abc", (String)PyString.formatString("abcdef", spec));
        spec.precision = -1;
        spec.width = 6;
        StringFormatTest.assertEquals((String)"abc   ", (String)PyString.formatString("abc", spec));
    }

    private void assertFormatError(int value, InternalFormatSpec spec, String expected) {
        String error = null;
        try {
            PyInteger.formatIntOrLong(value, spec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException e = illegalArgumentException;
            error = illegalArgumentException.getMessage();
        }
        StringFormatTest.assertEquals((String)expected, (String)error);
    }

    public void testMarkupIterator() {
        MarkupIterator iterator = new MarkupIterator("abc");
        StringFormatTest.assertEquals((String)"abc", (String)iterator.nextChunk().literalText);
        StringFormatTest.assertNull((Object)iterator.nextChunk());
        iterator = new MarkupIterator("First, thou shalt count to {0}");
        MarkupIterator.Chunk chunk = iterator.nextChunk();
        StringFormatTest.assertEquals((String)"First, thou shalt count to ", (String)chunk.literalText);
        StringFormatTest.assertEquals((String)"0", (String)chunk.fieldName);
        StringFormatTest.assertNull((Object)iterator.nextChunk());
        iterator = new MarkupIterator("Weight in tons {0.weight!r:s}");
        chunk = iterator.nextChunk();
        StringFormatTest.assertEquals((String)"Weight in tons ", (String)chunk.literalText);
        StringFormatTest.assertEquals((String)"0.weight", (String)chunk.fieldName);
        StringFormatTest.assertEquals((String)"r", (String)chunk.conversion);
        StringFormatTest.assertEquals((String)"s", (String)chunk.formatSpec);
        chunk = new MarkupIterator("{{").nextChunk();
        StringFormatTest.assertEquals((String)"{", (String)chunk.literalText);
        chunk = new MarkupIterator("}}").nextChunk();
        StringFormatTest.assertEquals((String)"}", (String)chunk.literalText);
        chunk = new MarkupIterator("{{}}").nextChunk();
        StringFormatTest.assertEquals((String)"{}", (String)chunk.literalText);
        chunk = new MarkupIterator("{0:.{1}}").nextChunk();
        StringFormatTest.assertEquals((String)"0", (String)chunk.fieldName);
        StringFormatTest.assertEquals((String)".{1}", (String)chunk.formatSpec);
        StringFormatTest.assertTrue((boolean)chunk.formatSpecNeedsExpanding);
        this.assertMarkupError("{!}", "end of format while looking for conversion specifier");
        this.assertMarkupError("{!rrrr}", "expected ':' after conversion specifier");
        this.assertMarkupError("{", "Single '{' encountered in format string");
        this.assertMarkupError("}", "Single '}' encountered in format string");
    }

    private void assertMarkupError(String markup, String expected) {
        MarkupIterator iterator = new MarkupIterator(markup);
        String error = null;
        try {
            iterator.nextChunk();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException e = illegalArgumentException;
            error = illegalArgumentException.getMessage();
        }
        StringFormatTest.assertEquals((String)expected, (String)error);
    }

    public void testFieldNameIterator() {
        FieldNameIterator it = new FieldNameIterator("abc");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = new FieldNameIterator("3");
        StringFormatTest.assertEquals((Object)3, (Object)it.head());
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = new FieldNameIterator("abc[0]");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        FieldNameIterator.Chunk chunk = it.nextChunk();
        StringFormatTest.assertEquals((Object)0, (Object)chunk.value);
        StringFormatTest.assertFalse((boolean)chunk.is_attr);
        StringFormatTest.assertNull((Object)it.nextChunk());
        it = new FieldNameIterator("abc.def");
        StringFormatTest.assertEquals((Object)"abc", (Object)it.head());
        chunk = it.nextChunk();
        StringFormatTest.assertEquals((Object)"def", (Object)chunk.value);
        StringFormatTest.assertTrue((boolean)chunk.is_attr);
        StringFormatTest.assertNull((Object)it.nextChunk());
    }
}

