/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.util.Map;
import jnr.ffi.InvalidProvider;
import jnr.ffi.LibraryOption;
import jnr.ffi.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FFIProvider {
    static final FFIProvider getSystemProvider() {
        return SystemProviderSingletonHolder.INSTANCE;
    }

    protected FFIProvider() {
    }

    public abstract Runtime getRuntime();

    public abstract <T> T loadLibrary(String var1, Class<T> var2, Map<LibraryOption, ?> var3);

    public abstract <T> T loadLibrary(Class<T> var1, Map<LibraryOption, ?> var2, String ... var3);

    private static FFIProvider newInvalidProvider(String message, Throwable cause) {
        return new InvalidProvider(message, cause);
    }

    static final class SystemProviderSingletonHolder {
        private static final FFIProvider INSTANCE = SystemProviderSingletonHolder.getInstance();

        private SystemProviderSingletonHolder() {
        }

        private static FFIProvider getInstance() {
            String providerName = System.getProperty("jnr.ffi.provider");
            if (providerName == null) {
                Package pkg = FFIProvider.class.getPackage();
                String pkgName = pkg != null && pkg.getName() != null ? pkg.getName() : "jnr.ffi";
                providerName = pkgName + ".provider.jffi.Provider";
            }
            try {
                return (FFIProvider)Class.forName(providerName).newInstance();
            }
            catch (Throwable ex) {
                return FFIProvider.newInvalidProvider("could not load FFI provider " + providerName, ex);
            }
        }
    }
}

