/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.distribution;

import java.io.Serializable;
import java.util.regex.Pattern;
import net.grinder.console.distribution.CacheParameters;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.util.Directory;

final class CacheParametersImplementation
implements CacheParameters,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Directory m_directory;
    private final Pattern m_fileFilterPattern;

    public CacheParametersImplementation(Directory directory, Pattern fileFilterPattern) {
        this.m_directory = directory;
        this.m_fileFilterPattern = fileFilterPattern;
    }

    public Directory getDirectory() {
        return this.m_directory;
    }

    public Pattern getFileFilterPattern() {
        return this.m_fileFilterPattern;
    }

    public CacheHighWaterMark createHighWaterMark(long time) {
        return new CacheHighWaterMarkImplementation(this, time);
    }

    public int hashCode() {
        return this.m_directory.hashCode() ^ this.m_fileFilterPattern.pattern().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheParametersImplementation other = (CacheParametersImplementation)o;
        return this.m_directory.equals(other.m_directory) && this.m_fileFilterPattern.pattern().equals(other.m_fileFilterPattern.pattern());
    }

    private static final class CacheHighWaterMarkImplementation
    implements CacheHighWaterMark {
        private static final long serialVersionUID = 1L;
        private final CacheParameters m_cacheParameters;
        private final long m_time;

        public CacheHighWaterMarkImplementation(CacheParameters cacheParameters, long time) {
            this.m_cacheParameters = cacheParameters;
            this.m_time = time;
        }

        public boolean isForSameCache(CacheHighWaterMark other) {
            if (!(other instanceof CacheHighWaterMarkImplementation)) {
                return false;
            }
            CacheHighWaterMarkImplementation otherHighWater = (CacheHighWaterMarkImplementation)other;
            return this.m_cacheParameters.equals(otherHighWater.m_cacheParameters);
        }

        public long getTime() {
            return this.m_time;
        }
    }
}

