/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Builtins;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NFunctionDef
extends NNode {
    private NName name;
    public List<NNode> args;
    public List<NNode> defaults;
    public NName varargs;
    public NName kwargs;
    public NNode body;
    private List<NNode> decoratorList;

    public NFunctionDef(NName name, List<NNode> args, NBlock body, List<NNode> defaults, NName varargs, NName kwargs) {
        this(null, null, null, null, null, null, 0, 1);
    }

    public NFunctionDef(NName name, List<NNode> args, NBlock body, List<NNode> defaults, NName varargs, NName kwargs, int start, int end) {
        super(start, end);
        this.name = name;
        this.args = args;
        this.body = body != null ? new NBody(body) : new NBlock(null);
        this.defaults = defaults;
        this.varargs = varargs;
        this.kwargs = kwargs;
        this.addChildren(name);
        this.addChildren(args);
        this.addChildren(defaults);
        this.addChildren(varargs, kwargs, this.body);
    }

    public final void setDecoratorList(List<NNode> decoratorList) {
        this.decoratorList = decoratorList;
        this.addChildren(decoratorList);
    }

    public final List<NNode> getDecoratorList() {
        if (this.decoratorList == null) {
            this.decoratorList = new ArrayList<NNode>();
        }
        return this.decoratorList;
    }

    @Override
    public final boolean isFunctionDef() {
        return true;
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    protected String getBindingName(Scope s) {
        return this.name.id;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        NType nType;
        Scope owner = s.getScopeSymtab();
        this.setType(new NFuncType());
        Scope funcTable = new Scope(s.getEnclosingLexicalScope(), Scope.Type.FUNCTION);
        this.getType().setTable(funcTable);
        funcTable.setPath(owner.extendPath(this.getBindingName(owner)));
        NType existing = owner.lookupType(this.getBindingName(owner), true);
        if (existing != null && (nType = existing) instanceof NFuncType) {
            return;
        }
        this.bindFunctionName(owner);
        Scope scope = funcTable;
        NFunctionDef nFunctionDef = this;
        NameBinder nameBinder = NameBinder.make(NBinding.Kind.PARAMETER);
        for (NNode nNode : nFunctionDef.args) {
            nameBinder.bind(scope, nNode, (NType)new NUnknownType());
        }
        if (nFunctionDef.varargs != null) {
            nameBinder.bind(scope, nFunctionDef.varargs, (NType)new NListType());
        }
        if (nFunctionDef.kwargs != null) {
            nameBinder.bind(scope, nFunctionDef.kwargs, (NType)new NDictType());
        }
        scope = s;
        nFunctionDef = this;
        for (NNode nNode : nFunctionDef.defaults) {
            if (!nNode.bindsName()) continue;
            nNode.bindNames(scope);
        }
        this.bindMethodAttrs(owner);
    }

    protected void bindFunctionName(Scope owner) throws Exception {
        NBinding.Kind funkind = NBinding.Kind.FUNCTION;
        if (owner.getScopeType() == Scope.Type.CLASS) {
            funkind = "__init__".equals(this.name.id) ? NBinding.Kind.CONSTRUCTOR : NBinding.Kind.METHOD;
        }
        NameBinder.make(funkind).bindName(owner, this.name, this.getType());
    }

    protected void bindMethodAttrs(Scope owner) throws Exception {
        NType nType;
        NType cls = Indexer.idx.lookupQnameType(owner.getPath());
        if (cls == null || !((nType = cls) instanceof NClassType)) {
            return;
        }
        this.addReadOnlyAttr("im_class", cls, NBinding.Kind.CLASS);
        this.addReadOnlyAttr("__class__", cls, NBinding.Kind.CLASS);
        this.addReadOnlyAttr("im_self", cls, NBinding.Kind.ATTRIBUTE);
        this.addReadOnlyAttr("__self__", cls, NBinding.Kind.ATTRIBUTE);
    }

    private NBinding addReadOnlyAttr(String name, NType type, NBinding.Kind kind) {
        NBinding.Kind kind2 = kind;
        NType nType = type;
        String string = name;
        NFunctionDef nFunctionDef = this;
        NBinding nBinding = nFunctionDef.getTable().update(string, Builtins.newDataModelUrl("the-standard-type-hierarchy"), nType, kind2);
        nBinding.markSynthetic();
        nBinding.markStatic();
        NBinding b = nBinding;
        b.markReadOnly();
        return b;
    }

    @Override
    public NType resolve(Scope outer) throws Exception {
        NBinding b;
        NTupleType fromType;
        NNode nNode;
        Object object;
        NType nType;
        NFunctionDef.resolveList(this.defaults, outer);
        NFunctionDef.resolveList(this.decoratorList, outer);
        Scope funcTable = this.getTable();
        NBinding selfBinding = funcTable.lookup("__self__");
        if (selfBinding != null && !((nType = selfBinding.getType()) instanceof NClassType)) {
            selfBinding = null;
        }
        if (selfBinding != null) {
            if (this.args.size() <= 0) {
                object = "method should have at least one argument (self)";
                nNode = this.name;
                Indexer.idx.putProblem(nNode, (String)object);
            } else if (!(this.args.get(0) instanceof NName)) {
                NFunctionDef.addError(this.name, "self parameter must be an identifier");
            }
        }
        NTupleType nTupleType = fromType = new NTupleType();
        object = selfBinding;
        nNode = this;
        NameBinder nameBinder = NameBinder.make(NBinding.Kind.PARAMETER);
        Scope scope = nNode.getTable();
        for (int i = 0; i < ((NFunctionDef)nNode).args.size(); ++i) {
            NNode nNode2 = ((NFunctionDef)nNode).args.get(i);
            NType nType2 = i == 0 && object != null ? ((NBinding)object).getType() : NFunctionDef.getArgType(((NFunctionDef)nNode).args, ((NFunctionDef)nNode).defaults, i);
            nameBinder.bind(scope, nNode2, nType2);
            nTupleType.add(nType2);
        }
        if (this.varargs != null && (b = funcTable.lookupLocal(this.varargs.id)) != null) {
            fromType.add(b.getType());
        }
        if (this.kwargs != null && (b = funcTable.lookupLocal(this.kwargs.id)) != null) {
            fromType.add(b.getType());
        }
        NType toType = NFunctionDef.resolveExpr(this.body, funcTable);
        nType = this.getType();
        ((NFuncType)nType).setReturnType(toType);
        return this.getType();
    }

    static NType getArgType(List<NNode> args, List<NNode> defaults, int argnum) {
        if (defaults == null) {
            return new NUnknownType();
        }
        int firstDefault = args.size() - defaults.size();
        if (firstDefault >= 0 && argnum >= firstDefault) {
            return defaults.get(argnum - firstDefault).getType();
        }
        return new NUnknownType();
    }

    public String toString() {
        return "<Function:" + this.start() + ":" + this.name + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NFunctionDef.visitNode(this.name, v);
            NFunctionDef.visitNodeList(this.args, v);
            NFunctionDef.visitNodeList(this.defaults, v);
            NFunctionDef.visitNode(this.kwargs, v);
            NFunctionDef.visitNode(this.varargs, v);
            NFunctionDef.visitNode(this.body, v);
        }
    }
}

