/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.common.processidentity.ProcessIdentity;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.console.communication.ProcessControl;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.messages.console.AgentAndCacheReport;
import net.grinder.util.AllocateLowestNumber;
import net.grinder.util.ListenerSupport;

final class ProcessStatusImplementation {
    private static final long UPDATE_PERIOD = 500L;
    private static final long FLUSH_PERIOD = 2000L;
    private final Map m_agentIdentityToAgentAndWorkers = new HashMap();
    private final AllocateLowestNumber m_agentNumberMap;
    private final ListenerSupport m_listeners = new ListenerSupport();
    private volatile boolean m_newData = false;

    public ProcessStatusImplementation(Timer timer, AllocateLowestNumber agentNumberMap) {
        this.m_agentNumberMap = agentNumberMap;
        timer.schedule(new TimerTask(){

            public void run() {
                ProcessStatusImplementation.this.update();
            }
        }, 0L, 500L);
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = ProcessStatusImplementation.this.m_agentIdentityToAgentAndWorkers;
                synchronized (map) {
                    ProcessStatusImplementation.this.purge(ProcessStatusImplementation.this.m_agentIdentityToAgentAndWorkers);
                }
            }
        }, 0L, 2000L);
    }

    public void addListener(ProcessControl.Listener listener) {
        this.m_listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLiveAgents() {
        Map map = this.m_agentIdentityToAgentAndWorkers;
        synchronized (map) {
            return this.m_agentIdentityToAgentAndWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        AgentAndWorkers[] processStatuses;
        if (!this.m_newData) {
            return;
        }
        this.m_newData = false;
        Map map = this.m_agentIdentityToAgentAndWorkers;
        synchronized (map) {
            processStatuses = this.m_agentIdentityToAgentAndWorkers.values().toArray(new AgentAndWorkers[this.m_agentIdentityToAgentAndWorkers.size()]);
        }
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ProcessControl.Listener)listener).update(processStatuses);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentAndWorkers getAgentAndWorkers(AgentIdentity agentIdentity) {
        Map map = this.m_agentIdentityToAgentAndWorkers;
        synchronized (map) {
            AgentAndWorkers existing = (AgentAndWorkers)this.m_agentIdentityToAgentAndWorkers.get(agentIdentity);
            if (existing != null) {
                return existing;
            }
            AgentAndWorkers created = new AgentAndWorkers(agentIdentity);
            this.m_agentIdentityToAgentAndWorkers.put(agentIdentity, created);
            this.m_agentNumberMap.add(agentIdentity);
            return created;
        }
    }

    public void addAgentStatusReport(AgentAndCacheReport agentProcessStatus) {
        AgentAndWorkers agentAndWorkers = this.getAgentAndWorkers(agentProcessStatus.getAgentIdentity());
        agentAndWorkers.setAgentProcessStatus(agentProcessStatus);
        this.m_newData = true;
    }

    public void addWorkerStatusReport(WorkerProcessReport workerProcessStatus) {
        AgentIdentity agentIdentity = workerProcessStatus.getWorkerIdentity().getAgentIdentity();
        this.getAgentAndWorkers(agentIdentity).setWorkerProcessStatus(workerProcessStatus);
        this.m_newData = true;
    }

    private void purge(Map purgableMap) {
        HashSet zombies = new HashSet();
        Iterator iterator = purgableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Purgable purgable = (Purgable)entry.getValue();
            if (!purgable.shouldPurge()) continue;
            zombies.add(key);
        }
        if (zombies.size() > 0) {
            purgableMap.keySet().removeAll(zombies);
            this.m_newData = true;
        }
    }

    final class AgentAndWorkers
    implements ProcessControl.ProcessReports,
    Purgable {
        private volatile AgentReference m_agentReportReference;
        private final Map m_workerReportReferences = new HashMap();

        AgentAndWorkers(AgentIdentity agentIdentity) {
            this.setAgentProcessStatus(new UnknownAgentProcessReport(agentIdentity));
        }

        void setAgentProcessStatus(AgentAndCacheReport agentProcessStatus) {
            this.m_agentReportReference = new AgentReference(agentProcessStatus);
        }

        public AgentAndCacheReport getAgentProcessReport() {
            return this.m_agentReportReference.getAgentProcessReport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setWorkerProcessStatus(WorkerProcessReport workerProcessStatus) {
            Map map = this.m_workerReportReferences;
            synchronized (map) {
                this.m_workerReportReferences.put(workerProcessStatus.getWorkerIdentity(), new WorkerReference(workerProcessStatus));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorkerProcessReport[] getWorkerProcessReports() {
            Map map = this.m_workerReportReferences;
            synchronized (map) {
                WorkerProcessReport[] result = new WorkerProcessReport[this.m_workerReportReferences.size()];
                Iterator iterator = this.m_workerReportReferences.values().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    result[i++] = ((WorkerReference)iterator.next()).getWorkerProcessReport();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldPurge() {
            Map map = this.m_workerReportReferences;
            synchronized (map) {
                ProcessStatusImplementation.this.purge(this.m_workerReportReferences);
            }
            return this.m_agentReportReference.shouldPurge();
        }
    }

    private static final class UnknownAgentProcessReport
    implements AgentAndCacheReport {
        private final AgentIdentity m_identity;

        public UnknownAgentProcessReport(AgentIdentity identity) {
            this.m_identity = identity;
        }

        public ProcessIdentity getIdentity() {
            return this.m_identity;
        }

        public AgentIdentity getAgentIdentity() {
            return this.m_identity;
        }

        public short getState() {
            return 4;
        }

        public CacheHighWaterMark getCacheHighWaterMark() {
            return null;
        }
    }

    private final class WorkerReference
    extends AbstractTimedReference {
        private final WorkerProcessReport m_workerProcessReport;

        WorkerReference(WorkerProcessReport workerProcessReport) {
            this.m_workerProcessReport = workerProcessReport;
        }

        public WorkerProcessReport getWorkerProcessReport() {
            return this.m_workerProcessReport;
        }
    }

    private final class AgentReference
    extends AbstractTimedReference {
        private final AgentAndCacheReport m_agentProcessReport;

        AgentReference(AgentAndCacheReport agentProcessReport) {
            this.m_agentProcessReport = agentProcessReport;
        }

        public AgentAndCacheReport getAgentProcessReport() {
            return this.m_agentProcessReport;
        }

        public boolean shouldPurge() {
            boolean purge = super.shouldPurge();
            if (purge) {
                ProcessStatusImplementation.this.m_agentNumberMap.remove(this.m_agentProcessReport.getAgentIdentity());
            }
            return purge;
        }
    }

    private abstract class AbstractTimedReference
    implements Purgable {
        private int m_purgeDelayCount;

        private AbstractTimedReference() {
        }

        public boolean shouldPurge() {
            if (this.m_purgeDelayCount > 0) {
                return true;
            }
            ++this.m_purgeDelayCount;
            return false;
        }
    }

    private static interface Purgable {
        public boolean shouldPurge();
    }
}

