/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.collect.ByFunctionOrdering;
import org.python.google.common.collect.NaturalOrdering;
import org.python.google.common.collect.ReverseOrdering;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public final <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);
}

