/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._collections;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._collections.PyDeque$PyExposer;

@ExposedType(name="collections.deque")
public class PyDeque
extends PyObject {
    public static final PyType TYPE;
    private int size = 0;
    private Node header = new Node(null, null, null);

    public PyDeque() {
        this(TYPE);
    }

    public PyDeque(PyType subType) {
        super(subType);
        this.header.left = (this.header.right = this.header);
    }

    @ExposedNew
    final void deque___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError("deque() does not take keyword arguments");
        }
        int nargs = args.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "deque", 0, 1);
        }
        if (nargs == 0) {
            return;
        }
        this.deque_extend(args[0]);
    }

    final void deque_append(PyObject obj) {
        this.addBefore(obj, this.header);
    }

    final void deque_appendleft(PyObject obj) {
        this.addBefore(obj, this.header.right);
    }

    private Node addBefore(PyObject obj, Node node) {
        Node newNode = new Node(obj, node, node.left);
        newNode.left.right = newNode;
        newNode.right.left = newNode;
        ++this.size;
        return newNode;
    }

    final void deque_clear() {
        Node node = this.header.right;
        while (node != this.header) {
            Node right = node.right;
            node.left = null;
            node.right = null;
            Node.access$202(node, null);
            node = right;
        }
        this.header.right = (this.header.left = this.header);
        this.size = 0;
    }

    final void deque_extend(PyObject iterable) {
        for (PyObject item : iterable.asIterable()) {
            this.deque_append(item);
        }
    }

    final void deque_extendleft(PyObject iterable) {
        for (PyObject item : iterable.asIterable()) {
            this.deque_appendleft(item);
        }
    }

    final PyObject deque_pop() {
        return this.removeNode(this.header.left);
    }

    final PyObject deque_popleft() {
        return this.removeNode(this.header.right);
    }

    private PyObject removeNode(Node node) {
        if (node == this.header) {
            throw Py.IndexError("pop from an empty deque");
        }
        PyObject obj = node.data;
        node.left.right = node.right;
        node.right.left = node.left;
        node.right = null;
        node.left = null;
        Node.access$202(node, null);
        --this.size;
        return obj;
    }

    final PyObject deque_remove(PyObject value) {
        int n = this.size;
        Node tmp = this.header.right;
        boolean match = false;
        for (int i = 0; i < n; ++i) {
            if (tmp.data.equals(value)) {
                match = true;
            }
            if (n != this.size) {
                throw Py.IndexError("deque mutated during remove().");
            }
            if (match) {
                return this.removeNode(tmp);
            }
            tmp = tmp.right;
        }
        throw Py.ValueError("deque.remove(x): x not in deque");
    }

    final void deque_rotate(int steps) {
        int i;
        if (this.size == 0) {
            return;
        }
        int halfsize = this.size + 1 >> 1;
        if (steps > halfsize || steps < -halfsize) {
            if ((steps %= this.size) > halfsize) {
                steps -= this.size;
            } else if (steps < -halfsize) {
                steps += this.size;
            }
        }
        for (i = 0; i < steps; ++i) {
            this.deque_appendleft(this.deque_pop());
        }
        for (i = 0; i > steps; --i) {
            this.deque_append(this.deque_popleft());
        }
    }

    @Override
    public String toString() {
        return this.deque_toString();
    }

    final String deque_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuilder buf = new StringBuilder("deque([");
        Node tmp = this.header.right;
        while (tmp != this.header) {
            buf.append(tmp.data.__repr__().toString());
            if (tmp.right != this.header) {
                buf.append(", ");
            }
            tmp = tmp.right;
        }
        buf.append("])");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __len__() {
        PyDeque pyDeque = this;
        return pyDeque.size;
    }

    final int deque___len__() {
        return this.size;
    }

    @Override
    public boolean __nonzero__() {
        return this.deque___nonzero__();
    }

    final boolean deque___nonzero__() {
        return this.size != 0;
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        try {
            return this.deque___getitem__(key);
        }
        catch (PyException pyException) {
            PyException pe = pyException;
            if (pyException.match(Py.KeyError)) {
                return null;
            }
            throw pe;
        }
    }

    final PyObject deque___getitem__(PyObject index) {
        return this.getNode(index).data;
    }

    @Override
    public void __setitem__(PyObject index, PyObject value) {
        this.deque___setitem__(index, value);
    }

    final void deque___setitem__(PyObject index, PyObject value) {
        Node node = this.getNode(index).right;
        this.removeNode(node.left);
        this.addBefore(value, node);
    }

    @Override
    public void __delitem__(PyObject key) {
        this.deque___delitem__(key);
    }

    final void deque___delitem__(PyObject key) {
        this.removeNode(this.getNode(key));
    }

    private Node getNode(PyObject index) {
        if (!index.isIndex()) {
            throw Py.TypeError(String.format("sequence index must be integer, not '%.200s'", index.getType().fastGetName()));
        }
        int pos = index.asIndex(Py.IndexError);
        if (pos < 0) {
            pos += this.size;
        }
        if (pos < 0 || pos >= this.size) {
            throw Py.IndexError("index out of range: " + index);
        }
        Node tmp = this.header;
        if (pos < this.size >> 1) {
            for (int i = 0; i <= pos; ++i) {
                tmp = tmp.right;
            }
        } else {
            for (int i = this.size - 1; i >= pos; --i) {
                tmp = tmp.left;
            }
        }
        return tmp;
    }

    @Override
    public PyObject __iter__() {
        return this.deque___iter__();
    }

    final PyObject deque___iter__() {
        return new PyDequeIter(this);
    }

    @Override
    public synchronized PyObject __eq__(PyObject o) {
        return this.deque___eq__(o);
    }

    final synchronized PyObject deque___eq__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.False;
        }
        int i = PyDeque.cmp(this, tl, o, ol);
        if (i < 0) {
            return Py.True;
        }
        return Py.False;
    }

    @Override
    public synchronized PyObject __ne__(PyObject o) {
        return this.deque___ne__(o);
    }

    final synchronized PyObject deque___ne__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.True;
        }
        int i = PyDeque.cmp(this, tl, o, ol);
        if (i < 0) {
            return Py.False;
        }
        return Py.True;
    }

    @Override
    public synchronized PyObject __lt__(PyObject o) {
        return this.deque___lt__(o);
    }

    final synchronized PyObject deque___lt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            if (i == -1) {
                return Py.True;
            }
            return Py.False;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __le__(PyObject o) {
        return this.deque___le__(o);
    }

    final synchronized PyObject deque___le__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            if (i == -1 || i == -2) {
                return Py.True;
            }
            return Py.False;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __gt__(PyObject o) {
        return this.deque___gt__(o);
    }

    final synchronized PyObject deque___gt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            if (i == -3) {
                return Py.True;
            }
            return Py.False;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __ge__(PyObject o) {
        return this.deque___ge__(o);
    }

    final synchronized PyObject deque___ge__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PyDeque.cmp(this, -1, o, -1);
        if (i < 0) {
            if (i == -3 || i == -2) {
                return Py.True;
            }
            return Py.False;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i).equals(o2.__getitem__(i))) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        if (ol1 < ol2) {
            return -1;
        }
        return -3;
    }

    @Override
    public int hashCode() {
        throw Py.TypeError("deque objects are unhashable");
    }

    static int deque_hashCode() {
        throw Py.TypeError("deque objects are unhashable");
    }

    @Override
    public PyObject __reduce__() {
        return this.deque___reduce__();
    }

    final PyObject deque___reduce__() {
        PyObject dict = this.getDict();
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), Py.EmptyTuple, dict, this.__iter__());
    }

    final PyObject deque___copy__() {
        PyDeque pd = (PyDeque)this.getType().__call__();
        pd.deque_extend(this);
        return pd;
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return true;
    }

    static {
        PyType.addBuilder(PyDeque.class, new PyDeque$PyExposer());
        TYPE = PyType.fromClass(PyDeque.class);
    }

    class PyDequeIter
    extends PyIterator {
        private Node lastReturned;
        private int itersize;
        private /* synthetic */ PyDeque this$0;

        public PyDequeIter(PyDeque pyDeque) {
            this.this$0 = pyDeque;
            this.lastReturned = this.this$0.header;
            this.itersize = pyDeque.size;
        }

        @Override
        public PyObject __iternext__() {
            if (this.itersize != this.this$0.size) {
                throw Py.RuntimeError("deque changed size during iteration");
            }
            if (this.lastReturned.right != this.this$0.header) {
                this.lastReturned = this.lastReturned.right;
                return this.lastReturned.data;
            }
            return null;
        }
    }

    static class Node {
        private Node left;
        private Node right;
        private PyObject data;

        Node(PyObject data, Node right, Node left) {
            this.data = data;
            this.right = right;
            this.left = left;
        }

        static /* synthetic */ PyObject access$202(Node x0, PyObject x1) {
            x0.data = null;
            return null;
        }
    }
}

