/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;

class NativeMemory
implements DirectMemory,
Memory {
    protected static final MemoryIO IO = MemoryIO.getInstance();
    private NativeMemory parent;
    private long address;

    NativeMemory(long address) {
        this.address = address;
    }

    private NativeMemory(NativeMemory parent, long offset) {
        this.address = parent.address + offset;
    }

    @Override
    public final long getAddress() {
        return this.address;
    }

    @Override
    public NativeMemory slice(long offset) {
        if (offset == 0L) {
            return this;
        }
        return new NativeMemory(this, offset);
    }

    public final boolean equals(Object obj) {
        return obj instanceof DirectMemory && ((DirectMemory)obj).getAddress() == this.address;
    }

    public final int hashCode() {
        int hash = 265 + (int)(this.address ^ this.address >>> 32);
        return hash;
    }

    @Override
    public final boolean isNull() {
        return this.address == 0L;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final byte getByte(long offset) {
        return IO.getByte(this.address + offset);
    }

    @Override
    public final short getShort(long offset) {
        return IO.getShort(this.address + offset);
    }

    @Override
    public final int getInt(long offset) {
        return IO.getInt(this.address + offset);
    }

    @Override
    public final long getLong(long offset) {
        return IO.getLong(this.address + offset);
    }

    @Override
    public final long getNativeLong(long offset) {
        if (Platform.getPlatform().longSize() == 32) {
            return IO.getInt(this.address + offset);
        }
        return IO.getLong(this.address + offset);
    }

    @Override
    public final float getFloat(long offset) {
        return IO.getFloat(this.address + offset);
    }

    @Override
    public final double getDouble(long offset) {
        return IO.getDouble(this.address + offset);
    }

    @Override
    public final long getAddress(long offset) {
        return IO.getAddress(this.address + offset);
    }

    @Override
    public final DirectMemory getMemory(long offset) {
        long ptr = IO.getAddress(this.address + offset);
        if (ptr != 0L) {
            return new NativeMemory(ptr);
        }
        return null;
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset) {
        return MemoryIO.getZeroTerminatedByteArray(this.address + offset);
    }

    @Override
    public void putZeroTerminatedByteArray(long offset, byte[] bytes, int off, int len) {
        MemoryIO.putZeroTerminatedByteArray(this.address + offset, bytes, off, len);
    }

    @Override
    public final void putByte(long offset, byte value) {
        IO.putByte(this.address + offset, value);
    }

    @Override
    public final void putShort(long offset, short value) {
        IO.putShort(this.address + offset, value);
    }

    @Override
    public final void putInt(long offset, int value) {
        IO.putInt(this.address + offset, value);
    }

    @Override
    public final void putLong(long offset, long value) {
        IO.putLong(this.address + offset, value);
    }

    @Override
    public final void putNativeLong(long offset, long value) {
        if (Platform.getPlatform().longSize() == 32) {
            IO.putInt(this.address + offset, (int)value);
            return;
        }
        IO.putLong(this.address + offset, value);
    }

    @Override
    public final void putAddress(long offset, long value) {
        IO.putAddress(this.address + offset, value);
    }

    @Override
    public final void putFloat(long offset, float value) {
        IO.putFloat(this.address + offset, value);
    }

    @Override
    public final void putDouble(long offset, double value) {
        IO.putDouble(this.address + offset, value);
    }

    @Override
    public final void putAddress(long offset, Memory value) {
        IO.putAddress(this.address + offset, ((DirectMemory)value).getAddress());
    }

    @Override
    public final void get(long offset, byte[] dst, int off, int len) {
        MemoryIO.getByteArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, byte[] src, int off, int len) {
        MemoryIO.putByteArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, short[] dst, int off, int len) {
        MemoryIO.getShortArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, short[] src, int off, int len) {
        MemoryIO.putShortArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, int[] dst, int off, int len) {
        MemoryIO.getIntArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, int[] src, int off, int len) {
        MemoryIO.putIntArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, long[] dst, int off, int len) {
        MemoryIO.getLongArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, long[] src, int off, int len) {
        MemoryIO.putLongArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, float[] dst, int off, int len) {
        MemoryIO.getFloatArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, float[] src, int off, int len) {
        MemoryIO.putFloatArray(this.address + offset, src, off, len);
    }

    @Override
    public final void get(long offset, double[] dst, int off, int len) {
        MemoryIO.getDoubleArray(this.address + offset, dst, off, len);
    }

    @Override
    public final void put(long offset, double[] src, int off, int len) {
        MemoryIO.putDoubleArray(this.address + offset, src, off, len);
    }

    @Override
    public final int indexOf(long offset, byte value) {
        if (value == 0) {
            return (int)MemoryIO.getStringLength(this.address + offset);
        }
        return (int)MemoryIO.indexOf(this.address + offset, value);
    }

    @Override
    public final int indexOf(long offset, byte value, int maxlen) {
        return (int)MemoryIO.indexOf(this.address, value, maxlen);
    }

    @Override
    public final void setMemory(long offset, long size, byte value) {
        IO.setMemory(this.address + offset, size, value);
    }
}

