/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.BindingFinder;
import org.python.indexer.ast.DefaultNodeVisitor;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NClassDef;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NGlobal;
import org.python.indexer.ast.NLambda;
import org.python.indexer.ast.NNode;
import org.python.indexer.types.NType;

public final class NBody
extends NBlock {
    public NBody(NBlock block) {
        this(block == null ? null : block.seq);
    }

    public NBody(List<NNode> seq) {
        super(seq);
    }

    @Override
    public final NType resolve(Scope scope) throws Exception {
        try {
            scope.setNameBindingPhase(true);
            this.visit(new GlobalFinder(this, scope));
            this.visit(new BindingFinder(scope));
        }
        finally {
            scope.setNameBindingPhase(false);
        }
        return super.resolve(scope);
    }

    final class GlobalFinder
    extends DefaultNodeVisitor {
        private Scope scope;

        public GlobalFinder(NBody nBody, Scope scope) {
            this.scope = scope;
        }

        @Override
        public final boolean visit(NGlobal n) {
            NNode.resolveExpr(n, this.scope);
            return false;
        }

        @Override
        public final boolean visit(NFunctionDef n) {
            return false;
        }

        @Override
        public final boolean visit(NLambda n) {
            return false;
        }

        @Override
        public final boolean visit(NClassDef n) {
            return false;
        }
    }
}

