/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import net.grinder.common.Closer;
import net.grinder.common.GrinderException;
import net.grinder.common.Logger;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.TCPProxyEngine;
import net.grinder.tools.tcpproxy.TCPProxyFilter;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.util.TerminalColour;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public abstract class AbstractTCPProxyEngine
implements TCPProxyEngine {
    private final TCPProxyFilter m_requestFilter;
    private final TCPProxyFilter m_responseFilter;
    private final String m_requestColour;
    private final String m_responseColour;
    private final Logger m_logger;
    private final PrintWriter m_outputWriter;
    private final TCPProxySocketFactory m_socketFactory;
    private final ServerSocket m_serverSocket;
    private final List m_streamThreads = new LinkedList();
    private final ThreadGroup m_streamThreadGroup = new ThreadGroup("TCPProxy Stream Handler");

    public AbstractTCPProxyEngine(TCPProxySocketFactory socketFactory, TCPProxyFilter requestFilter, TCPProxyFilter responseFilter, Logger logger, EndPoint localEndPoint, boolean useColour, int timeout) throws IOException {
        this.m_logger = logger;
        this.m_outputWriter = logger.getOutputLogWriter();
        this.m_socketFactory = socketFactory;
        this.m_requestFilter = requestFilter;
        this.m_responseFilter = responseFilter;
        if (useColour) {
            this.m_requestColour = TerminalColour.RED;
            this.m_responseColour = TerminalColour.BLUE;
        } else {
            this.m_requestColour = "";
            this.m_responseColour = "";
        }
        this.m_serverSocket = this.m_socketFactory.createServerSocket(localEndPoint, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StreamThread[] threads;
        ServerSocket serverSocket = this.m_serverSocket;
        synchronized (serverSocket) {
            if (!this.isStopped()) {
                try {
                    this.m_serverSocket.close();
                }
                catch (IOException ioe) {
                    UncheckedInterruptedException.ioException(ioe);
                }
            }
        }
        List ioe = this.m_streamThreads;
        synchronized (ioe) {
            threads = this.m_streamThreads.toArray(new StreamThread[this.m_streamThreads.size()]);
        }
        for (int i = 0; i < threads.length; ++i) {
            threads[i].stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        ServerSocket serverSocket = this.m_serverSocket;
        synchronized (serverSocket) {
            return this.m_serverSocket.isClosed();
        }
    }

    public abstract void run();

    final ThreadGroup getStreamThreadGroup() {
        return this.m_streamThreadGroup;
    }

    protected Socket accept() throws NoActivityTimeOutException, IOException {
        while (true) {
            try {
                return this.m_serverSocket.accept();
            }
            catch (SocketTimeoutException e) {
                if (this.getStreamThreadGroup().activeCount() != 0) continue;
                this.stop();
                throw new NoActivityTimeOutException();
            }
            break;
        }
    }

    protected EndPoint getListenEndPoint() {
        return EndPoint.serverEndPoint(this.m_serverSocket);
    }

    protected final TCPProxySocketFactory getSocketFactory() {
        return this.m_socketFactory;
    }

    protected final TCPProxyFilter getRequestFilter() {
        return this.m_requestFilter;
    }

    protected final TCPProxyFilter getResponseFilter() {
        return this.m_responseFilter;
    }

    protected final String getRequestColour() {
        return this.m_requestColour;
    }

    protected final String getResponseColour() {
        return this.m_responseColour;
    }

    protected final void launchThreadPair(Socket localSocket, EndPoint remoteEndPoint, EndPoint clientEndPoint, boolean isSecure) throws IOException {
        Socket remoteSocket = this.m_socketFactory.createClientSocket(remoteEndPoint);
        ConnectionDetails connectionDetails = new ConnectionDetails(clientEndPoint, remoteEndPoint, isSecure);
        new FilteredStreamThread(localSocket.getInputStream(), new OutputStreamFilterTee(connectionDetails, remoteSocket.getOutputStream(), this.m_requestFilter, this.m_requestColour));
        new FilteredStreamThread(remoteSocket.getInputStream(), new OutputStreamFilterTee(connectionDetails.getOtherEnd(), localSocket.getOutputStream(), this.m_responseFilter, this.m_responseColour));
    }

    /*
     * WARNING - void declaration
     */
    protected final String logIOException(IOException e) {
        void var4_4;
        String description;
        Class<?> c = e.getClass();
        String message = e.getMessage();
        if (e instanceof NoActivityTimeOutException) {
            description = "Listen time out";
        } else if (e instanceof ConnectException) {
            description = message;
        } else if (e instanceof UnknownHostException) {
            description = "Failed to connect to unknown host '" + message + "'";
        } else {
            if (IOException.class.equals(c) && "Stream closed".equals(message) || e instanceof SocketException) {
                return "";
            }
            e.printStackTrace(this.getLogger().getErrorLogWriter());
            return message;
        }
        this.getLogger().error((String)var4_4);
        return var4_4;
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected final class OutputStreamFilterTee {
        private final ConnectionDetails m_connectionDetails;
        private final OutputStream m_out;
        private final TCPProxyFilter m_filter;
        private final String m_colour;
        private final String m_resetColour;

        public OutputStreamFilterTee(ConnectionDetails connectionDetails, OutputStream out, TCPProxyFilter filter, String colourString) {
            this.m_connectionDetails = connectionDetails;
            this.m_out = out;
            this.m_filter = filter;
            this.m_colour = colourString;
            this.m_resetColour = this.m_colour.length() > 0 ? TerminalColour.NONE : "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionOpened() {
            this.preOutput();
            try {
                this.m_filter.connectionOpened(this.m_connectionDetails);
            }
            catch (GrinderException e) {
                e.printStackTrace(AbstractTCPProxyEngine.this.getLogger().getErrorLogWriter());
            }
            finally {
                this.postOutput();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(byte[] buffer, int bytesRead) throws IOException {
            this.preOutput();
            byte[] newBytes = null;
            try {
                newBytes = this.m_filter.handle(this.m_connectionDetails, buffer, bytesRead);
            }
            catch (GrinderException e) {
                e.printStackTrace(AbstractTCPProxyEngine.this.getLogger().getErrorLogWriter());
            }
            finally {
                this.postOutput();
            }
            if (newBytes != null) {
                this.m_out.write(newBytes);
            } else {
                this.m_out.write(buffer, 0, bytesRead);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed() {
            this.preOutput();
            try {
                this.m_filter.connectionClosed(this.m_connectionDetails);
            }
            catch (GrinderException e) {
                e.printStackTrace(AbstractTCPProxyEngine.this.getLogger().getErrorLogWriter());
            }
            finally {
                this.postOutput();
            }
            Closer.close(this.m_out);
        }

        public ConnectionDetails getConnectionDetails() {
            return this.m_connectionDetails;
        }

        private void preOutput() {
            AbstractTCPProxyEngine.this.m_outputWriter.print(this.m_colour);
        }

        private void postOutput() {
            AbstractTCPProxyEngine.this.m_outputWriter.print(this.m_resetColour);
            AbstractTCPProxyEngine.this.m_outputWriter.flush();
        }
    }

    protected final class FilteredStreamThread
    implements InterruptibleRunnable {
        private static final int BUFFER_SIZE = 65536;
        private final InputStream m_in;
        private final OutputStreamFilterTee m_outputStreamFilterTee;

        FilteredStreamThread(InputStream in, OutputStreamFilterTee outputStreamFilterTee) {
            this.m_in = in;
            this.m_outputStreamFilterTee = outputStreamFilterTee;
            new StreamThread(this, "Filter thread for " + outputStreamFilterTee.getConnectionDetails(), this.m_in).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            this.m_outputStreamFilterTee.connectionOpened();
            byte[] buffer = new byte[65536];
            try {
                int bytesRead;
                while ((bytesRead = this.m_in.read(buffer, 0, 65536)) != -1) {
                    this.m_outputStreamFilterTee.handle(buffer, bytesRead);
                }
            }
            catch (SocketException e) {
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                AbstractTCPProxyEngine.this.logIOException(e);
            }
            finally {
                this.m_outputStreamFilterTee.connectionClosed();
            }
            Closer.close(this.m_in);
        }
    }

    protected class StreamThread {
        private final Thread m_thread;
        private final InputStream m_inputStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StreamThread(InterruptibleRunnable runnable, String name, InputStream inputStream) {
            this.m_thread = new Thread(AbstractTCPProxyEngine.this.getStreamThreadGroup(), new InterruptibleRunnableAdapter(runnable), name);
            this.m_inputStream = inputStream;
            List list = AbstractTCPProxyEngine.this.m_streamThreads;
            synchronized (list) {
                AbstractTCPProxyEngine.this.m_streamThreads.add(this);
            }
        }

        public void start() {
            this.m_thread.start();
        }

        public void stop() {
            Closer.close(this.m_inputStream);
            this.m_thread.interrupt();
            try {
                this.m_thread.join();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        }
    }

    private static final class NoActivityTimeOutException
    extends IOException {
        private NoActivityTimeOutException() {
        }
    }
}

