/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

final class ObjectBuffer {
    private Object[] objects;
    private int[] info;
    private int infoIndex = 0;
    private int objectIndex = 0;

    ObjectBuffer() {
        this.objects = new Object[1];
        this.info = new int[this.objects.length * 3];
    }

    ObjectBuffer(int objectCount) {
        this.objects = new Object[objectCount];
        this.info = new int[objectCount * 3];
    }

    final int objectCount() {
        return this.objectIndex;
    }

    final int[] info() {
        return this.info;
    }

    final Object[] objects() {
        return this.objects;
    }

    static final int makeObjectFlags(int ioflags, int type, int index) {
        return ioflags & 0xFF | index << 16 & 0xFF0000 | type;
    }

    final void putObject(Object array, int offset, int length, int flags) {
        ObjectBuffer objectBuffer = this;
        if (objectBuffer.objects.length <= objectBuffer.objectIndex + 1) {
            Object[] objectArray = new Object[objectBuffer.objects.length << 1];
            System.arraycopy(objectBuffer.objects, 0, objectArray, 0, objectBuffer.objectIndex);
            objectBuffer.objects = objectArray;
            int[] nArray = new int[objectBuffer.objects.length * 3];
            System.arraycopy(objectBuffer.info, 0, nArray, 0, objectBuffer.objectIndex * 3);
            objectBuffer.info = nArray;
        }
        this.objects[this.objectIndex++] = array;
        this.info[this.infoIndex++] = flags;
        this.info[this.infoIndex++] = offset;
        this.info[this.infoIndex++] = length;
    }
}

