/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.TCPProxyFilter;

public final class CompositeFilter
implements TCPProxyFilter {
    private final List m_filters = new ArrayList();

    public byte[] handle(ConnectionDetails connectionDetails, byte[] originalBuffer, int bytesRead) throws TCPProxyFilter.FilterException {
        Iterator iterator = this.m_filters.iterator();
        byte[] nextBuffer = originalBuffer;
        int nextBytesRead = bytesRead;
        while (iterator.hasNext()) {
            TCPProxyFilter filter = (TCPProxyFilter)iterator.next();
            byte[] buffer = filter.handle(connectionDetails, nextBuffer, nextBytesRead);
            if (buffer == null) continue;
            nextBuffer = buffer;
            nextBytesRead = buffer.length;
        }
        return (byte[])(nextBuffer != originalBuffer ? nextBuffer : null);
    }

    public void connectionOpened(ConnectionDetails connectionDetails) throws TCPProxyFilter.FilterException {
        Iterator iterator = this.m_filters.iterator();
        while (iterator.hasNext()) {
            TCPProxyFilter filter = (TCPProxyFilter)iterator.next();
            filter.connectionOpened(connectionDetails);
        }
    }

    public void connectionClosed(ConnectionDetails connectionDetails) throws TCPProxyFilter.FilterException {
        Iterator iterator = this.m_filters.iterator();
        while (iterator.hasNext()) {
            TCPProxyFilter filter = (TCPProxyFilter)iterator.next();
            filter.connectionClosed(connectionDetails);
        }
    }

    public void add(TCPProxyFilter filter) {
        this.m_filters.add(filter);
    }

    TCPProxyFilter[] getFilters() {
        return this.m_filters.toArray(new TCPProxyFilter[this.m_filters.size()]);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator iterator = this.m_filters.iterator();
        while (iterator.hasNext()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            TCPProxyFilter filter = (TCPProxyFilter)iterator.next();
            String fullName = filter.getClass().getName();
            int lastDot = fullName.lastIndexOf(".");
            result.append(fullName.substring(lastDot + 1));
        }
        return result.toString();
    }
}

