/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.grinder.common.Logger;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.swingui.JOptionPaneDialog;
import net.grinder.console.swingui.LookAndFeel;

final class ErrorDialogHandler
implements ErrorHandler {
    private final JOptionPane m_optionPane = new JOptionPane(null, 0, 0, null, null);
    private JOptionPaneDialog m_dialog;
    private final String m_errorTitle;
    private final String m_unexpectedErrorTitle;
    private final String m_errorDetailsTitle;
    private final Object[] m_okOptions;
    private final Object[] m_okDetailsOptions;
    private final Object[] m_detailsOptions;
    private Throwable m_throwable;
    private final Logger m_logger;

    public ErrorDialogHandler(JFrame frame, Resources resources, Logger logger) {
        this(resources, logger);
        this.m_dialog = new JOptionPaneDialog(frame, null, true, this.m_optionPane){

            protected boolean shouldClose() {
                return ErrorDialogHandler.this.shouldClose();
            }
        };
    }

    public ErrorDialogHandler(JDialog dialog, Resources resources, Logger logger) {
        this(resources, logger);
        this.m_dialog = new JOptionPaneDialog(dialog, null, true, this.m_optionPane){

            protected boolean shouldClose() {
                return ErrorDialogHandler.this.shouldClose();
            }
        };
    }

    public void registerWithLookAndFeel(LookAndFeel lookAndFeel) {
        lookAndFeel.addListener(new LookAndFeel.ComponentListener(this.m_dialog));
    }

    private ErrorDialogHandler(Resources resources, Logger logger) {
        this.m_logger = logger;
        this.m_errorTitle = resources.getString("error.title");
        this.m_unexpectedErrorTitle = resources.getString("unexpectedError.title");
        this.m_errorDetailsTitle = resources.getString("errorDetails.title");
        String errorOkText = resources.getString("error.ok.label");
        String detailsText = resources.getString("error.details.label");
        String detailsOkText = resources.getString("errorDetails.ok.label");
        String detailsClipboardText = resources.getString("errorDetails.copytoclipboard.label");
        this.m_okOptions = new Object[]{errorOkText};
        this.m_okDetailsOptions = new Object[]{errorOkText, detailsText};
        this.m_detailsOptions = new Object[]{detailsOkText, detailsClipboardText};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldClose() {
        Object value = this.m_optionPane.getValue();
        if (this.m_throwable != null && value == this.m_okDetailsOptions[1]) {
            String oldLineSeparator = System.getProperty("line.separator");
            try {
                System.setProperty("line.separator", "\n");
                StringWriter stringWriter = new StringWriter();
                StackTraceHTMLPrintWriter writer = new StackTraceHTMLPrintWriter(stringWriter);
                this.m_throwable.printStackTrace(writer);
                ((PrintWriter)writer).close();
                JLabel label = new JLabel();
                label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                label.setText(stringWriter.toString());
                JScrollPane scrollPane = new JScrollPane(label, 20, 31){

                    public Dimension getPreferredSize() {
                        Dimension d = super.getPreferredSize();
                        d.width = 600;
                        d.height = 250;
                        return d;
                    }
                };
                final JOptionPane detailsOptionPane = new JOptionPane(scrollPane, 1);
                detailsOptionPane.setOptions(this.m_detailsOptions);
                JOptionPaneDialog detailsDialog = new JOptionPaneDialog(this.m_dialog, this.m_errorDetailsTitle, true, detailsOptionPane){

                    protected boolean shouldClose() {
                        if (detailsOptionPane.getValue() == ErrorDialogHandler.this.m_detailsOptions[1]) {
                            StringWriter plainStackStringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(plainStackStringWriter);
                            ErrorDialogHandler.this.m_throwable.printStackTrace(printWriter);
                            printWriter.close();
                            StringSelection stringSelection = new StringSelection(plainStackStringWriter.toString());
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                            return false;
                        }
                        return true;
                    }
                };
                detailsDialog.pack();
                detailsDialog.setLocationRelativeTo(detailsDialog.getOwner());
                detailsDialog.setVisible(true);
                boolean bl = false;
                return bl;
            }
            finally {
                System.setProperty("line.separator", oldLineSeparator);
            }
        }
        return true;
    }

    public void handleErrorMessage(String errorMessage) {
        this.handleErrorMessage(errorMessage, this.m_errorTitle);
    }

    public void handleErrorMessage(String errorMessage, String title) {
        this.m_throwable = null;
        this.m_optionPane.setMessage(errorMessage);
        this.m_optionPane.setOptions(this.m_okOptions);
        this.showDialog(title);
    }

    public void handleException(Throwable throwable) {
        if (throwable instanceof DisplayMessageConsoleException) {
            this.handleException(throwable, this.m_errorTitle);
        } else {
            this.handleException(throwable, this.m_unexpectedErrorTitle);
        }
    }

    public void handleException(Throwable throwable, String title) {
        this.m_throwable = throwable;
        this.m_optionPane.setMessage(this.m_throwable.getMessage());
        this.m_optionPane.setOptions(this.m_okDetailsOptions);
        this.showDialog(title);
    }

    public void handleInformationMessage(String informationMessage) {
        this.m_logger.output(informationMessage);
    }

    private void showDialog(String title) {
        this.m_dialog.setTitle(title);
        this.m_dialog.pack();
        this.m_dialog.setLocationRelativeTo(this.m_dialog.getOwner());
        this.m_dialog.setVisible(true);
    }

    private static final class StackTraceHTMLPrintWriter
    extends PrintWriter {
        private static final int NO_INDENT = 0;
        private static final int INDENT = 1;
        private static final int CLOSE_INDENT = 2;
        private int m_state = 0;
        private static final String OPEN_TOP_LEVEL_LINE_FORMAT = "<font size='-1' color='#000000'><strong>";
        private static final String CLOSE_TOP_LEVEL_LINE_FORMAT = "</strong></font>";
        private static final String OPEN_INDENT_FORMAT = "<blockquote><font color='#202020' size='-2'>";
        private static final String CLOSE_INDENT_FORMAT = "</font></blockquote>";

        public StackTraceHTMLPrintWriter(Writer delegate) {
            super(delegate);
            this.writeDirect("<html><body><font size='-1' color='#000000'><strong>");
        }

        public void write(char[] buffer, int offset, int length) {
            int last = offset + length;
            int p = offset;
            for (int i = offset; i < last; ++i) {
                String replacement = this.replaceCharacter(buffer[i]);
                if (replacement == null) continue;
                super.write(buffer, p, i - p);
                p = i + 1;
                this.writeDirect(replacement);
            }
            super.write(buffer, p, last - p);
        }

        public void write(String s, int offset, int length) {
            this.write(s.toCharArray(), offset, length);
        }

        public void write(char c) {
            String replacement = this.replaceCharacter(c);
            if (replacement != null) {
                this.writeDirect(replacement);
            } else {
                super.write(c);
            }
        }

        private void writeDirect(String s) {
            char[] chars = s.toCharArray();
            super.write(chars, 0, chars.length);
        }

        private String replaceCharacter(char c) {
            switch (c) {
                case '\t': {
                    if (this.m_state == 0) {
                        this.m_state = 1;
                        return "</strong></font><blockquote><font color='#202020' size='-2'>";
                    }
                    this.m_state = 1;
                    return "";
                }
                case '\n': {
                    return this.endOfLine();
                }
                case '<': {
                    return "&lt;";
                }
                case '>': {
                    return "&gt;";
                }
            }
            if (this.m_state == 2) {
                this.m_state = 0;
                return "</font></blockquote><font size='-1' color='#000000'><strong>" + c;
            }
            return null;
        }

        private String endOfLine() {
            if (this.m_state == 1) {
                this.m_state = 2;
                return "<p>";
            }
            return "";
        }

        public void println() {
            this.writeDirect(this.endOfLine());
        }

        public void close() {
            this.writeDirect("</body></html>");
            super.close();
        }
    }
}

