/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.grinder.common.GrinderProperties;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.distribution.FileChangeWatcher;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.BufferImplementation;
import net.grinder.console.editor.ExternalEditor;
import net.grinder.console.editor.TextSource;
import net.grinder.util.ListenerSupport;

public final class EditorModel {
    private final Resources m_resources;
    private final TextSource.Factory m_textSourceFactory;
    private final AgentCacheState m_agentCacheState;
    private final ListenerSupport m_listeners = new ListenerSupport();
    private final LinkedList m_bufferList = new LinkedList();
    private final Map m_fileBuffers = Collections.synchronizedMap(new HashMap());
    private int m_nextNewBufferNameIndex = 0;
    private Buffer m_selectedBuffer;
    private File m_selectedProperties;
    private File m_selectedFile;
    private ExternalEditor m_externalEditor;

    public EditorModel(Resources resources, TextSource.Factory textSourceFactory, AgentCacheState agentCacheState, FileChangeWatcher fileChangeWatcher) {
        this.m_resources = resources;
        this.m_textSourceFactory = textSourceFactory;
        this.m_agentCacheState = agentCacheState;
        fileChangeWatcher.addFileChangedListener(new FileChangeWatcher.FileChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void filesChanged(File[] files) {
                Map map = EditorModel.this.m_fileBuffers;
                synchronized (map) {
                    for (int i = 0; i < files.length; ++i) {
                        Buffer buffer = EditorModel.this.getBufferForFile(files[i]);
                        if (buffer != null && !buffer.isUpToDate()) {
                            EditorModel.this.fireBufferNotUpToDate(buffer);
                        }
                        EditorModel.this.parseSelectedProperties(files[i]);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getSelectedBuffer() {
        EditorModel editorModel = this;
        synchronized (editorModel) {
            return this.m_selectedBuffer;
        }
    }

    public void selectNewBuffer() {
        BufferImplementation buffer = new BufferImplementation(this.m_resources, this.m_textSourceFactory.create(), this.createNewBufferName());
        this.addBuffer(buffer);
        this.selectBuffer(buffer);
    }

    public Buffer selectBufferForFile(File file) throws ConsoleException {
        Buffer buffer;
        Buffer existingBuffer = this.getBufferForFile(file);
        if (existingBuffer != null) {
            buffer = existingBuffer;
            this.selectBuffer(buffer);
            if (!buffer.isUpToDate()) {
                this.fireBufferNotUpToDate(buffer);
            }
        } else {
            buffer = new BufferImplementation(this.m_resources, this.m_textSourceFactory.create(), file);
            buffer.load();
            this.addBuffer(buffer);
            this.m_fileBuffers.put(file, buffer);
            this.selectBuffer(buffer);
        }
        return buffer;
    }

    public Buffer getBufferForFile(File file) {
        return (Buffer)this.m_fileBuffers.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer[] getBuffers() {
        LinkedList linkedList = this.m_bufferList;
        synchronized (linkedList) {
            return this.m_bufferList.toArray(new Buffer[this.m_bufferList.size()]);
        }
    }

    public boolean isABufferDirty() {
        Buffer[] buffers = this.getBuffers();
        for (int i = 0; i < buffers.length; ++i) {
            if (!buffers[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectBuffer(Buffer buffer) {
        Buffer oldBuffer = this.getSelectedBuffer();
        if (buffer == null || !buffer.equals(oldBuffer)) {
            EditorModel editorModel = this;
            synchronized (editorModel) {
                this.m_selectedBuffer = buffer;
            }
            if (oldBuffer != null) {
                this.fireBufferStateChanged(oldBuffer);
            }
            if (buffer != null) {
                this.fireBufferStateChanged(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeBuffer(final Buffer buffer) {
        boolean removed;
        LinkedList linkedList = this.m_bufferList;
        synchronized (linkedList) {
            removed = this.m_bufferList.remove(buffer);
        }
        if (removed) {
            File file = buffer.getFile();
            if (buffer.equals(this.getBufferForFile(file))) {
                this.m_fileBuffers.remove(file);
            }
            if (buffer.equals(this.getSelectedBuffer())) {
                Buffer bufferToSelect;
                LinkedList linkedList2 = this.m_bufferList;
                synchronized (linkedList2) {
                    int numberOfBuffers = this.m_bufferList.size();
                    bufferToSelect = numberOfBuffers > 0 ? (Buffer)this.m_bufferList.get(numberOfBuffers - 1) : null;
                }
                this.selectBuffer(bufferToSelect);
            }
            this.m_listeners.apply(new ListenerSupport.Informer(){

                public void inform(Object listener) {
                    ((Listener)listener).bufferRemoved(buffer);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getSelectedPropertiesFile() {
        EditorModel editorModel = this;
        synchronized (editorModel) {
            return this.m_selectedProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPropertiesFile(File selectedProperties) {
        EditorModel editorModel = this;
        synchronized (editorModel) {
            this.m_selectedProperties = selectedProperties;
            if (selectedProperties == null) {
                this.m_selectedFile = null;
            }
        }
        this.parseSelectedProperties(selectedProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuffer(final Buffer buffer) {
        buffer.getTextSource().addListener(new TextSource.Listener(){

            public void textSourceChanged(boolean dirtyStateChanged) {
                if (dirtyStateChanged) {
                    EditorModel.this.fireBufferStateChanged(buffer);
                }
            }
        });
        buffer.addListener(new BufferImplementation.Listener(){

            public void bufferSaved(Buffer buffer, File oldFile) {
                File newFile = buffer.getFile();
                EditorModel.this.m_agentCacheState.setNewFileTime(newFile.lastModified());
                if (!newFile.equals(oldFile)) {
                    if (oldFile != null) {
                        EditorModel.this.m_fileBuffers.remove(oldFile);
                    }
                    EditorModel.this.m_fileBuffers.put(newFile, buffer);
                    EditorModel.this.fireBufferStateChanged(buffer);
                }
                EditorModel.this.parseSelectedProperties(newFile);
            }
        });
        LinkedList linkedList = this.m_bufferList;
        synchronized (linkedList) {
            this.m_bufferList.add(buffer);
        }
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((Listener)listener).bufferAdded(buffer);
            }
        });
    }

    private void fireBufferStateChanged(final Buffer buffer) {
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((Listener)listener).bufferStateChanged(buffer);
            }
        });
    }

    private void fireBufferNotUpToDate(final Buffer buffer) {
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((Listener)listener).bufferNotUpToDate(buffer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createNewBufferName() {
        String prefix = this.m_resources.getString("newBuffer.text");
        EditorModel editorModel = this;
        synchronized (editorModel) {
            try {
                if (this.m_nextNewBufferNameIndex == 0) {
                    String string = prefix;
                    return string;
                }
                String string = prefix + " " + this.m_nextNewBufferNameIndex;
                return string;
            }
            finally {
                ++this.m_nextNewBufferNameIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSelectedProperties(File file) {
        if (file != null && file.equals(this.getSelectedPropertiesFile())) {
            File selectedFile;
            try {
                GrinderProperties properties = new GrinderProperties(file);
                selectedFile = properties.resolveRelativeFile(properties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT)).getCanonicalFile();
            }
            catch (GrinderProperties.PersistenceException e) {
                selectedFile = null;
            }
            catch (IOException e) {
                selectedFile = null;
            }
            EditorModel editorModel = this;
            synchronized (editorModel) {
                this.m_selectedFile = selectedFile;
            }
        }
    }

    public void addListener(Listener listener) {
        this.m_listeners.add(listener);
    }

    public boolean isPythonFile(File f) {
        return f != null && (!f.exists() || f.isFile()) && f.getName().toLowerCase().endsWith(".py");
    }

    public boolean isPropertiesFile(File f) {
        return f != null && (!f.exists() || f.isFile()) && f.getName().toLowerCase().endsWith(".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelectedScript(File f) {
        EditorModel editorModel = this;
        synchronized (editorModel) {
            return f != null && f.equals(this.m_selectedFile);
        }
    }

    public boolean isBoringFile(File f) {
        if (f == null) {
            return false;
        }
        String name = f.getName().toLowerCase();
        return f.isHidden() || name.endsWith(".class") || name.startsWith("~") || name.endsWith("~") || name.startsWith("#") || name.endsWith(".exe") || name.endsWith(".gif") || name.endsWith(".jpeg") || name.endsWith(".jpg") || name.endsWith(".tiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openWithExternalEditor(File file) throws ConsoleException {
        ExternalEditor externalEditor;
        EditorModel editorModel = this;
        synchronized (editorModel) {
            externalEditor = this.m_externalEditor;
        }
        if (externalEditor == null) {
            throw new DisplayMessageConsoleException(this.m_resources, "externalEditorNotSet.text");
        }
        try {
            externalEditor.open(file);
        }
        catch (IOException e) {
            throw new DisplayMessageConsoleException(this.m_resources, "externalEditError.text", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalEditor(File command, String arguments) {
        ExternalEditor externalEditor = command == null ? null : new ExternalEditor(this.m_agentCacheState, this, command, arguments);
        EditorModel editorModel = this;
        synchronized (editorModel) {
            this.m_externalEditor = externalEditor;
        }
    }

    public static abstract class AbstractListener
    implements Listener {
        public void bufferAdded(Buffer buffer) {
        }

        public void bufferStateChanged(Buffer buffer) {
        }

        public void bufferNotUpToDate(Buffer buffer) {
        }

        public void bufferRemoved(Buffer buffer) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void bufferAdded(Buffer var1);

        public void bufferStateChanged(Buffer var1);

        public void bufferNotUpToDate(Buffer var1);

        public void bufferRemoved(Buffer var1);
    }
}

